/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.collection.AggregationDescription;
import org.cristalise.kernel.collection.CollectionDescription;
import org.cristalise.kernel.collection.DependencyDescription;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.CastorHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddNewCollectionDescription
extends PredefinedStep {
    private static final Logger log = LoggerFactory.getLogger(AddNewCollectionDescription.class);

    public AddNewCollectionDescription() {
        super("Creates a new collection description in this Item");
    }

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, TransactionKey transactionKey) throws InvalidDataException, ObjectAlreadyExistsException, PersistencyException {
        CollectionDescription<?> newCollDesc;
        Object[] params = AddNewCollectionDescription.getDataList(requestData);
        log.debug("Called by {} on {} with parameters {}", new Object[]{agent.getAgentName(transactionKey), item, Arrays.toString(params)});
        if (params.length < 2 || params.length > 4) {
            throw new InvalidDataException("Invalid parameters " + Arrays.toString(params));
        }
        Object collName = params[0];
        Object collType = params[1];
        if (StringUtils.isBlank((CharSequence)collName) || StringUtils.isBlank((CharSequence)collType)) {
            throw new InvalidDataException("Collection Name and Type cannot be blank - params:" + Arrays.toString(params));
        }
        if (Gateway.getStorage().getClusterContents(item, String.valueOf((Object)ClusterType.COLLECTION) + "/" + (String)collName).length != 0) {
            throw new ObjectAlreadyExistsException("Collection '" + (String)collName + "' already exists");
        }
        if (((String)collType).equalsIgnoreCase("Aggregation")) {
            newCollDesc = this.createAggregationDescription((String[])params, (String)collName, transactionKey);
        } else if (((String)collType).equalsIgnoreCase("Dependency")) {
            newCollDesc = this.createDependencyDescription((String[])params, (String)collName, transactionKey);
        } else {
            throw new InvalidDataException("Collection type must be either Aggregation or Dependency - value:" + (String)collType);
        }
        Gateway.getStorage().put(item, newCollDesc, transactionKey);
        return requestData;
    }

    protected CollectionDescription<?> createAggregationDescription(String[] params, String collName, TransactionKey transactionKey) throws InvalidDataException {
        return new AggregationDescription(collName);
    }

    protected CollectionDescription<?> createDependencyDescription(String[] params, String collName, TransactionKey transactionKey) throws InvalidDataException {
        try {
            DependencyDescription newDepDesc = new DependencyDescription(collName);
            if (params.length > 2) {
                CastorHashMap props = (CastorHashMap)Gateway.getMarshaller().unmarshall(params[2]);
                newDepDesc.setProperties(props);
            }
            if (params.length > 3) {
                ItemPath memberPath = Gateway.getLookup().resolvePath(new DomainPath(params[3]), transactionKey);
                newDepDesc.addMember(memberPath, transactionKey);
            }
            return newDepDesc;
        }
        catch (Exception e) {
            throw new InvalidDataException(e);
        }
    }
}

