/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import org.cristalise.kernel.SystemProperties;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.lifecycle.instance.predefined.Erase;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Lookup;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.lookup.SearchFilter;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkErase
extends Erase {
    private static final Logger log = LoggerFactory.getLogger(BulkErase.class);
    public static final String description = "Deletes all Items selected bz the SearchFilter : Root Domainpath and list of Properties";
    private static final int LIMIT = SystemProperties.BulkErase_limit.getInteger();
    private static final boolean FORCE_FLAG = SystemProperties.BulkErase_force.getBoolean();

    public BulkErase() {
        super("SearchFilter", description);
    }

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException, ObjectCannotBeUpdated, CannotManageException, PersistencyException, InvalidCollectionModification, ObjectAlreadyExistsException {
        SearchFilter filter = (SearchFilter)Gateway.getMarshaller().unmarshall(requestData);
        log.debug("runActivityLogic() - item:{} filter:{} limit:{} forceFlag:{}", new Object[]{item, filter, LIMIT, FORCE_FLAG});
        int recordsDeleted = this.eraseAllItemsOfSearch(agent, filter, transactionKey, 0, LIMIT);
        filter.setRecordsFound(recordsDeleted);
        log.info("runActivityLogic() - DONE #{} items with filter:{}", (Object)filter.getRecordsFound(), (Object)filter);
        return Gateway.getMarshaller().marshall(filter);
    }

    private int eraseAllItemsOfSearch(AgentPath agent, SearchFilter filter, TransactionKey transactionKey, int offset, int limit) throws ObjectNotFoundException, ObjectCannotBeUpdated, CannotManageException, InvalidDataException, PersistencyException, InvalidCollectionModification, ObjectAlreadyExistsException {
        Lookup.PagedResult result = Gateway.getLookup().search((Path)new DomainPath(filter.getSearchRoot()), filter.getProperties(), offset, limit);
        log.debug("eraseAllItemsOfSearch() - offset:{} maxRows:{}", (Object)offset, (Object)result.maxRows);
        if (limit != 0 && offset > result.maxRows) {
            String msg = "Serious inconsistency - offset:" + offset + " > maxRows:" + result.maxRows;
            log.error("eraseAllItemsOfSearch() - {}", (Object)msg);
            throw new InvalidDataException(msg);
        }
        for (Path p : result.rows) {
            ItemPath item = ((DomainPath)p).getTarget();
            this.eraseOneItem(agent, item, FORCE_FLAG, transactionKey);
        }
        if (limit == 0) {
            return result.rows.size();
        }
        if (result.maxRows > LIMIT) {
            int recordDeleted = this.eraseAllItemsOfSearch(agent, filter, transactionKey, offset + LIMIT, LIMIT);
            return recordDeleted + LIMIT;
        }
        return result.maxRows;
    }
}

