/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.lifecycle.instance.predefined.CreateItemFromDescription;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.PropertyArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateAgentFromDescription
extends CreateItemFromDescription {
    private static final Logger log = LoggerFactory.getLogger(CreateAgentFromDescription.class);

    public CreateAgentFromDescription() {
        super("Create a new agent using this item as its description");
    }

    @Override
    protected String runActivityLogic(AgentPath agentPath, ItemPath descItemPath, int transitionID, String requestData, TransactionKey transactionKey) throws ObjectNotFoundException, InvalidDataException, ObjectAlreadyExistsException, CannotManageException, ObjectCannotBeUpdated, PersistencyException {
        String[] input = CreateAgentFromDescription.getDataList(requestData);
        String newName = input[0];
        String contextS = input[1];
        String[] roles = StringUtils.isNotBlank((CharSequence)input[2]) ? input[2].split(",") : new String[]{};
        String pwd = input.length > 3 && StringUtils.isNotBlank((CharSequence)input[3]) ? input[3] : "";
        String descVer = input.length > 4 && StringUtils.isNotBlank((CharSequence)input[4]) ? input[4] : "last";
        PropertyArrayList initProps = input.length > 5 && StringUtils.isNotBlank((CharSequence)input[5]) ? this.unmarshallInitProperties(input[5]) : new PropertyArrayList();
        String outcome = input.length > 6 && StringUtils.isNotBlank((CharSequence)input[6]) ? input[6] : "";
        ItemProxy descItem = Gateway.getProxy(descItemPath, transactionKey);
        AgentProxy agent = Gateway.getAgentProxy(agentPath, transactionKey);
        log.debug("Called by {} on {} with parameters {}", new Object[]{agent, descItem, input});
        AgentPath newAgentPath = new AgentPath(new ItemPath(), newName);
        DomainPath context = new DomainPath(new DomainPath(contextS), newName);
        if (context.exists(transactionKey)) {
            throw new ObjectAlreadyExistsException("The path " + String.valueOf(context) + " exists already.");
        }
        this.createAgentAddRoles(newAgentPath, roles, pwd, transactionKey);
        this.initialiseItem(newAgentPath, agent, descItem, initProps, outcome, newName, descVer, context, newAgentPath, transactionKey);
        if (input.length > 3) {
            input[3] = "REDACTED";
        }
        return CreateAgentFromDescription.bundleData(input);
    }

    protected void createAgentAddRoles(AgentPath newAgentPath, String[] roles, String pwd, TransactionKey transactionKey) throws CannotManageException, ObjectCannotBeUpdated, ObjectAlreadyExistsException {
        log.info("createAgentAddRoles() - Creating Agent {}", (Object)newAgentPath.getAgentName(transactionKey));
        Gateway.getLookupManager().add(newAgentPath, transactionKey);
        try {
            if (StringUtils.isNotBlank((CharSequence)pwd)) {
                Gateway.getLookupManager().setAgentPassword(newAgentPath, pwd, true, transactionKey);
            }
            for (String roleName : roles) {
                if (!StringUtils.isNotBlank((CharSequence)roleName)) continue;
                RolePath role = Gateway.getLookupManager().getRolePath(roleName, transactionKey);
                Gateway.getLookupManager().addRole(newAgentPath, role, transactionKey);
            }
        }
        catch (Exception e) {
            log.error("createAgentAddRoles()", (Throwable)e);
            Gateway.getLookupManager().delete(newAgentPath, transactionKey);
            throw new CannotManageException(e.getMessage());
        }
    }
}

