/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import com.google.common.primitives.Ints;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.SystemProperties;
import org.cristalise.kernel.collection.BuiltInCollections;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.collection.CollectionDescription;
import org.cristalise.kernel.collection.CollectionMember;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.Job;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.events.Event;
import org.cristalise.kernel.events.History;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lifecycle.CompositeActivityDef;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.Workflow;
import org.cristalise.kernel.lifecycle.instance.predefined.ItemPredefinedStepContainer;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lifecycle.instance.predefined.agent.AgentPredefinedStepContainer;
import org.cristalise.kernel.lifecycle.instance.stateMachine.StateMachine;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyArrayList;
import org.cristalise.kernel.property.PropertyDescriptionList;
import org.cristalise.kernel.property.PropertyUtility;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateItemFromDescription
extends PredefinedStep {
    private static final Logger log = LoggerFactory.getLogger(CreateItemFromDescription.class);
    private Map<String, String> cache = new ConcurrentHashMap<String, String>();
    public static final String FACTORY_GENERATED_NAME = "FACTORY_GENERATED";

    public CreateItemFromDescription(String desc) {
        super(desc);
    }

    public CreateItemFromDescription() {
        this("Create a new item using this item as its description");
    }

    private void addToCache(String key, Object obj) {
        try {
            if (SystemProperties.CreateItemFromDescription_Cache_enable.getBoolean().booleanValue()) {
                String xml = Gateway.getMarshaller().marshall(obj);
                this.cache.put(key, xml);
            }
        }
        catch (InvalidDataException e) {
            log.warn("getFromCache() - key:{}", (Object)key, (Object)e);
        }
    }

    private Object getFromCache(String key) {
        String xml = this.cache.get(key);
        if (xml != null) {
            log.trace("getFromCache() - found:{}", (Object)key);
            try {
                return Gateway.getMarshaller().unmarshall(xml);
            }
            catch (InvalidDataException e) {
                log.warn("getFromCache() - key:{}", (Object)key, (Object)e);
            }
        }
        return null;
    }

    @Override
    protected String runActivityLogic(AgentPath agentPath, ItemPath descItemPath, int transitionID, String requestData, TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException, ObjectAlreadyExistsException, CannotManageException, ObjectCannotBeUpdated, PersistencyException {
        String[] inputs = CreateItemFromDescription.getDataList(requestData);
        ItemProxy descItem = descItemPath.getProxy(transactionKey);
        AgentProxy agent = agentPath.getProxy(transactionKey);
        log.debug("Called by {} on {} with parameters {}", new Object[]{agent, descItem, inputs});
        String newName = this.getItemName(descItemPath, inputs[0], transactionKey);
        String domPath = inputs[1];
        String descVer = inputs.length > 2 && StringUtils.isNotBlank((CharSequence)inputs[2]) ? inputs[2] : "last";
        PropertyArrayList initProps = inputs.length > 3 && StringUtils.isNotBlank((CharSequence)inputs[3]) ? this.unmarshallInitProperties(inputs[3]) : new PropertyArrayList();
        String outcome = inputs.length > 4 && StringUtils.isNotBlank((CharSequence)inputs[4]) ? inputs[4] : "";
        DomainPath context = new DomainPath(new DomainPath(domPath), newName);
        if (context.exists(transactionKey)) {
            throw new ObjectAlreadyExistsException("The path " + String.valueOf(context) + " exists already.");
        }
        ItemPath newItemPath = new ItemPath();
        log.info("Creating Item name:{} uuid:{} transactionKey:{}", new Object[]{newName, newItemPath, transactionKey});
        Gateway.getLookupManager().add(newItemPath, transactionKey);
        this.initialiseItem(newItemPath, agent, descItem, initProps, outcome, newName, descVer, context, newItemPath, transactionKey);
        inputs[0] = newName;
        return CreateItemFromDescription.bundleData(inputs);
    }

    public String getItemName(ItemPath descItemPath, String newName, TransactionKey transactionKey) throws InvalidDataException, PersistencyException, ObjectCannotBeUpdated, ObjectNotFoundException {
        if (FACTORY_GENERATED_NAME.equals(newName)) {
            try {
                Integer lastCount;
                String prefix = PropertyUtility.getPropertyValue(descItemPath, BuiltInItemProperties.ID_PREFIX, "", transactionKey);
                Integer padSize = Integer.valueOf(PropertyUtility.getPropertyValue(descItemPath, BuiltInItemProperties.LEFT_PAD_SIZE, (String)null, transactionKey));
                log.debug("getItemName() - generating name prefix:{}, padSize:{}", (Object)prefix, (Object)padSize);
                if (StringUtils.isBlank((CharSequence)prefix) || padSize == null) {
                    throw new InvalidDataException("Item:" + descItemPath.getItemName() + " property '" + String.valueOf((Object)BuiltInItemProperties.ID_PREFIX) + "' and '" + String.valueOf((Object)BuiltInItemProperties.LEFT_PAD_SIZE) + "' must contain value");
                }
                Integer n = lastCount = Integer.valueOf(PropertyUtility.getPropertyValue(descItemPath, BuiltInItemProperties.LAST_COUNT, "0", transactionKey));
                lastCount = lastCount + 1;
                PropertyUtility.writeProperty(descItemPath, BuiltInItemProperties.LAST_COUNT, lastCount.toString(), transactionKey);
                return prefix + StringUtils.leftPad((String)lastCount.toString(), (int)padSize, (String)"0");
            }
            catch (NumberFormatException e) {
                String msg = "Item:" + descItemPath.getItemName() + " properties:'" + String.valueOf((Object)BuiltInItemProperties.LAST_COUNT) + "','" + String.valueOf((Object)BuiltInItemProperties.LEFT_PAD_SIZE) + "' must contain integer value";
                log.error(msg, (Throwable)e);
                throw new InvalidDataException(msg, (Throwable)e);
            }
        }
        if (StringUtils.isBlank((CharSequence)newName) || StringUtils.equalsAny((CharSequence)newName, (CharSequence[])new CharSequence[]{"string", "null"})) {
            throw new InvalidDataException("Name must be provided");
        }
        return newName;
    }

    protected void initialiseItem(ItemPath newItem, AgentProxy agent, ItemProxy descItem, PropertyArrayList initProps, String outcome, String newName, String descVer, DomainPath context, ItemPath newItemPath, TransactionKey transactionKey) throws ObjectCannotBeUpdated, CannotManageException, InvalidDataException, ObjectAlreadyExistsException, PersistencyException, ObjectNotFoundException {
        log.info("initialiseItem() - Initializing Item:" + newName);
        try {
            PropertyArrayList newProps = this.instantiateProperties(descItem, descVer, initProps, newName, transactionKey);
            CollectionArrayList newColls = this.instantiateCollections(descItem, descVer, newProps, transactionKey);
            CompositeActivity newWorkflow = this.instantiateWorkflow(descItem, descVer, transactionKey);
            Viewpoint newViewpoint = this.instantiateViewpoint(descItem, descVer, transactionKey);
            CreateItemFromDescription.storeItem(agent.getPath(), newItem, newProps, newColls, newWorkflow, newViewpoint, outcome, transactionKey);
        }
        catch (InvalidDataException | ObjectNotFoundException | PersistencyException e) {
            if (log.isDebugEnabled()) {
                log.error("initialiseItem()", (Throwable)e);
            }
            Gateway.getLookupManager().delete(newItemPath, transactionKey);
            throw e;
        }
        log.debug("initialiseItem() - Creating " + String.valueOf(context));
        context.setItemPath(newItemPath);
        Gateway.getLookupManager().add(context, transactionKey);
    }

    protected PropertyArrayList unmarshallInitProperties(String initPropString) throws InvalidDataException {
        return (PropertyArrayList)Gateway.getMarshaller().unmarshall(initPropString);
    }

    protected PropertyArrayList instantiateProperties(ItemProxy descItem, String descVer, PropertyArrayList initProps, String newName, TransactionKey transactionKey) throws ObjectNotFoundException, InvalidDataException {
        String type = descItem.getType(transactionKey);
        String cacheKey = String.valueOf((Object)ClusterType.PROPERTY) + "/" + type + ":" + descVer;
        PropertyArrayList props = (PropertyArrayList)this.getFromCache(cacheKey);
        if (props == null) {
            PropertyDescriptionList pdList = PropertyUtility.getPropertyDescriptionOutcome(descItem.getPath(), descVer, transactionKey);
            props = pdList.instantiate(initProps);
            this.addToCache(cacheKey, props);
        }
        boolean foundName = false;
        for (Property prop : props.list) {
            if (!prop.getName().equals(BuiltInItemProperties.NAME.toString())) continue;
            foundName = true;
            prop.setValue(newName);
            break;
        }
        if (!foundName) {
            props.list.add(new Property(BuiltInItemProperties.NAME, newName, true));
        }
        return props;
    }

    protected CompositeActivity instantiateWorkflow(ItemProxy descItem, String descVer, TransactionKey transactionKey) throws ObjectNotFoundException, InvalidDataException, PersistencyException {
        Collection<?> wfCol = descItem.getCollection(BuiltInCollections.WORKFLOW, Ints.tryParse((String)descVer), transactionKey);
        CollectionMember wfMember = (CollectionMember)wfCol.getMembers().list.get(0);
        String wfDefName = wfMember.resolveItem(transactionKey).getName(transactionKey);
        Object wfVerObj = wfMember.getProperties().getBuiltInProperty(BuiltInVertexProperties.VERSION);
        if (wfVerObj == null || String.valueOf(wfVerObj).length() == 0) {
            throw new InvalidDataException("Workflow version number not set");
        }
        try {
            Integer wfDefVer = Integer.parseInt(wfVerObj.toString());
            if (wfDefName == null) {
                throw new InvalidDataException("No workflow given or defined");
            }
            String cacheKey = String.valueOf((Object)ClusterType.LIFECYCLE) + "/" + wfDefName + ":" + wfDefVer;
            CompositeActivity ca = (CompositeActivity)this.getFromCache(cacheKey);
            if (ca == null) {
                CompositeActivityDef wfDef = (CompositeActivityDef)LocalObjectLoader.getActDef(wfDefName, wfDefVer, transactionKey);
                ca = (CompositeActivity)wfDef.instantiate(transactionKey);
                this.addToCache(cacheKey, ca);
            }
            return ca;
        }
        catch (NumberFormatException ex) {
            throw new InvalidDataException("Invalid workflow version number: " + wfVerObj.toString());
        }
        catch (ClassCastException ex) {
            log.error("Activity def '" + wfDefName + "' was not Composite", (Throwable)ex);
            throw new InvalidDataException("Activity def '" + wfDefName + "' was not Composite");
        }
    }

    protected CollectionArrayList instantiateCollections(ItemProxy descItem, String descVer, PropertyArrayList newProps, TransactionKey transactionKey) throws ObjectNotFoundException, PersistencyException, InvalidDataException {
        String[] collNames;
        CollectionArrayList colls = new CollectionArrayList();
        for (String collName : collNames = descItem.getContents(ClusterType.COLLECTION, transactionKey)) {
            String cacheKey = String.valueOf((Object)ClusterType.COLLECTION) + "/" + collName + ":" + descVer;
            Collection aColl = (Collection)this.getFromCache(cacheKey);
            if (aColl == null) {
                Collection<?> newColl = CreateItemFromDescription.instantiateCollection(collName, descItem, descVer, newProps, transactionKey);
                if (newColl == null) continue;
                colls.put(newColl);
                this.addToCache(cacheKey, newColl);
                continue;
            }
            colls.put(aColl);
        }
        return colls;
    }

    public static Collection<?> instantiateCollection(String collName, ItemProxy descItem, String descVer, PropertyArrayList newProps, TransactionKey transactionKey) throws PersistencyException, ObjectNotFoundException, InvalidDataException {
        Collection<?> collOfDesc = descItem.getCollection(collName, Ints.tryParse((String)descVer), transactionKey);
        Collection newColl = null;
        if (collOfDesc instanceof CollectionDescription) {
            log.debug("instantiateCollection() - Instantiating CollectionDescription:" + collName);
            CollectionDescription collDesc = (CollectionDescription)((Object)collOfDesc);
            newColl = collDesc.newInstance(transactionKey);
        } else if (collOfDesc instanceof Dependency) {
            log.debug("instantiateCollection() - Instantiating Dependency:" + collName);
            ((Dependency)collOfDesc).addToItemProperties(newProps, transactionKey);
        } else {
            throw new InvalidDataException("CANNOT instantiate collection:" + collName + " class:" + collOfDesc.getClass().getName());
        }
        return newColl;
    }

    protected Viewpoint instantiateViewpoint(ItemProxy descItem, String descVer, TransactionKey transactionKey) throws ObjectNotFoundException, InvalidDataException, PersistencyException {
        if (descItem.getContents(String.valueOf((Object)ClusterType.COLLECTION) + "/" + String.valueOf((Object)BuiltInCollections.SCHEMA_INITIALISE), transactionKey).length == 0) {
            return null;
        }
        Collection<?> thisCol = descItem.getCollection(BuiltInCollections.SCHEMA_INITIALISE, Ints.tryParse((String)descVer), transactionKey);
        CollectionMember schemaMember = (CollectionMember)thisCol.getMembers().list.get(0);
        String schemaName = schemaMember.resolveItem(transactionKey).getName();
        Object schemaVerObj = schemaMember.getProperties().getBuiltInProperty(BuiltInVertexProperties.VERSION);
        Object viewNameObj = schemaMember.getProperties().get("View");
        if (schemaName == null) {
            throw new InvalidDataException("No schema given or defined");
        }
        if (schemaVerObj == null || String.valueOf(schemaVerObj).length() == 0) {
            throw new InvalidDataException("schema version number not set");
        }
        try {
            Integer schemaVer = Integer.parseInt(schemaVerObj.toString());
            String viewName = viewNameObj == null ? "last" : viewNameObj.toString();
            return new Viewpoint(new ItemPath(), schemaName, viewName, schemaVer, -1);
        }
        catch (NumberFormatException ex) {
            throw new InvalidDataException("Invalid schema version number: " + schemaVerObj.toString());
        }
    }

    public static void storeItem(AgentPath agent, ItemPath item, PropertyArrayList props, CollectionArrayList colls, CompositeActivity ca, Viewpoint initViewpoint, String initOutcomeString, TransactionKey transactionKey) throws PersistencyException, ObjectNotFoundException, InvalidDataException {
        ItemPredefinedStepContainer cont;
        for (Property thisProp : props.list) {
            Gateway.getStorage().put(item, thisProp, transactionKey);
        }
        History hist = new History(item, transactionKey);
        Schema initSchema = LocalObjectLoader.getSchema("ItemInitialization", 0, transactionKey);
        Outcome initOutcome = new Outcome(0, Gateway.getMarshaller().marshall(props), initSchema);
        StateMachine predefSm = LocalObjectLoader.getStateMachine("PredefinedStep", 0, transactionKey);
        Event newEvent = hist.addEvent(agent, "", "Initialize", "", "", initSchema, predefSm, 0, "last");
        initOutcome.setID(newEvent.getID());
        Viewpoint newLastView = new Viewpoint(item, initSchema, "last", newEvent.getID());
        Gateway.getStorage().put(item, initOutcome, transactionKey);
        Gateway.getStorage().put(item, newLastView, transactionKey);
        if (initViewpoint != null) {
            Schema schema = LocalObjectLoader.getSchema(initViewpoint.getSchemaName(), initViewpoint.getSchemaVersion(), transactionKey);
            Outcome outcome = new Outcome(-1, initOutcomeString, schema);
            outcome.validateAndCheck();
            initViewpoint.setItemPath(item);
            Event intiEvent = hist.addEvent(agent, "", "Constructor", "", "", schema, predefSm, 0, initViewpoint.getName());
            initViewpoint.setEventId(intiEvent.getID());
            outcome.setID(intiEvent.getID());
            Gateway.getStorage().put(item, outcome, transactionKey);
            Gateway.getStorage().put(item, initViewpoint, transactionKey);
        }
        if (colls != null) {
            for (Collection thisColl : colls.list) {
                Gateway.getStorage().put(item, thisColl, transactionKey);
            }
        }
        Workflow wf = null;
        ItemPredefinedStepContainer itemPredefinedStepContainer = cont = item instanceof AgentPath ? new AgentPredefinedStepContainer() : new ItemPredefinedStepContainer();
        if (ca == null) {
            log.warn("storeItem({}) - CompositeActivity was null. Creating workflow with empty domain CompAct.", (Object)item);
            wf = new Workflow(new CompositeActivity(), cont);
        } else {
            wf = new Workflow(ca, cont);
        }
        wf.initialise(item, agent, transactionKey);
        Gateway.getStorage().removeCluster(item, ClusterType.JOB, transactionKey);
        List newJobs = ((CompositeActivity)wf.search("workflow/domain")).calculateJobs(agent, item, true);
        for (Job newJob : newJobs) {
            Gateway.getStorage().put(item, newJob, transactionKey);
            if (!StringUtils.isNotBlank((CharSequence)newJob.getRoleOverride())) continue;
            newJob.sendToRoleChannel();
        }
        Gateway.getStorage().put(item, wf, transactionKey);
    }
}

