/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.util.Arrays;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateNewCollectionVersion
extends PredefinedStep {
    private static final Logger log = LoggerFactory.getLogger(CreateNewCollectionVersion.class);

    public CreateNewCollectionVersion() {
        super("Creates a new numbered collection version in this Item from the current one.");
    }

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, TransactionKey transactionKey) throws InvalidDataException, PersistencyException, ObjectNotFoundException {
        int newVersion;
        Object[] params = CreateNewCollectionVersion.getDataList(requestData);
        log.debug("Called by {} on {} with parameters {}", new Object[]{agent.getAgentName(transactionKey), item, params});
        if (params.length == 0 || params.length > 2) {
            throw new InvalidDataException("CreateNewCollectionVersion: Invalid parameters " + Arrays.toString(params));
        }
        Object collName = params[0];
        Collection coll = (Collection)Gateway.getStorage().get(item, String.valueOf((Object)ClusterType.COLLECTION) + "/" + (String)collName + "/last", transactionKey);
        if (params.length > 1) {
            newVersion = Integer.valueOf((String)params[1]);
        } else {
            String[] versions = Gateway.getStorage().getClusterContents(item, String.valueOf((Object)ClusterType.COLLECTION) + "/" + (String)collName, transactionKey);
            int lastVer = -1;
            for (String thisVerStr : versions) {
                try {
                    int thisVer = Integer.parseInt(thisVerStr);
                    if (thisVer <= lastVer) continue;
                    lastVer = thisVer;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            newVersion = lastVer + 1;
        }
        Gateway.getStorage().clearCache(item, String.valueOf((Object)ClusterType.COLLECTION) + "/" + (String)collName + "/last");
        coll.setVersion(newVersion);
        Gateway.getStorage().put(item, coll, transactionKey);
        return requestData;
    }
}

