/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.util.Collections;
import java.util.ListIterator;
import org.cristalise.kernel.SystemProperties;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.collection.DependencyMember;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.CriseVertxException;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lifecycle.instance.predefined.RemoveMembersFromCollection;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Lookup;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.CastorHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Erase
extends PredefinedStep {
    private static final Logger log = LoggerFactory.getLogger(Erase.class);
    public static final String description = "Deletes all domain paths (aliases), roles (if agent) and clusters for this item or agent.";
    private static final boolean FORCE_FLAG = SystemProperties.Erase_force.getBoolean();

    public Erase(String schema, String desc) {
        super(schema, desc);
    }

    public Erase(String desc) {
        this(null, desc);
    }

    public Erase() {
        this(null, description);
    }

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, TransactionKey transactionKey) throws InvalidDataException, InvalidCollectionModification, ObjectNotFoundException, ObjectCannotBeUpdated, CannotManageException, PersistencyException, ObjectAlreadyExistsException {
        String itemName = item.getItemName(transactionKey);
        this.eraseOneItem(agent, item, FORCE_FLAG, transactionKey);
        log.info("runActivityLogic() - DONE agent:{} item:{}", (Object)agent.getAgentName(transactionKey), (Object)itemName);
        return requestData;
    }

    protected void eraseOneItem(AgentPath agentP, ItemPath itemP, boolean forceFlag, TransactionKey transactionKey) throws ObjectNotFoundException, ObjectCannotBeUpdated, CannotManageException, InvalidDataException, PersistencyException, InvalidCollectionModification, ObjectAlreadyExistsException {
        String itemName = itemP.getItemName(transactionKey);
        this.removeBidirectionalReferences(agentP, itemP, forceFlag, transactionKey);
        this.removeAliases(itemP, transactionKey);
        this.removeRolesIfAgent(itemP, transactionKey);
        Gateway.getStorage().removeCluster(itemP, transactionKey);
        log.trace("eraseOneItem() - DONE uuid:{} name:{}", (Object)itemP, (Object)itemName);
    }

    protected void removeBidirectionalReferences(AgentPath agentP, ItemPath itemP, boolean forceFlag, TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException, InvalidCollectionModification, ObjectAlreadyExistsException {
        String[] collNames;
        ItemProxy item = Gateway.getProxy(itemP, transactionKey);
        for (String collName : collNames = item.getContents(ClusterType.COLLECTION, transactionKey)) {
            Dependency myDep = (Dependency)item.getCollection(collName, transactionKey);
            if (myDep.getType() != Collection.Type.Bidirectional) continue;
            this.triggerRemoveMembersFromCollection(agentP, itemP, myDep, forceFlag, transactionKey);
        }
    }

    private void triggerRemoveMembersFromCollection(AgentPath agentP, ItemPath itemP, Dependency myDep, boolean forceFlag, TransactionKey transactionKey) throws InvalidDataException, InvalidCollectionModification, ObjectAlreadyExistsException {
        for (DependencyMember member : myDep.getMembers().list) {
            String toDependencyName = myDep.getToDependencyName(member.getItemPath(), transactionKey);
            Dependency toDep = new Dependency(toDependencyName);
            CastorHashMap memberProps = member.getProperties();
            memberProps.setBuiltInProperty(BuiltInVertexProperties.DEPENDENCY_TO, (Object)myDep.getName());
            DependencyMember newMember = toDep.addMember(itemP, memberProps, member.getClassProps(), null);
            newMember.setID(-1);
            String dependencyString = Gateway.getMarshaller().marshall(toDep);
            try {
                new RemoveMembersFromCollection().request(agentP, member.getItemPath(), dependencyString, transactionKey);
            }
            catch (InvalidCollectionModification | InvalidDataException e) {
                if (forceFlag) {
                    log.info("triggerRemoveMembersFromCollection()", (Throwable)e);
                    continue;
                }
                throw e;
            }
            catch (CriseVertxException e) {
                if (forceFlag) {
                    log.info("triggerRemoveMembersFromCollection()", (Throwable)e);
                    continue;
                }
                throw new InvalidDataException(e);
            }
        }
    }

    protected void removeAliases(ItemPath item, TransactionKey transactionKey) throws ObjectCannotBeUpdated, CannotManageException {
        Lookup.PagedResult domPaths = Gateway.getLookup().searchAliases(item, 0, 0, transactionKey);
        Collections.sort(domPaths.rows, (o1, o2) -> o1.getStringPath().compareTo(o2.getStringPath()));
        ListIterator<Path> listIter = domPaths.rows.listIterator(domPaths.rows.size());
        while (listIter.hasPrevious()) {
            DomainPath path = (DomainPath)listIter.previous();
            log.debug("removeAliases() - path:{}", (Object)path);
            Gateway.getLookupManager().delete(path, transactionKey);
        }
    }

    protected void removeRolesIfAgent(ItemPath item, TransactionKey transactionKey) throws ObjectCannotBeUpdated, ObjectNotFoundException, CannotManageException {
        try {
            AgentPath targetAgent = new AgentPath(item);
            if (targetAgent.getAgentName(transactionKey) != null) {
                for (RolePath role : targetAgent.getRoles(transactionKey)) {
                    Gateway.getLookupManager().removeRole(targetAgent, role, transactionKey);
                }
            }
        }
        catch (InvalidItemPathException invalidItemPathException) {
            // empty catch block
        }
    }
}

