/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.util.Arrays;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.events.Event;
import org.cristalise.kernel.events.History;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterStorageManager;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.DateUtility;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Import
extends PredefinedStep {
    private static final Logger log = LoggerFactory.getLogger(Import.class);

    public Import() {
        super("Imports an outcome into the Item, with a given schema and viewpoint");
    }

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, TransactionKey transactionKey) throws InvalidDataException, PersistencyException, ObjectNotFoundException {
        int schemaVersion;
        Object[] params = Import.getDataList(requestData);
        log.debug("Called by {} on {} with parameters {}", new Object[]{agent.getAgentName(transactionKey), item, params});
        int split1 = params[0].indexOf(95);
        int split2 = params[0].indexOf(58);
        if (split1 == -1) {
            throw new InvalidDataException("Import: Invalid parameters " + Arrays.toString(params));
        }
        requestData = params[1];
        String viewpoint = null;
        String schemaName = ((String)params[0]).substring(0, split1);
        if (split2 > -1) {
            schemaVersion = Integer.parseInt(((String)params[0]).substring(split1 + 1, split2));
            viewpoint = ((String)params[0]).substring(split2 + 1);
        } else {
            schemaVersion = Integer.parseInt(((String)params[0]).substring(split1 + 1));
        }
        Schema schema = LocalObjectLoader.getSchema(schemaName, schemaVersion, transactionKey);
        Object timestamp = params.length == 3 ? params[2] : DateUtility.timeToString(DateUtility.getNow());
        ClusterStorageManager storage = Gateway.getStorage();
        History hist = new History(item, transactionKey);
        Event event = hist.addEvent(agent, this.getCurrentAgentRole(), this.getName(), this.getPath(), this.getType(), schema, this.getStateMachine(), transitionID, viewpoint, (String)timestamp);
        try {
            storage.put(item, new Outcome((int)event.getID(), requestData, schema), transactionKey);
            storage.put(item, new Viewpoint(item, schema, viewpoint, event.getID()), transactionKey);
            if (!"last".equals(viewpoint)) {
                storage.put(item, new Viewpoint(item, schema, "last", event.getID()), transactionKey);
            }
        }
        catch (PersistencyException e) {
            storage.abort(transactionKey);
            throw e;
        }
        return requestData;
    }
}

