/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.collection.DependencyMember;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lifecycle.instance.Activity;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.scripting.ScriptingEngineException;
import org.cristalise.kernel.utils.CastorHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public abstract class ManageMembersOfCollectionBase
extends PredefinedStep {
    private static final Logger log = LoggerFactory.getLogger(ManageMembersOfCollectionBase.class);

    public ManageMembersOfCollectionBase(String schemaName, String description) {
        super(schemaName, description);
    }

    public ManageMembersOfCollectionBase(String schemaName) {
        this(schemaName, null);
    }

    protected void evaluateScript(ItemPath item, String propertyValue, CastorHashMap scriptProps, TransactionKey transactionKey) throws ObjectNotFoundException, InvalidDataException, InvalidCollectionModification {
        if (StringUtils.isBlank((CharSequence)propertyValue) || !propertyValue.contains(":")) {
            throw new InvalidDataException(this.getClass().getSimpleName() + " cannot resolve Script from '" + propertyValue + "' value");
        }
        String[] tokens = propertyValue.split(":");
        try {
            Script script = Script.getScript(tokens[0], Integer.valueOf(tokens[1]));
            script.evaluate(item, scriptProps, this.getActContext(), transactionKey);
        }
        catch (ScriptingEngineException e) {
            log.error("evaluateScript() - failed to execute script:{}", (Object)propertyValue, (Object)e);
            throw new InvalidCollectionModification(e);
        }
    }

    protected void checkCardinatilyConstraint(Dependency currentDependency, Dependency inputDependency, ItemPath itemPath, TransactionKey transactionKey) throws InvalidDataException, InvalidCollectionModification {
        Collection.Cardinality currentDepCardinality = currentDependency.getCardinality();
        if (currentDepCardinality != null) {
            switch (currentDepCardinality) {
                case OneToOne: 
                case ManyToOne: 
                case OneToMany: 
                case ManyToMany: {
                    log.trace("checkCardinatilyConstraint() - NO check was implemented");
                    break;
                }
                default: {
                    String msg = "Unknown cardinality - " + String.valueOf(currentDependency) + " of item " + String.valueOf(itemPath);
                    log.error("checkCardinatilyConstraint() - {}", (Object)msg);
                    throw new InvalidDataException(msg);
                }
            }
        }
    }

    protected Dependency addCurrentDependencyUpdate(ItemPath currentItem, Node dependencyNode) throws InvalidDataException {
        String dependencyString = Outcome.serialize(dependencyNode, false);
        this.getAutoUpdates().put(currentItem, dependencyString);
        if (log.isTraceEnabled()) {
            log.trace("addCurrentDependencyUpdate() - currentItem:{} outcome:{}", (Object)currentItem.getItemName(), (Object)dependencyString);
        }
        return (Dependency)Gateway.getMarshaller().unmarshall(dependencyString);
    }

    private void addUpdates_DependencyTo(ItemPath currentItem, Dependency currentDependency, Dependency inputDependency, TransactionKey transactionKey) throws InvalidDataException, InvalidCollectionModification, ObjectAlreadyExistsException {
        String toDependencyName = currentDependency.getToDependencyName(currentItem, transactionKey);
        for (DependencyMember inputMember : inputDependency.getMembers().list) {
            Dependency toDep = new Dependency(toDependencyName);
            CastorHashMap inputMemberProps = inputMember.getProperties();
            inputMemberProps.setBuiltInProperty(BuiltInVertexProperties.DEPENDENCY_TO, (Object)currentDependency.getName());
            toDep.addMember(currentItem, inputMemberProps, inputMember.getClassProps(), null);
            String dependencyString = Gateway.getMarshaller().marshall(toDep);
            if (log.isTraceEnabled()) {
                log.trace("addUpdates_DependencyTo() - toItem:{} outcome:{}", (Object)inputMember.getItemPath().getItemName(), (Object)dependencyString);
            }
            this.getAutoUpdates().put(inputMember.getItemPath(), dependencyString);
        }
    }

    @Override
    public void computeUpdates(ItemPath currentItemPath, Activity currentActivity, Node inputNode, TransactionKey transactionKey) throws InvalidDataException, PersistencyException, ObjectNotFoundException, ObjectAlreadyExistsException, InvalidCollectionModification {
        Dependency inputDependency;
        ItemProxy item = Gateway.getProxy(currentItemPath, transactionKey);
        Dependency currentDependency = (Dependency)item.getCollection((inputDependency = this.addCurrentDependencyUpdate(currentItemPath, inputNode)).getName(), null, transactionKey);
        Collection.Type currentDepType = currentDependency.getType();
        if (currentDepType != null && currentDepType == Collection.Type.Bidirectional) {
            this.addUpdates_DependencyTo(currentItemPath, currentDependency, inputDependency, transactionKey);
        }
    }
}

