/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.util.Arrays;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveDomainPath
extends PredefinedStep {
    private static final Logger log = LoggerFactory.getLogger(RemoveDomainPath.class);

    public RemoveDomainPath() {
        super("Removes an existing path to this item from the LDAP domain tree");
    }

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException, ObjectCannotBeUpdated, CannotManageException {
        Object[] params = RemoveDomainPath.getDataList(requestData);
        log.debug("Called by {} on {} with parameters {}", new Object[]{agent.getAgentName(transactionKey), item, params});
        if (params.length != 1) {
            throw new InvalidDataException("RemoveDomainPath: Invalid parameters " + Arrays.toString(params));
        }
        DomainPath domainPath = new DomainPath((String)params[0]);
        if (!domainPath.exists(transactionKey)) {
            throw new ObjectNotFoundException("RemoveDomainPath: Domain path " + String.valueOf(domainPath) + " does not exist.");
        }
        if (!domainPath.getItemPath(transactionKey).equals(item)) {
            throw new InvalidDataException("RemoveDomainPath: Domain path " + String.valueOf(domainPath) + " is not an alias of the current Item " + String.valueOf(item));
        }
        Gateway.getLookupManager().delete(domainPath, transactionKey);
        return requestData;
    }
}

