/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.collection.DependencyMember;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lifecycle.instance.predefined.ManageMembersOfCollectionBase;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.CastorHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveMembersFromCollection
extends ManageMembersOfCollectionBase {
    private static final Logger log = LoggerFactory.getLogger(RemoveMembersFromCollection.class);
    public static final String description = "Removes many members from the named Collection of the Item";

    public RemoveMembersFromCollection() {
        super("Dependency", description);
    }

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath itemPath, int transitionID, String requestData, TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException, PersistencyException, InvalidCollectionModification {
        ItemProxy item = Gateway.getProxy(itemPath);
        Dependency inputDependendy = (Dependency)Gateway.getMarshaller().unmarshall(requestData);
        String collectionName = inputDependendy.getName();
        Dependency currentDependency = (Dependency)item.getCollection(collectionName, null, transactionKey);
        log.debug("runActivityLogic() - {} of item {}", (Object)currentDependency, (Object)itemPath);
        this.checkCardinatilyConstraint(currentDependency, inputDependendy, itemPath, transactionKey);
        for (DependencyMember inputMember : inputDependendy.getMembers().list) {
            this.evaluateScript(itemPath, currentDependency, inputMember, transactionKey);
            DependencyMember removedMember = null;
            removedMember = inputMember.getID() != -1 ? (DependencyMember)currentDependency.removeMember(inputMember.getID()) : (DependencyMember)currentDependency.removeMember(inputMember.getItemPath());
            if (!(inputMember.getItemPath() != null & !removedMember.getItemPath().equals(inputMember.getItemPath()))) continue;
            throw new InvalidDataException("MemberID is inconsistent with ItemPath");
        }
        Gateway.getStorage().put(itemPath, currentDependency, transactionKey);
        return Gateway.getMarshaller().marshall(currentDependency);
    }

    protected void evaluateScript(ItemPath item, Dependency dependency, DependencyMember newMember, TransactionKey transactionKey) throws ObjectNotFoundException, InvalidDataException, InvalidCollectionModification {
        if (dependency.containsBuiltInProperty(BuiltInVertexProperties.MEMBER_REMOVE_SCRIPT)) {
            CastorHashMap scriptProps = new CastorHashMap();
            scriptProps.put("collection", dependency);
            scriptProps.put("member", newMember);
            this.evaluateScript(item, (String)dependency.getBuiltInProperty(BuiltInVertexProperties.MEMBER_REMOVE_SCRIPT), scriptProps, transactionKey);
        }
    }
}

