/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.util.Arrays;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveViewpoint
extends PredefinedStep {
    private static final Logger log = LoggerFactory.getLogger(RemoveViewpoint.class);
    public static final String description = "Removes a viewpoint from the Item";

    public RemoveViewpoint() {
        super(description);
    }

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException, PersistencyException {
        Object[] params = RemoveViewpoint.getDataList(requestData);
        log.debug("Called by {} on {} with parameters {}", new Object[]{agent.getAgentName(transactionKey), item, params});
        if (params.length != 2) {
            throw new InvalidDataException("RemoveViewpoint: Invalid parameters " + Arrays.toString(params));
        }
        String schemaName = params[0];
        Object viewName = params[1];
        Gateway.getStorage().remove(item, String.valueOf((Object)ClusterType.VIEWPOINT) + "/" + schemaName + "/" + (String)viewName, transactionKey);
        return requestData;
    }
}

