/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.Job;
import org.cristalise.kernel.graph.model.GraphPoint;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.Workflow;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceDomainWorkflow
extends PredefinedStep {
    private static final Logger log = LoggerFactory.getLogger(ReplaceDomainWorkflow.class);

    public ReplaceDomainWorkflow() {
        super("Replaces the domain CA with the supplied one. Used by the GUI to save new Wf layout");
    }

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, TransactionKey transactionKey) throws InvalidDataException, PersistencyException, ObjectNotFoundException {
        Workflow lifeCycle = this.getWf();
        Object[] params = ReplaceDomainWorkflow.getDataList(requestData);
        log.debug("Called by {} on {} with parameters {}", new Object[]{agent.getAgentName(transactionKey), item, params});
        if (params.length != 1) {
            throw new InvalidDataException("ReplaceDomainWorkflow: Invalid parameters " + Arrays.toString(params));
        }
        lifeCycle.getChildrenGraphModel().removeVertex(lifeCycle.search("workflow/domain"));
        CompositeActivity domain = (CompositeActivity)Gateway.getMarshaller().unmarshall((String)params[0]);
        domain.setName("domain");
        lifeCycle.initChild(domain, true, new GraphPoint(150, 100));
        if (!domain.active) {
            lifeCycle.run(transactionKey);
        }
        Gateway.getStorage().put(item, lifeCycle, transactionKey);
        Gateway.getStorage().removeCluster(item, ClusterType.JOB, transactionKey);
        List newJobs = ((CompositeActivity)lifeCycle.search("workflow/domain")).calculateJobs(agent, item, true);
        for (Job newJob : newJobs) {
            Gateway.getStorage().put(item, newJob, transactionKey);
            if (!StringUtils.isNotBlank((CharSequence)newJob.getRoleOverride())) continue;
            newJob.sendToRoleChannel();
        }
        return requestData;
    }
}

