/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.util.Arrays;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.property.PropertyUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteProperty
extends PredefinedStep {
    private static final Logger log = LoggerFactory.getLogger(WriteProperty.class);

    public WriteProperty() {
        super("Writes a property to the Item");
    }

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, TransactionKey transactionKey) throws InvalidDataException, ObjectCannotBeUpdated, ObjectNotFoundException, PersistencyException {
        Object[] params = WriteProperty.getDataList(requestData);
        log.debug("Called by {} on {} with parameters {}", new Object[]{agent.getAgentName(transactionKey), item, params});
        if (params.length != 2) {
            throw new InvalidDataException("WriteProperty: invalid parameters " + Arrays.toString(params));
        }
        String name = params[0];
        Object value = params[1];
        PropertyUtility.writeProperty(item, name, (String)value, transactionKey);
        return requestData;
    }

    @Deprecated
    public static void write(ItemPath item, String name, String value, TransactionKey transactionKey) throws PersistencyException, ObjectCannotBeUpdated, ObjectNotFoundException {
        PropertyUtility.writeProperty(item, name, value, transactionKey);
    }
}

