/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.events.Event;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteViewpoint
extends PredefinedStep {
    private static final Logger log = LoggerFactory.getLogger(WriteViewpoint.class);

    public WriteViewpoint() {
        super("Writes a viewpoint to the Item");
    }

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException, PersistencyException {
        int eventId;
        Object[] params = WriteViewpoint.getDataList(requestData);
        log.debug("Called by {} on {} with parameters {}", new Object[]{agent.getAgentName(), item, params});
        if (params.length != 3) {
            throw new InvalidDataException("WriteViewpoint: Invalid parameters " + Arrays.toString(params));
        }
        String schemaName = params[0];
        Object viewName = params[1];
        try {
            eventId = Integer.parseInt((String)params[2]);
        }
        catch (NumberFormatException ex) {
            throw new InvalidDataException("WriteViewpoint: Parameter 3 (EventId) must be an integer");
        }
        WriteViewpoint.write(item, schemaName, (String)viewName, eventId, transactionKey);
        return requestData;
    }

    public static void write(ItemPath item, String schemaName, String viewName, int eventId, TransactionKey transactionKey) throws PersistencyException, ObjectNotFoundException, InvalidDataException {
        Event event = (Event)Gateway.getStorage().get(item, String.valueOf((Object)ClusterType.HISTORY) + "/" + eventId, transactionKey);
        if (StringUtils.isBlank((CharSequence)event.getSchemaName())) {
            throw new InvalidDataException("Event " + eventId + " does not reference an Outcome, so cannot be assigned to a Viewpoint.");
        }
        Schema thisSchema = LocalObjectLoader.getSchema(schemaName, event.getSchemaVersion(), transactionKey);
        if (!event.getSchemaName().equals(thisSchema.getItemID())) {
            throw new InvalidDataException("Event outcome schema is " + event.getSchemaName() + ", and cannot be used for a " + schemaName + " Viewpoint");
        }
        Gateway.getStorage().put(item, new Viewpoint(item, thisSchema, viewName, eventId), transactionKey);
    }
}

