/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined.agent;

import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Authenticate
extends PredefinedStep {
    private static final Logger log = LoggerFactory.getLogger(Authenticate.class);
    public static final String description = "Records the Login event in the history. Login is assocated with user sessions with tokens validity";
    public static final String REDACTED = "REDACTED";

    public Authenticate(String schema, String desc) {
        super(schema, desc);
    }

    public Authenticate(String desc) {
        this(null, desc);
    }

    public Authenticate() {
        this(null, description);
    }

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath itemPath, int transitionID, String requestData, TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException, ObjectCannotBeUpdated, CannotManageException, PersistencyException {
        return this.authenticate(agent, itemPath, requestData, transactionKey);
    }

    protected String authenticate(AgentPath agent, ItemPath itemPath, String requestData, TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException {
        String[] params = Authenticate.getDataList(requestData);
        log.debug("Called by {} on {} with parameters {}", new Object[]{agent.getAgentName(transactionKey), itemPath, params});
        if (params.length < 2 || params.length > 3) {
            throw new InvalidDataException("PredefinedStep.Authenticate() -  Invalid number of parameters (2 <= length=" + params.length + " <= 3)");
        }
        Gateway.getSecurityManager().authenticate(params[0], params[1], null, false, transactionKey);
        params[1] = REDACTED;
        return Authenticate.bundleData(params);
    }
}

