/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined.agent;

import org.cristalise.kernel.SystemProperties;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.Job;
import org.cristalise.kernel.lifecycle.instance.predefined.agent.Authenticate;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sign
extends Authenticate {
    private static final Logger log = LoggerFactory.getLogger(Sign.class);
    public static final String description = "Authenticates the given user and records the Sign event in the system together with the execution context";
    public static final String agentNameField = SystemProperties.Lifecycle_Sign_agentNameField.getString();
    public static final String passwordField = SystemProperties.Lifecycle_Sign_passwordField.getString();
    public static final String signedFlagField = SystemProperties.Lifecycle_Sign_signedFlagField.getString();

    public Sign() {
        super("SimpleElectonicSignature", description);
    }

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath itemPath, int transitionID, String requestData, TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException, ObjectCannotBeUpdated, CannotManageException, PersistencyException {
        log.debug("Called by {} on {}", (Object)agent.getAgentName(transactionKey), (Object)itemPath);
        Outcome req = new Outcome(requestData);
        this.authenticate(agent, itemPath, Sign.bundleData(req.getField("AgentName"), req.getField("Password")), transactionKey);
        req.setField("Password", "REDACTED");
        return req.getData();
    }

    public static String getSimpleElectonicSignature(Job job) throws InvalidDataException, ObjectNotFoundException {
        if (job.getOutcome().hasField(agentNameField) && job.getOutcome().hasField(passwordField)) {
            StringBuffer xml = new StringBuffer("<SimpleElectonicSignature>");
            xml.append("<AgentName>").append(job.getOutcome().getField(agentNameField)).append("</AgentName>");
            xml.append("<Password>").append(job.getOutcome().getField(passwordField)).append("</Password>");
            xml.append("<ExecutionContext>");
            xml.append("<ItemPath>").append(job.getItemUUID()).append("</ItemPath>");
            xml.append("<SchemaName>").append(job.getSchemaName()).append("</SchemaName>");
            xml.append("<SchemaVersion>").append(job.getSchemaVersion()).append("</SchemaVersion>");
            xml.append("<ActivityType>").append(job.getStepType()).append("</ActivityType>");
            xml.append("<ActivityName>").append(job.getStepName()).append("</ActivityName>");
            xml.append("<StepPath>").append(job.getStepPath()).append("</StepPath>");
            xml.append("</ExecutionContext>");
            xml.append("</SimpleElectonicSignature>");
            job.getOutcome().setField(passwordField, "REDACTED");
            if (job.getOutcome().hasField(signedFlagField)) {
                job.getOutcome().setField(signedFlagField, "true");
            }
            return xml.toString();
        }
        throw new InvalidDataException("Outcome does not contain AgentName or Password fields - job:" + String.valueOf(job));
    }
}

