/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined.server;

import java.util.Arrays;
import java.util.Stack;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddDomainContext
extends PredefinedStep {
    private static final Logger log = LoggerFactory.getLogger(AddDomainContext.class);

    public AddDomainContext() {
        super("Creates an empty domain context in the tree");
    }

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, TransactionKey transactionKey) throws InvalidDataException, ObjectCannotBeUpdated, ObjectAlreadyExistsException, CannotManageException {
        Object[] params = AddDomainContext.getDataList(requestData);
        log.debug("Called by {} on {} with parameters {}", new Object[]{agent.getAgentName(transactionKey), item, params});
        if (params.length != 1) {
            throw new InvalidDataException("AddDomainContext: Invalid parameters " + Arrays.toString(params));
        }
        DomainPath pathToAdd = new DomainPath((String)params[0]);
        if (pathToAdd.exists(transactionKey)) {
            throw new ObjectAlreadyExistsException("Context " + String.valueOf(pathToAdd) + " already exists");
        }
        Stack<DomainPath> pathsToAdd = new Stack<DomainPath>();
        while (pathToAdd != null && !pathToAdd.exists()) {
            pathsToAdd.push(pathToAdd);
            pathToAdd = pathToAdd.getParent();
        }
        while (!pathsToAdd.empty()) {
            pathToAdd = (DomainPath)pathsToAdd.pop();
            Gateway.getLookupManager().add(pathToAdd, transactionKey);
        }
        return requestData;
    }
}

