/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined.server;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.SystemProperties;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.storage.XMLClusterStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkImport
extends PredefinedStep {
    private static final Logger log = LoggerFactory.getLogger(BulkImport.class);
    private String root = SystemProperties.BulkImport_rootDirectory.getString();
    private String ext = SystemProperties.BulkImport_fileExtension.getString();
    private Boolean useDir = SystemProperties.BulkImport_useDirectories.getBoolean();
    XMLClusterStorage importCluster;

    public BulkImport() {
        super("Imports all data provided in a specific directory");
    }

    public BulkImport(String rootDir) {
        this();
        this.root = rootDir;
        this.ext = "";
        this.useDir = false;
    }

    public void initialise() throws InvalidDataException {
        if (this.importCluster == null) {
            if (this.root == null) {
                throw new InvalidDataException("Root path not given in config file.");
            }
            this.importCluster = new XMLClusterStorage(this.root, this.ext, this.useDir);
        }
    }

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath itemPath, int transitionID, String requestData, TransactionKey transactionKey) throws InvalidDataException, InvalidCollectionModification, ObjectAlreadyExistsException, ObjectCannotBeUpdated, ObjectNotFoundException, PersistencyException, CannotManageException {
        log.debug("Called by {} on {}", (Object)agent.getAgentName(transactionKey), (Object)itemPath);
        this.initialise();
        this.importAllClusters(transactionKey);
        return requestData;
    }

    public void importAllClusters(TransactionKey transactionKey) throws InvalidDataException, PersistencyException {
        for (ItemPath item : this.getItemsToImport(this.root)) {
            block11: for (ClusterType type : this.importCluster.getClusters(item, transactionKey)) {
                switch (type) {
                    case PATH: {
                        this.importPath(item, transactionKey);
                        continue block11;
                    }
                    case PROPERTY: {
                        this.importProperty(item, transactionKey);
                        continue block11;
                    }
                    case LIFECYCLE: {
                        this.importLifeCycle(item, transactionKey);
                        continue block11;
                    }
                    case HISTORY: {
                        this.importHistory(item, transactionKey);
                        continue block11;
                    }
                    case VIEWPOINT: {
                        this.importViewPoint(item, transactionKey);
                        continue block11;
                    }
                    case OUTCOME: {
                        this.importOutcome(item, transactionKey);
                        continue block11;
                    }
                    case COLLECTION: {
                        this.importCollection(item, transactionKey);
                        continue block11;
                    }
                    case JOB: {
                        this.importJob(item, transactionKey);
                        continue block11;
                    }
                }
            }
        }
    }

    private List<ItemPath> getItemsToImport(String root) throws InvalidDataException {
        ArrayList<ItemPath> items = new ArrayList<ItemPath>();
        try {
            try (Stream<Path> files = Files.walk(Paths.get(root, new String[0]), 1, new FileVisitOption[0]);){
                files.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(path -> {
                    if (path.equals(Paths.get(root, new String[0]))) {
                        return;
                    }
                    String uuid = path.getFileName().toString();
                    log.info("getItemsToImport()- directory:{}", (Object)uuid);
                    try {
                        items.add(new ItemPath(uuid));
                    }
                    catch (InvalidItemPathException e) {
                        log.warn("getItemsToImport() - Unvalid UUID for import directory:{}", (Object)uuid);
                    }
                });
            }
            return items;
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            throw new InvalidDataException(e.getMessage());
        }
    }

    public void importProperty(ItemPath item, TransactionKey transactionKey) throws PersistencyException {
        String[] contents;
        for (String c : contents = this.importCluster.getClusterContents(item, ClusterType.PROPERTY, transactionKey)) {
            String path = String.valueOf((Object)ClusterType.PROPERTY) + "/" + c;
            C2KLocalObject prop = this.importCluster.get(item, path, transactionKey);
            Gateway.getStorage().put(item, prop, transactionKey);
        }
    }

    public void importViewPoint(ItemPath item, TransactionKey transactionKey) throws PersistencyException {
        String[] contents;
        for (String c : contents = this.importCluster.getClusterContents(item, ClusterType.VIEWPOINT, transactionKey)) {
            String[] subContents;
            for (String sc : subContents = this.importCluster.getClusterContents(item, String.valueOf((Object)ClusterType.VIEWPOINT) + "/" + c, transactionKey)) {
                String path = String.valueOf((Object)ClusterType.VIEWPOINT) + "/" + c + "/" + sc;
                C2KLocalObject view = this.importCluster.get(item, path, transactionKey);
                Gateway.getStorage().put(item, view, transactionKey);
            }
        }
    }

    public void importLifeCycle(ItemPath item, TransactionKey transactionKey) throws PersistencyException {
        String[] contents;
        for (String c : contents = this.importCluster.getClusterContents(item, ClusterType.LIFECYCLE, transactionKey)) {
            String path = String.valueOf((Object)ClusterType.LIFECYCLE) + "/" + c;
            C2KLocalObject wf = this.importCluster.get(item, path, transactionKey);
            Gateway.getStorage().put(item, wf, transactionKey);
        }
    }

    public void importHistory(ItemPath item, TransactionKey transactionKey) throws PersistencyException {
        String[] contents;
        for (String c : contents = this.importCluster.getClusterContents(item, ClusterType.HISTORY, transactionKey)) {
            String path = String.valueOf((Object)ClusterType.HISTORY) + "/" + c;
            C2KLocalObject obj = this.importCluster.get(item, path, transactionKey);
            Gateway.getStorage().put(item, obj, transactionKey);
        }
    }

    public void importOutcome(ItemPath item, TransactionKey transactionKey) throws PersistencyException {
        String[] schemas;
        for (String schema : schemas = this.importCluster.getClusterContents(item, ClusterType.OUTCOME, transactionKey)) {
            String[] versions;
            for (String version : versions = this.importCluster.getClusterContents(item, String.valueOf((Object)ClusterType.OUTCOME) + "/" + schema, transactionKey)) {
                String[] events;
                for (String event : events = this.importCluster.getClusterContents(item, String.valueOf((Object)ClusterType.OUTCOME) + "/" + schema + "/" + version, transactionKey)) {
                    C2KLocalObject obj = this.importCluster.get(item, String.valueOf((Object)ClusterType.OUTCOME) + "/" + schema + "/" + version + "/" + event, transactionKey);
                    Gateway.getStorage().put(item, obj, transactionKey);
                }
            }
        }
    }

    public void importJob(ItemPath item, TransactionKey transactionKey) throws PersistencyException {
        String[] stepNames;
        for (String step : stepNames = this.importCluster.getClusterContents(item, ClusterType.JOB, transactionKey)) {
            String[] transitions;
            for (String trans : transitions = this.importCluster.getClusterContents(item, String.valueOf((Object)ClusterType.JOB) + "/" + step, transactionKey)) {
                C2KLocalObject job = this.importCluster.get(item, String.valueOf((Object)ClusterType.JOB) + "/" + step + "/" + trans, transactionKey);
                Gateway.getStorage().put(item, job, transactionKey);
            }
        }
    }

    public void importCollection(ItemPath item, TransactionKey transactionKey) throws PersistencyException {
        String[] names;
        for (String name : names = this.importCluster.getClusterContents(item, ClusterType.COLLECTION, transactionKey)) {
            String[] versions;
            for (String version : versions = this.importCluster.getClusterContents(item, String.valueOf((Object)ClusterType.COLLECTION) + "/" + name, transactionKey)) {
                C2KLocalObject coll = this.importCluster.get(item, String.valueOf((Object)ClusterType.COLLECTION) + "/" + name + "/" + version, transactionKey);
                Gateway.getStorage().put(item, coll, transactionKey);
            }
        }
    }

    public void importDomainPath(ItemPath item, TransactionKey transactionKey) throws PersistencyException {
        String[] domains;
        for (String name : domains = this.importCluster.getClusterContents(item, String.valueOf((Object)ClusterType.PATH) + "/Domain", transactionKey)) {
            try {
                Gateway.getLookupManager().add((DomainPath)this.importCluster.get(item, String.valueOf((Object)ClusterType.PATH) + "/Domain/" + name, transactionKey), transactionKey);
            }
            catch (CannotManageException | ObjectAlreadyExistsException | ObjectCannotBeUpdated e) {
                log.error("", (Throwable)e);
                throw new PersistencyException(e.getMessage());
            }
        }
    }

    public void importRolePath(ItemPath item, AgentPath agentPath, TransactionKey transactionKey) throws PersistencyException {
        String[] roles;
        for (String role : roles = this.importCluster.getClusterContents(item, String.valueOf((Object)ClusterType.PATH) + "/Role", transactionKey)) {
            RolePath rolePath = (RolePath)this.importCluster.get(item, String.valueOf((Object)ClusterType.PATH) + "/Role/" + role, transactionKey);
            if (Gateway.getLookup().exists(rolePath, transactionKey)) continue;
            try {
                Gateway.getLookupManager().add(rolePath, transactionKey);
                if (agentPath == null) continue;
                Gateway.getLookupManager().addRole(agentPath, rolePath, transactionKey);
            }
            catch (CannotManageException | ObjectAlreadyExistsException | ObjectCannotBeUpdated | ObjectNotFoundException e) {
                log.error("", (Throwable)e);
                throw new PersistencyException(e.getMessage());
            }
        }
    }

    public ItemPath importItemPath(ItemPath item, TransactionKey transactionKey) throws PersistencyException {
        try {
            ItemPath itemPath = (ItemPath)this.importCluster.get(item, String.valueOf((Object)ClusterType.PATH) + "/Item", transactionKey);
            Gateway.getLookupManager().add(itemPath, transactionKey);
            return itemPath;
        }
        catch (CannotManageException | ObjectAlreadyExistsException | ObjectCannotBeUpdated e) {
            log.error("", (Throwable)e);
            throw new PersistencyException(e.getMessage());
        }
    }

    public AgentPath importAgentPath(ItemPath item, TransactionKey transactionKey) throws PersistencyException {
        try {
            AgentPath agentPath = (AgentPath)this.importCluster.get(item, String.valueOf((Object)ClusterType.PATH) + "/Item", transactionKey);
            Gateway.getLookupManager().add(agentPath, transactionKey);
            Gateway.getLookupManager().setAgentPassword(agentPath, "", true, transactionKey);
            return agentPath;
        }
        catch (NoSuchAlgorithmException | CannotManageException | ObjectAlreadyExistsException | ObjectCannotBeUpdated | ObjectNotFoundException e) {
            log.error("", (Throwable)e);
            throw new PersistencyException(e.getMessage());
        }
    }

    public void importPath(ItemPath item, TransactionKey transactionKey) throws PersistencyException {
        String[] contents = this.importCluster.getClusterContents(item, ClusterType.PATH, transactionKey);
        AgentPath agentPath = null;
        String entity = "";
        if (Arrays.asList(contents).contains("Item")) {
            entity = "Item";
        }
        if (Arrays.asList(contents).contains("Agent")) {
            entity = "Agent";
        }
        if (StringUtils.isNotBlank((CharSequence)entity)) {
            if (entity.equals("Item")) {
                this.importItemPath(item, transactionKey);
            } else if (entity.equals("Agent")) {
                agentPath = this.importAgentPath(item, transactionKey);
            }
        } else {
            log.warn("importPath() - WARNING: '" + String.valueOf(item) + "' has no Path.Item or Path.Agent files");
        }
        for (String c : contents) {
            if (c.equals("Domain")) {
                this.importDomainPath(item, transactionKey);
                continue;
            }
            if (!c.equals("Role")) continue;
            this.importRolePath(item, agentPath, transactionKey);
        }
    }
}

