/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.stateMachine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.cristalise.kernel.SystemProperties;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.InvalidTransitionException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lifecycle.instance.Activity;
import org.cristalise.kernel.lifecycle.instance.stateMachine.State;
import org.cristalise.kernel.lifecycle.instance.stateMachine.Transition;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.utils.DescriptionObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateMachine
implements DescriptionObject {
    private static final Logger log = LoggerFactory.getLogger(StateMachine.class);
    public String namespace;
    public String name;
    public Integer version;
    public ItemPath itemPath;
    private ArrayList<State> states = new ArrayList();
    private ArrayList<Transition> transitions = new ArrayList();
    private final HashMap<Integer, State> stateCodes = new HashMap();
    private final HashMap<Integer, Transition> transitionCodes = new HashMap();
    State initialState;
    int initialStateCode;
    boolean isCoherent = false;
    private int nextStateId = -1;
    private int nextTransId = -1;

    public StateMachine() {
    }

    public StateMachine(String name, Integer version) {
        this();
        this.name = name;
        this.version = version;
    }

    private int getNextStateId() {
        if (this.nextStateId == -1) {
            for (State s : this.states) {
                if (s.id <= this.nextStateId) continue;
                this.nextStateId = s.id;
            }
            ++this.nextStateId;
        }
        return this.nextStateId++;
    }

    private int getNextTransId() {
        if (this.nextTransId == -1) {
            for (Transition t : this.transitions) {
                if (t.id <= this.nextTransId) continue;
                this.nextTransId = t.id;
            }
            ++this.nextTransId;
        }
        return this.nextTransId++;
    }

    public State createState(String name) {
        State newState = new State(this.getNextStateId(), name);
        this.states.add(newState);
        log.debug("createState() - created:" + name + " id:" + newState.id);
        return newState;
    }

    public Transition createTransition(String name) {
        Transition newTrans = new Transition(this.getNextTransId(), name);
        this.transitions.add(newTrans);
        log.debug("createTransition() - created:" + name + " id:" + newTrans.id);
        return newTrans;
    }

    public void setStates(ArrayList<State> newStates) {
        this.states = newStates;
        this.validate();
    }

    public void setTransitions(ArrayList<Transition> newTransitions) {
        this.transitions = newTransitions;
        this.validate();
    }

    public boolean validate() {
        this.stateCodes.clear();
        this.transitionCodes.clear();
        this.isCoherent = true;
        log.debug("validate() - name:'" + this.name + "'");
        for (State state : this.states) {
            this.stateCodes.put(state.getId(), state);
        }
        if (this.stateCodes.containsKey(this.initialStateCode)) {
            this.initialState = this.stateCodes.get(this.initialStateCode);
        } else {
            this.isCoherent = false;
        }
        for (Transition trans : this.transitions) {
            this.transitionCodes.put(trans.getId(), trans);
            this.isCoherent = this.isCoherent && trans.resolveStates(this.stateCodes);
        }
        return this.isCoherent;
    }

    public ArrayList<State> getStates() {
        return this.states;
    }

    public ArrayList<Transition> getTransitions() {
        return this.transitions;
    }

    public State getInitialState() {
        return this.initialState;
    }

    public void setInitialState(State initialState) {
        this.initialState = initialState;
        this.initialStateCode = initialState.getId();
    }

    public int getInitialStateCode() {
        return this.initialStateCode;
    }

    public void setInitialStateCode(int initialStateCode) {
        this.initialStateCode = initialStateCode;
        this.initialState = this.stateCodes.get(initialStateCode);
        if (this.initialState == null) {
            this.isCoherent = false;
        }
    }

    @Override
    public String getItemID() {
        if (this.itemPath == null || this.itemPath.getUUID() == null) {
            return "";
        }
        return this.itemPath.getUUID().toString();
    }

    public Transition getTransition(int transitionID) {
        return this.transitionCodes.get(transitionID);
    }

    public Transition getTransition(String name) {
        for (Transition t : this.transitions) {
            if (!t.getName().equals(name)) continue;
            return t;
        }
        return null;
    }

    public int getTransitionID(String name) {
        Transition t = this.getTransition(name);
        return t == null ? -1 : t.getId();
    }

    public int getValidTransitionID(String transName) throws InvalidDataException {
        int id = this.getTransitionID(transName);
        if (id == -1) {
            throw new InvalidDataException("Transition name '" + transName + "' was not found in StateMachine '" + this.getName() + "'");
        }
        return id;
    }

    public State getState(int stateID) {
        return this.stateCodes.get(stateID);
    }

    public State getState(String name) {
        for (State s : this.states) {
            if (!s.getName().equals(name)) continue;
            return s;
        }
        return null;
    }

    @Override
    public CollectionArrayList makeDescCollections(TransactionKey transactionKey) {
        return new CollectionArrayList();
    }

    public List<Transition> getPossibleTransitions(Activity act, AgentPath agent) throws ObjectNotFoundException, InvalidDataException {
        ArrayList<Transition> returnList = new ArrayList<Transition>();
        State currentState = this.getState(act.getState());
        for (Transition possTrans : currentState.getPossibleTransitions().values()) {
            try {
                if (possTrans.isEnabled(act)) {
                    possTrans.checkPerformingRole(act, agent);
                    returnList.add(possTrans);
                    continue;
                }
                log.trace("getPossibleTransitions() - DISABLED trans:" + String.valueOf(possTrans) + " act:" + act.getName());
            }
            catch (AccessRightsException ex) {
                log.debug("getPossibleTransitions() - trans:" + String.valueOf(possTrans) + " not possible for " + agent.getAgentName() + " exception:" + ex.getMessage());
                if (!log.isTraceEnabled()) continue;
                log.error("", (Throwable)ex);
            }
        }
        return returnList;
    }

    public State traverse(Activity act, Transition transition, AgentPath agent) throws InvalidTransitionException, AccessRightsException, ObjectNotFoundException, InvalidDataException {
        State currentState = this.getState(act.getState());
        if (transition.originState.equals(currentState)) {
            transition.checkPerformingRole(act, agent);
            return transition.targetState;
        }
        throw new InvalidTransitionException("Transition " + String.valueOf(transition) + " not valid from state " + String.valueOf(currentState));
    }

    public boolean isCoherent() {
        return this.isCoherent;
    }

    public int getErrorTransitionIdForState(int id) {
        return this.getState(id).getErrorTansitionId();
    }

    @Override
    public BuiltInResources getResourceType() {
        return BuiltInResources.STATE_MACHINE_RESOURCE;
    }

    public static String getDefaultStateMachine(String type) {
        if ("Elementary".equals(type)) {
            return SystemProperties.StateMachine_Elementary_default.getString();
        }
        if ("Composite".equals(type)) {
            return SystemProperties.StateMachine_Composite_default.getString();
        }
        if ("Predefined".equals(type)) {
            return SystemProperties.StateMachine_Predefined_default.getString();
        }
        throw new UnsupportedOperationException("Keyword '" + type + "' is not supported");
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        this.version = version;
    }

    @Override
    public ItemPath getItemPath() {
        return this.itemPath;
    }

    @Override
    public void setItemPath(ItemPath itemPath) {
        this.itemPath = itemPath;
    }
}

