/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.routingHelpers;

import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.graph.model.GraphableVertex;
import org.cristalise.kernel.lifecycle.instance.Workflow;
import org.cristalise.kernel.lifecycle.routingHelpers.DataHelper;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityDataHelper
implements DataHelper {
    private static final Logger log = LoggerFactory.getLogger(ActivityDataHelper.class);

    @Override
    public String get(ItemPath itemPath, String actContext, String dataPath, TransactionKey transactionKey) throws InvalidDataException, PersistencyException, ObjectNotFoundException {
        Workflow workflow;
        GraphableVertex act;
        log.debug("get() - item:" + String.valueOf(itemPath) + ", actContext:" + actContext + ", dataPath:" + dataPath);
        String[] paths = dataPath.split(":");
        if (paths.length != 2) {
            throw new InvalidDataException("Invalid path '" + dataPath + "' it must have one and only one colon (:)");
        }
        Object actPath = paths[0];
        String xpath = paths[1];
        if (((String)actPath).startsWith(".")) {
            actPath = actContext + (actContext.endsWith("/") ? "" : "/") + ((String)actPath).substring(2);
        }
        if ((act = (workflow = (Workflow)Gateway.getStorage().get(itemPath, String.valueOf((Object)ClusterType.LIFECYCLE) + "/workflow", transactionKey)).search((String)actPath)) == null) {
            throw new InvalidDataException("Workflow search failed for actPath:" + (String)actPath + " - item:" + String.valueOf(itemPath) + ", actContext:" + actContext + ", dataPath:" + dataPath);
        }
        String schemaName = act.getBuiltInProperty(BuiltInVertexProperties.SCHEMA_NAME).toString();
        Integer schemaVersion = Integer.valueOf(act.getBuiltInProperty(BuiltInVertexProperties.SCHEMA_VERSION).toString());
        String viewName = act.getBuiltInProperty(BuiltInVertexProperties.VIEW_POINT).toString();
        if (StringUtils.isBlank((CharSequence)viewName)) {
            viewName = "last";
        }
        Schema schema = LocalObjectLoader.getSchema(schemaName, schemaVersion, transactionKey);
        Viewpoint view = (Viewpoint)Gateway.getStorage().get(itemPath, String.valueOf((Object)ClusterType.VIEWPOINT) + "/" + schema.getName() + "/" + viewName, transactionKey);
        Outcome outcome = view.getOutcome(transactionKey);
        try {
            return outcome.getFieldByXPath(xpath);
        }
        catch (XPathExpressionException e) {
            throw new InvalidDataException("Invalid xpath:" + xpath + " - item:" + String.valueOf(itemPath) + ", actContext:" + actContext + ", dataPath:" + dataPath);
        }
    }
}

