/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.routingHelpers;

import javax.xml.xpath.XPathExpressionException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.lifecycle.routingHelpers.DataHelper;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Gateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewpointDataHelper
implements DataHelper {
    private static final Logger log = LoggerFactory.getLogger(ViewpointDataHelper.class);

    @Override
    public String get(ItemPath itemPath, String actContext, String dataPath, TransactionKey transactionKey) throws InvalidDataException, PersistencyException, ObjectNotFoundException {
        String[] paths = dataPath.split(":");
        if (paths.length != 2) {
            throw new InvalidDataException("Invalid path: '" + dataPath + "' should have only one colon (:)");
        }
        String viewpoint = paths[0];
        String xpath = paths[1];
        if (viewpoint.startsWith("./")) {
            log.warn("Removing leading dot on viewpoint data helper path at " + actContext + " in " + itemPath.getUUID().toString() + ". Definition should be migrated.");
            viewpoint = viewpoint.substring(2);
        }
        Viewpoint view = (Viewpoint)Gateway.getStorage().get(itemPath, String.valueOf((Object)ClusterType.VIEWPOINT) + "/" + viewpoint, transactionKey);
        Outcome outcome = view.getOutcome(transactionKey);
        try {
            return outcome.getFieldByXPath(xpath);
        }
        catch (XPathExpressionException e) {
            throw new InvalidDataException("Invalid XPath: " + xpath);
        }
    }
}

