/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lookup;

import java.util.List;
import java.util.UUID;
import javax.annotation.concurrent.Immutable;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;

@Immutable
public class AgentPath
extends ItemPath {
    private String mAgentName = null;
    private boolean mPasswordTemporary = false;

    public AgentPath() {
    }

    public AgentPath(UUID uuid, String agentName, boolean isPwdTemporary) {
        super(uuid);
        this.mAgentName = agentName;
        this.mPasswordTemporary = isPwdTemporary;
    }

    public AgentPath(UUID uuid) throws InvalidItemPathException {
        super(uuid);
    }

    public AgentPath(ItemPath itemPath) throws InvalidItemPathException {
        this(itemPath.getUUID());
    }

    public AgentPath(String path) throws InvalidItemPathException {
        this(UUID.fromString(path.substring(path.lastIndexOf("/") == -1 ? 0 : path.lastIndexOf("/") + 1)));
    }

    public AgentPath(ItemPath itemPath, String agentName) {
        super(itemPath.getUUID());
        this.mAgentName = agentName;
    }

    public AgentPath(UUID uuid, String agentName) {
        super(uuid);
        this.mAgentName = agentName;
    }

    public void setAgentName(String agentID) {
        this.mAgentName = agentID;
    }

    public String getAgentName() {
        return this.getAgentName(null);
    }

    public String getAgentName(TransactionKey transactionKey) {
        if (this.mAgentName == null) {
            try {
                this.mAgentName = Gateway.getLookup().getAgentName(this, transactionKey);
            }
            catch (ObjectNotFoundException e) {
                return null;
            }
        }
        return this.mAgentName;
    }

    public RolePath[] getRoles() {
        return this.getRoles(null);
    }

    public RolePath[] getRoles(TransactionKey transactionKey) {
        return Gateway.getLookup().getRoles(this, transactionKey);
    }

    public boolean hasMatchingRole(List<RolePath> roles) {
        return this.hasMatchingRole(roles, null);
    }

    public boolean hasMatchingRole(List<RolePath> roles, TransactionKey transactionKey) {
        for (RolePath role : roles) {
            if (!Gateway.getLookup().hasRole(this, role, transactionKey)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRole(RolePath role) {
        return this.hasRole(role, null);
    }

    public boolean hasRole(RolePath role, TransactionKey transactionKey) {
        return Gateway.getLookup().hasRole(this, role, transactionKey);
    }

    public boolean hasRole(String role) {
        return this.hasRole(role, null);
    }

    public boolean hasRole(String role, TransactionKey transactionKey) {
        try {
            return this.hasRole(Gateway.getLookup().getRolePath(role, transactionKey));
        }
        catch (ObjectNotFoundException ex) {
            return false;
        }
    }

    @Override
    public String getClusterPath() {
        return String.valueOf((Object)ClusterType.PATH) + "/Agent";
    }

    @Override
    public AgentProxy getProxy() throws ObjectNotFoundException {
        return this.getProxy(null);
    }

    @Override
    public AgentProxy getProxy(TransactionKey transactionKey) throws ObjectNotFoundException {
        return (AgentProxy)super.getProxy(transactionKey);
    }

    @Override
    public String dump() {
        return super.dump() + "\n        agentID=" + this.mAgentName;
    }

    public boolean isPasswordTemporary() {
        return this.mPasswordTemporary;
    }
}

