/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lookup;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.UUID;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.property.PropertyUtility;

@Immutable
public class ItemPath
extends Path {
    String itemName;

    public ItemPath() {
        this.setSysKey(UUID.randomUUID());
    }

    public ItemPath(UUID uuid) {
        this.setSysKey(uuid);
    }

    public ItemPath(String[] path) throws InvalidItemPathException {
        super(path);
        this.checkSysKeyFromPath();
    }

    public ItemPath(String path) throws InvalidItemPathException {
        super(path);
        if (path == null) {
            throw new InvalidItemPathException("Path cannot be null");
        }
        this.checkSysKeyFromPath();
    }

    @Override
    public void setPath(String[] path) {
        super.setPath(path);
    }

    @Override
    public void setPath(String path) {
        super.setPath(path);
    }

    @Override
    public void setPath(Path path) {
        super.setPath(path);
    }

    private void checkSysKeyFromPath() throws InvalidItemPathException {
        if (this.mPath.length == 1) {
            try {
                this.getUUID();
            }
            catch (Throwable ex) {
                throw new InvalidItemPathException(this.mPath[0] + " is not a valid UUID : " + ex.getMessage());
            }
        } else {
            throw new InvalidItemPathException("Not a valid item path: " + Arrays.toString(this.mPath));
        }
    }

    @Override
    public String getRoot() {
        return "entity";
    }

    @Override
    public ItemPath getItemPath(TransactionKey transactionKey) throws ObjectNotFoundException {
        return this;
    }

    public byte[] getOID() {
        UUID uuid = this.getUUID();
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb.array();
    }

    protected void setSysKey(UUID uuid) {
        this.setPathFromUUID(uuid);
    }

    private void setPathFromUUID(UUID uuid) {
        this.mPath = new String[1];
        this.mPath[0] = uuid.toString();
    }

    @Override
    public UUID getUUID() {
        return UUID.fromString(this.mPath[0]);
    }

    @Override
    public String getName() {
        return this.mPath[0];
    }

    @Override
    public String getClusterPath() {
        return String.valueOf((Object)ClusterType.PATH) + "/Item";
    }

    public static boolean isUUID(String entityKey) {
        if (entityKey.startsWith("/entity/")) {
            entityKey = entityKey.substring(8);
        }
        return entityKey.matches("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$");
    }

    public String getItemName() {
        return this.getItemName(null);
    }

    public String getItemName(TransactionKey transactionKey) {
        if (StringUtils.isBlank((CharSequence)this.itemName)) {
            this.itemName = PropertyUtility.getPropertyValue(this, BuiltInItemProperties.NAME, "", transactionKey);
        }
        return this.itemName;
    }

    public ItemProxy getProxy() throws ObjectNotFoundException {
        return this.getProxy(null);
    }

    public ItemProxy getProxy(TransactionKey transactionKey) throws ObjectNotFoundException {
        return Gateway.getProxy(this, transactionKey);
    }
}

