/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lookup;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyDescriptionList;

public interface Lookup {
    public void open();

    public void close();

    default public ItemPath getItemPath(String sysKey) throws InvalidItemPathException, ObjectNotFoundException {
        return this.getItemPath(sysKey, null);
    }

    public ItemPath getItemPath(String var1, TransactionKey var2) throws InvalidItemPathException, ObjectNotFoundException;

    default public ItemPath resolvePath(DomainPath domainPath) throws InvalidItemPathException, ObjectNotFoundException {
        return this.resolvePath(domainPath, null);
    }

    public ItemPath resolvePath(DomainPath var1, TransactionKey var2) throws InvalidItemPathException, ObjectNotFoundException;

    default public boolean exists(Path path) {
        return this.exists(path, null);
    }

    public boolean exists(Path var1, TransactionKey var2);

    default public PagedResult getContextTree(DomainPath start) {
        return this.getContextTree(start, null);
    }

    public PagedResult getContextTree(DomainPath var1, TransactionKey var2);

    default public Iterator<Path> getChildren(Path path) {
        return this.getChildren(path, null);
    }

    public Iterator<Path> getChildren(Path var1, TransactionKey var2);

    default public PagedResult getChildren(Path path, int offset, int limit) {
        return this.getChildren(path, offset, limit, null);
    }

    default public PagedResult getChildren(Path path, int offset, int limit, TransactionKey transactionKey) {
        return this.getChildren(path, offset, limit, false, null);
    }

    public PagedResult getChildren(Path var1, int var2, int var3, boolean var4, TransactionKey var5);

    default public Iterator<Path> search(Path start, String name) {
        return this.search(start, name, SearchConstraints.WILDCARD_MATCH, (TransactionKey)null);
    }

    public Iterator<Path> search(Path var1, String var2, SearchConstraints var3, TransactionKey var4);

    default public Iterator<Path> search(Path start, Property ... props) {
        return this.search(start, (TransactionKey)null, props);
    }

    public Iterator<Path> search(Path var1, TransactionKey var2, Property ... var3);

    default public PagedResult search(Path start, List<Property> props, int offset, int limit) {
        return this.search(start, props, offset, limit, null);
    }

    public PagedResult search(Path var1, List<Property> var2, int var3, int var4, TransactionKey var5);

    default public Iterator<Path> search(Path start, PropertyDescriptionList props) {
        return this.search(start, props, (TransactionKey)null);
    }

    public Iterator<Path> search(Path var1, PropertyDescriptionList var2, TransactionKey var3);

    default public PagedResult search(Path start, PropertyDescriptionList props, int offset, int limit) {
        return this.search(start, props, offset, limit, null);
    }

    public PagedResult search(Path var1, PropertyDescriptionList var2, int var3, int var4, TransactionKey var5);

    default public Iterator<Path> searchAliases(ItemPath itemPath) {
        return this.searchAliases(itemPath, null);
    }

    public Iterator<Path> searchAliases(ItemPath var1, TransactionKey var2);

    default public PagedResult searchAliases(ItemPath itemPath, int offset, int limit) {
        return this.searchAliases(itemPath, offset, limit, null);
    }

    public PagedResult searchAliases(ItemPath var1, int var2, int var3, TransactionKey var4);

    default public AgentPath getAgentPath(String agentName) throws ObjectNotFoundException {
        return this.getAgentPath(agentName, null);
    }

    public AgentPath getAgentPath(String var1, TransactionKey var2) throws ObjectNotFoundException;

    default public RolePath getRolePath(String roleName) throws ObjectNotFoundException {
        return this.getRolePath(roleName, null);
    }

    public RolePath getRolePath(String var1, TransactionKey var2) throws ObjectNotFoundException;

    default public AgentPath[] getAgents(RolePath rolePath) throws ObjectNotFoundException {
        return this.getAgents(rolePath, null);
    }

    public AgentPath[] getAgents(RolePath var1, TransactionKey var2) throws ObjectNotFoundException;

    default public PagedResult getAgents(RolePath rolePath, int offset, int limit) throws ObjectNotFoundException {
        return this.getAgents(rolePath, offset, limit, null);
    }

    public PagedResult getAgents(RolePath var1, int var2, int var3, TransactionKey var4) throws ObjectNotFoundException;

    default public RolePath[] getRoles(AgentPath agentPath) {
        return this.getRoles(agentPath, null);
    }

    public RolePath[] getRoles(AgentPath var1, TransactionKey var2);

    default public PagedResult getRoles(AgentPath agentPath, int offset, int limit) {
        return this.getRoles(agentPath, offset, limit, null);
    }

    public PagedResult getRoles(AgentPath var1, int var2, int var3, TransactionKey var4);

    default public boolean hasRole(AgentPath agentPath, RolePath role) {
        return this.hasRole(agentPath, role, null);
    }

    public boolean hasRole(AgentPath var1, RolePath var2, TransactionKey var3);

    default public String getAgentName(AgentPath agentPath) throws ObjectNotFoundException {
        return this.getAgentName(agentPath, null);
    }

    public String getAgentName(AgentPath var1, TransactionKey var2) throws ObjectNotFoundException;

    public static class PagedResult {
        public int maxRows;
        public List<Path> rows;

        public PagedResult() {
            this.maxRows = 0;
            this.rows = new ArrayList<Path>();
        }

        public PagedResult(int size, List<Path> result) {
            this.maxRows = size;
            this.rows = result;
        }
    }

    public static enum SearchConstraints {
        EXACT_NAME_MATCH,
        WILDCARD_MATCH;

    }
}

