/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.persistency;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterStorageManager;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class C2KLocalObjectMap<V extends C2KLocalObject>
implements Map<String, V>,
C2KLocalObject {
    private static final Logger log = LoggerFactory.getLogger(C2KLocalObjectMap.class);
    protected ItemPath itemPath;
    protected ClusterType clusterType;
    private ClusterStorageManager storage;
    TransactionKey transactionKey;

    public C2KLocalObjectMap(ItemPath item, ClusterType cluster) {
        this(item, cluster, null);
    }

    public C2KLocalObjectMap(ItemPath item, ClusterType cluster, TransactionKey transKey) {
        this.itemPath = item;
        this.transactionKey = transKey;
        this.clusterType = cluster;
        this.storage = Gateway.getStorage();
    }

    public int getLastId() {
        try {
            return this.storage.getLastIntegerId(this.itemPath, this.clusterType.getName(), this.transactionKey);
        }
        catch (PersistencyException e) {
            log.error("getLastId() - {}/{}", new Object[]{this.itemPath, this.clusterType, e});
            return -1;
        }
    }

    private String getFullKey(Object key) {
        String path = (String)key;
        return String.valueOf((Object)this.clusterType) + (path.length() > 0 ? "/" : "") + path;
    }

    protected Set<String> loadKeys(String path) throws PersistencyException {
        HashSet<String> keys = new HashSet<String>();
        Object fullKey = this.getFullKey(path);
        int count = StringUtils.countMatches((CharSequence)fullKey, (char)'/');
        String[] children = this.storage.getClusterContents(this.itemPath, (String)fullKey, this.transactionKey);
        if ((this.clusterType == ClusterType.PROPERTY || this.clusterType == ClusterType.LIFECYCLE || this.clusterType == ClusterType.HISTORY) && count == 0 || (this.clusterType == ClusterType.VIEWPOINT || this.clusterType == ClusterType.COLLECTION || this.clusterType == ClusterType.JOB) && count == 1 || (this.clusterType == ClusterType.OUTCOME || this.clusterType == ClusterType.ATTACHMENT) && count == 2) {
            for (String subKey : children) {
                fullKey = path + (path.length() > 0 ? "/" : "") + subKey;
                keys.add((String)fullKey);
            }
        } else {
            for (String element : children) {
                fullKey = path + (path.length() > 0 ? "/" : "") + element;
                keys.addAll(this.loadKeys((String)fullKey));
            }
        }
        return keys;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keySet().contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsKey(((C2KLocalObject)value).getClusterPath());
    }

    @Override
    public synchronized Set<String> keySet() {
        try {
            Set<String> keys = this.loadKeys("");
            log.debug("keySet() - Returning #{} keys of cluster:{}/{}", new Object[]{keys.size(), this.itemPath, this.clusterType});
            return keys;
        }
        catch (PersistencyException e) {
            log.error("keySet() - {}/{}", new Object[]{this.itemPath, this.clusterType, e});
            return null;
        }
    }

    @Override
    public V get(Object key) {
        String fullKey = this.getFullKey(key.toString());
        try {
            return (V)this.storage.get(this.itemPath, fullKey, this.transactionKey);
        }
        catch (PersistencyException e) {
            log.error("get() - {}/{}", new Object[]{this.itemPath, fullKey, e});
            throw new IllegalArgumentException(e);
        }
        catch (ObjectNotFoundException e) {
            log.trace("get() - could not get cluster:{}/{}", new Object[]{this.itemPath, fullKey, e});
            return null;
        }
    }

    @Override
    public V put(String key, V value) {
        try {
            this.storage.put(this.itemPath, (C2KLocalObject)value, this.transactionKey);
            return value;
        }
        catch (PersistencyException e) {
            log.error("put() - {}/{}", new Object[]{this.itemPath, value.getClusterPath(), e});
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public V remove(Object key) {
        String fullKey = this.getFullKey(key);
        try {
            this.storage.remove(this.itemPath, fullKey, this.transactionKey);
        }
        catch (PersistencyException e) {
            log.error("remove() - {}/{}", new Object[]{this.itemPath, fullKey, e});
            throw new IllegalArgumentException(e);
        }
        return null;
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> m) {
        for (Map.Entry<String, V> entry : m.entrySet()) {
            this.put(entry.getKey(), (V)((C2KLocalObject)entry.getValue()));
        }
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Cannot delete the full content of cluster:" + String.valueOf(this.itemPath) + "/" + String.valueOf((Object)this.clusterType));
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        TreeSet<Map.Entry<String, V>> entries = new TreeSet<Map.Entry<String, V>>();
        for (String key : this.keySet()) {
            entries.add(new AbstractMap.SimpleImmutableEntry<String, Object>(key, this.get(key)));
        }
        return entries;
    }

    @Override
    public Collection<V> values() {
        ArrayList<Object> values = new ArrayList<Object>();
        for (String key : this.keySet()) {
            values.add(this.get(key));
        }
        return values;
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public String getName() {
        return this.getClusterType().getName();
    }

    @Override
    public String getClusterPath() {
        return this.getClusterType().getName();
    }

    public ItemPath getItemPath() {
        return this.itemPath;
    }

    @Override
    public ClusterType getClusterType() {
        return this.clusterType;
    }

    public ClusterStorageManager getStorage() {
        return this.storage;
    }

    public TransactionKey getTransactionKey() {
        return this.transactionKey;
    }

    public void setTransactionKey(TransactionKey transactionKey) {
        this.transactionKey = transactionKey;
    }
}

