/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.persistency;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.SystemProperties;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.entity.proxy.ProxyMessage;
import org.cristalise.kernel.events.History;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.C2KLocalObjectMap;
import org.cristalise.kernel.persistency.ClusterStorage;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.querying.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterStorageManager {
    private static final Logger log = LoggerFactory.getLogger(ClusterStorageManager.class);
    HashMap<String, ClusterStorage> allStores = new HashMap();
    String[] clusterPriority = new String[0];
    HashMap<ClusterType, ArrayList<ClusterStorage>> clusterWriters = new HashMap();
    HashMap<ClusterType, ArrayList<ClusterStorage>> clusterReaders = new HashMap();
    Cache<String, C2KLocalObject> cache;
    Map<Object, Set<ProxyMessage>> proxyMessagesMap = new ConcurrentHashMap<Object, Set<ProxyMessage>>();
    private Map<ItemPath, TransactionKey> itemLocks = new ConcurrentHashMap<ItemPath, TransactionKey>();
    private Map<TransactionKey, Set<ItemPath>> lockCatalog = new ConcurrentHashMap<TransactionKey, Set<ItemPath>>();

    public ClusterStorageManager() throws PersistencyException {
        ArrayList<ClusterStorage> rootStores;
        Object clusterStorageProp = SystemProperties.ClusterStorage.getObject();
        if (clusterStorageProp == null || "".equals(clusterStorageProp)) {
            throw new PersistencyException("No persistency, no ClusterStorage defined!");
        }
        if (clusterStorageProp instanceof String) {
            rootStores = this.instantiateStores((String)clusterStorageProp);
        } else if (clusterStorageProp instanceof ArrayList) {
            ArrayList propStores = (ArrayList)clusterStorageProp;
            rootStores = new ArrayList();
            this.clusterPriority = new String[propStores.size()];
            for (ClusterStorage thisStore : propStores) {
                if (thisStore instanceof ClusterStorage) {
                    rootStores.add(thisStore);
                    continue;
                }
                throw new PersistencyException("Supplied ClusterStorage " + String.valueOf(thisStore) + " was not an instance of ClusterStorage");
            }
        } else {
            throw new PersistencyException("Unknown class of ClusterStorage property: " + clusterStorageProp.getClass().getName());
        }
        int clusterNo = 0;
        for (ClusterStorage newStorage : rootStores) {
            newStorage.open();
            log.debug("init() - Cluster storage " + newStorage.getClass().getName() + " initialised successfully.");
            this.allStores.put(newStorage.getId(), newStorage);
            this.clusterPriority[clusterNo++] = newStorage.getId();
        }
        this.clusterReaders.put(ClusterType.ROOT, rootStores);
        this.cache = CacheBuilder.from((String)SystemProperties.ClusterStorage_cacheSpec.getString()).build();
    }

    public ArrayList<ClusterStorage> instantiateStores(String allClusters) throws PersistencyException {
        ArrayList<ClusterStorage> rootStores = new ArrayList<ClusterStorage>();
        StringTokenizer tok = new StringTokenizer(allClusters, ",");
        this.clusterPriority = new String[tok.countTokens()];
        while (tok.hasMoreTokens()) {
            ClusterStorage newStorage = null;
            Object newStorageClass = tok.nextToken();
            try {
                if (!((String)newStorageClass).contains(".")) {
                    newStorageClass = "org.cristalise.storage." + (String)newStorageClass;
                }
                newStorage = (ClusterStorage)Class.forName((String)newStorageClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new PersistencyException("init() - The cluster storage handler class " + (String)newStorageClass + " could not be found.");
            }
            rootStores.add(newStorage);
        }
        return rootStores;
    }

    public void close() {
        for (ClusterStorage thisStorage : this.allStores.values()) {
            try {
                thisStorage.close();
            }
            catch (PersistencyException ex) {
                log.error("Error closing storage {}", (Object)thisStorage, (Object)ex);
            }
        }
    }

    private ClusterStorage findStorageForQuery(String language) {
        for (String element : this.clusterPriority) {
            ClusterStorage store = this.allStores.get(element);
            if (!store.checkQuerySupport(language)) continue;
            return store;
        }
        return null;
    }

    private ArrayList<ClusterStorage> findStorages(ClusterType clusterType, boolean forWrite) {
        HashMap<ClusterType, ArrayList<ClusterStorage>> storages = forWrite ? this.clusterWriters : this.clusterReaders;
        if (storages.containsKey((Object)clusterType)) {
            return storages.get((Object)clusterType);
        }
        log.trace("findStorages() - finding storage for " + String.valueOf((Object)clusterType) + " forWrite:" + forWrite);
        ArrayList<ClusterStorage> useableStorages = new ArrayList<ClusterStorage>();
        for (String element : this.clusterPriority) {
            int requiredSupport;
            ClusterStorage thisStorage = this.allStores.get(element);
            int n = requiredSupport = forWrite ? 2 : 1;
            if ((thisStorage.queryClusterSupport(clusterType) & requiredSupport) != requiredSupport) continue;
            log.trace("findStorages() - Got {}", (Object)thisStorage);
            useableStorages.add(thisStorage);
        }
        storages.put(clusterType, useableStorages);
        return useableStorages;
    }

    public String executeQuery(Query query) throws PersistencyException {
        return this.executeQuery(query, null);
    }

    public String executeQuery(Query query, TransactionKey transactionKey) throws PersistencyException {
        ClusterStorage reader = this.findStorageForQuery(query.getLanguage());
        if (reader != null) {
            return reader.executeQuery(query, transactionKey);
        }
        throw new PersistencyException("No storage was found supporting language:" + query.getLanguage() + " query:" + query.getName());
    }

    public String[] getClusterContents(ItemPath itemPath, ClusterType type) throws PersistencyException {
        return this.getClusterContents(itemPath, type, null);
    }

    public String[] getClusterContents(ItemPath itemPath, ClusterType type, TransactionKey transactionKey) throws PersistencyException {
        return this.getClusterContents(itemPath, type.getName(), transactionKey);
    }

    public String[] getClusterContents(ItemPath itemPath, String path) throws PersistencyException {
        return this.getClusterContents(itemPath, path, null);
    }

    public String[] getClusterContents(ItemPath itemPath, String path, TransactionKey transactionKey) throws PersistencyException {
        if (path.startsWith("/") && path.length() > 1) {
            path = path.substring(1);
        }
        ArrayList<String> contents = new ArrayList<String>();
        log.trace("getClusterContents() - path:" + path);
        ArrayList<ClusterStorage> readers = this.findStorages(ClusterStorage.getClusterType(path), false);
        for (ClusterStorage thisReader : readers) {
            try {
                String[] thisArr = thisReader.getClusterContents(itemPath, path, transactionKey);
                if (thisArr == null) continue;
                for (int j = 0; j < thisArr.length; ++j) {
                    if (contents.contains(thisArr[j])) continue;
                    log.trace("getClusterContents() - {} reports {}", (Object)thisReader, (Object)thisArr[j]);
                    contents.add(thisArr[j]);
                }
            }
            catch (PersistencyException e) {
                if (!log.isDebugEnabled()) continue;
                log.error("getClusterContents() - reader {} could not retrieve contents of {}", new Object[]{thisReader, String.valueOf(itemPath) + "/" + path, e});
            }
        }
        log.trace("getClusterContents() - Returning " + contents.size() + " elements of path:" + path);
        String[] retArr = new String[]{};
        retArr = contents.toArray(retArr);
        return retArr;
    }

    public C2KLocalObject get(ItemPath itemPath, String path) throws PersistencyException, ObjectNotFoundException {
        return this.get(itemPath, path, null);
    }

    private C2KLocalObject retrive(ItemPath itemPath, String path, TransactionKey transactionKey) throws PersistencyException, ObjectNotFoundException {
        log.debug("retrive() - {}/{}", (Object)itemPath, (Object)path);
        C2KLocalObject result = null;
        ArrayList<ClusterStorage> readers = this.findStorages(ClusterStorage.getClusterType(path), false);
        for (ClusterStorage thisReader : readers) {
            try {
                result = thisReader.get(itemPath, path, transactionKey);
                if (result == null) continue;
                log.trace("retrive() - FOUND {}/{} in reader {}", new Object[]{itemPath, path, thisReader});
                break;
            }
            catch (PersistencyException e) {
                log.warn("retrive() - reader {} could not retrieve {}/{}", new Object[]{thisReader, itemPath, path, e});
            }
        }
        if (result == null) {
            throw new ObjectNotFoundException("Path " + itemPath.getItemName() + "/" + path + " not found");
        }
        return result;
    }

    public C2KLocalObject get(final ItemPath itemPath, String path, final TransactionKey transactionKey) throws PersistencyException, ObjectNotFoundException {
        StringTokenizer tok;
        String correctPath;
        if (StringUtils.isBlank((CharSequence)path) || path.equals("/")) {
            throw new ObjectNotFoundException("Path cannot be blank or contains '/' only - item:" + String.valueOf(itemPath));
        }
        ClusterType clusterType = ClusterType.getFromPath(path);
        if (clusterType == null) {
            throw new ObjectNotFoundException("Path '" + path + "' must start with one of the values of ClusterType - item:" + String.valueOf(itemPath));
        }
        String string = correctPath = path.startsWith("/") && path.length() > 1 ? path.substring(1) : path;
        if (correctPath.indexOf(47) == -1) {
            switch (clusterType) {
                case HISTORY: {
                    return new History(itemPath, transactionKey);
                }
                case JOB: {
                    return new C2KLocalObjectMap(itemPath, ClusterType.JOB, transactionKey);
                }
                case PROPERTY: {
                    return new C2KLocalObjectMap(itemPath, ClusterType.PROPERTY, transactionKey);
                }
                case COLLECTION: {
                    return new C2KLocalObjectMap(itemPath, ClusterType.COLLECTION, transactionKey);
                }
                case LIFECYCLE: {
                    return new C2KLocalObjectMap(itemPath, ClusterType.LIFECYCLE, transactionKey);
                }
                case OUTCOME: {
                    return new C2KLocalObjectMap(itemPath, ClusterType.OUTCOME, transactionKey);
                }
                case VIEWPOINT: {
                    return new C2KLocalObjectMap(itemPath, ClusterType.VIEWPOINT, transactionKey);
                }
                case ATTACHMENT: {
                    return new C2KLocalObjectMap(itemPath, ClusterType.ATTACHMENT, transactionKey);
                }
                case PATH: {
                    return new C2KLocalObjectMap(itemPath, ClusterType.PATH, transactionKey);
                }
            }
        }
        if (clusterType == ClusterType.VIEWPOINT && correctPath.endsWith("/data") && (tok = new StringTokenizer(correctPath, "/")).countTokens() == 4) {
            Viewpoint view = (Viewpoint)this.get(itemPath, correctPath.substring(0, correctPath.lastIndexOf("/")), transactionKey);
            if (view != null) {
                return view.getOutcome();
            }
            return null;
        }
        try {
            return (C2KLocalObject)this.cache.get((Object)this.getFullPath(itemPath, path), (Callable)new Callable<C2KLocalObject>(){

                @Override
                public C2KLocalObject call() throws PersistencyException, ObjectNotFoundException {
                    return ClusterStorageManager.this.retrive(itemPath, correctPath, transactionKey);
                }
            });
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                throw new PersistencyException(e);
            }
            if (cause instanceof PersistencyException) {
                throw (PersistencyException)cause;
            }
            if (cause instanceof ObjectNotFoundException) {
                throw (ObjectNotFoundException)cause;
            }
            throw new PersistencyException(cause);
        }
    }

    private String getFullPath(ItemPath itemPath, String path) {
        return itemPath.getUUID().toString() + (String)(path.startsWith("/") ? path : "/" + path);
    }

    public int getLastIntegerId(ItemPath itemPath, String path, TransactionKey transactionKey) throws PersistencyException {
        ArrayList<ClusterStorage> readers;
        Iterator<ClusterStorage> iterator;
        if (path.startsWith("/") && path.length() > 1) {
            path = path.substring(1);
        }
        if ((iterator = (readers = this.findStorages(ClusterType.HISTORY, false)).iterator()).hasNext()) {
            ClusterStorage storage = iterator.next();
            return storage.getLastIntegerId(itemPath, path, transactionKey);
        }
        return -1;
    }

    public void put(ItemPath itemPath, C2KLocalObject obj, TransactionKey transactionKey) throws PersistencyException {
        this.lockItem(itemPath, transactionKey);
        String path = ClusterStorage.getPath(obj);
        String fullPath = this.getFullPath(itemPath, path);
        ArrayList<ClusterStorage> writers = this.findStorages(ClusterStorage.getClusterType(path), true);
        for (ClusterStorage thisWriter : writers) {
            try {
                log.debug("put() - writing {} to {}", (Object)fullPath, (Object)thisWriter);
                thisWriter.put(itemPath, obj, transactionKey);
            }
            catch (PersistencyException e) {
                log.error("put() - writer {} could not store {}", new Object[]{thisWriter, fullPath, e});
                throw e;
            }
        }
        this.cache.put((Object)this.getFullPath(itemPath, path), (Object)obj);
        ProxyMessage message = new ProxyMessage(itemPath, path, ProxyMessage.Type.ADD);
        if (transactionKey != null) {
            this.keepMessageForLater(message, transactionKey);
        } else {
            Gateway.sendProxyEvent(message);
        }
    }

    public void remove(ItemPath itemPath, String path, TransactionKey transactionKey) throws PersistencyException {
        this.lockItem(itemPath, transactionKey);
        ArrayList<ClusterStorage> writers = this.findStorages(ClusterStorage.getClusterType(path), true);
        for (ClusterStorage thisWriter : writers) {
            try {
                log.debug("remove() - removing {}/{} from {}", new Object[]{itemPath, path, thisWriter});
                thisWriter.delete(itemPath, path, transactionKey);
            }
            catch (PersistencyException e) {
                log.error("remove() - writer {} could not delete {}/{}", new Object[]{thisWriter, itemPath, path, e});
                throw e;
            }
        }
        this.clearCache(itemPath, path);
        ProxyMessage message = new ProxyMessage(itemPath, path, ProxyMessage.Type.DELETE);
        if (transactionKey != null) {
            this.keepMessageForLater(message, transactionKey);
        } else {
            Gateway.sendProxyEvent(message);
        }
    }

    public void removeCluster(ItemPath itemPath, ClusterType cluster, TransactionKey transactionKey) throws PersistencyException {
        this.lockItem(itemPath, transactionKey);
        ArrayList<ClusterStorage> writers = this.findStorages(ClusterStorage.getClusterType(cluster.getName()), true);
        for (ClusterStorage thisWriter : writers) {
            try {
                log.debug("removeCluster() - removing {} from {}", (Object)cluster, (Object)thisWriter);
                thisWriter.delete(itemPath, cluster, transactionKey);
            }
            catch (PersistencyException e) {
                log.error("removeCluster() - writer {} could not delete {}", new Object[]{thisWriter, cluster, e});
                throw e;
            }
        }
        this.clearCache(itemPath, cluster);
        if (cluster != ClusterType.JOB) {
            ProxyMessage message = new ProxyMessage(itemPath, cluster.getName(), ProxyMessage.Type.DELETE);
            if (transactionKey != null) {
                this.keepMessageForLater(message, transactionKey);
            } else {
                Gateway.sendProxyEvent(message);
            }
        }
    }

    public void removeCluster(ItemPath itemPath, TransactionKey transactionKey) throws PersistencyException {
        this.lockItem(itemPath, transactionKey);
        ArrayList<ClusterStorage> writers = this.findStorages(ClusterType.ROOT, true);
        for (ClusterStorage thisWriter : writers) {
            try {
                log.debug("delete() - removing {} from {}", (Object)itemPath, (Object)thisWriter);
                thisWriter.delete(itemPath, transactionKey);
            }
            catch (PersistencyException e) {
                log.error("Writer:{} could not delete {}", new Object[]{thisWriter, itemPath, e});
                throw e;
            }
        }
        this.clearCache(itemPath);
        ProxyMessage message = new ProxyMessage(itemPath, itemPath.getItemName(), ProxyMessage.Type.DELETE);
        if (transactionKey != null) {
            this.keepMessageForLater(message, transactionKey);
        } else {
            Gateway.sendProxyEvent(message);
        }
    }

    public void removeCluster(ItemPath itemPath, String path, TransactionKey transactionKey) throws PersistencyException {
        String[] children;
        for (String element : children = this.getClusterContents(itemPath, path)) {
            this.removeCluster(itemPath, path + (path.length() > 0 ? "/" : "") + element, transactionKey);
        }
        if (children.length == 0 && path.indexOf("/") > -1) {
            this.remove(itemPath, path, transactionKey);
        }
    }

    public long clearCache(ItemPath itemPath, ClusterType cluster) {
        if (itemPath == null) {
            log.warn("clearCache() - either itemPath was null, NOTHING done");
            return 0L;
        }
        if (cluster == null) {
            return this.clearCache(itemPath);
        }
        return this.clearCache("^" + itemPath.getName() + "/" + cluster.getName());
    }

    public long clearCache(ItemPath itemPath) {
        if (itemPath == null) {
            log.warn("clearCache() - itemPath was null, NOTHING done");
            return 0L;
        }
        return this.clearCache("^" + itemPath.getName());
    }

    public long clearCache(String pattern) {
        log.debug("clearCache({}) - pattern:{}", (Object)pattern);
        Set keys = Sets.filter(this.cache.asMap().keySet(), (Predicate)Predicates.containsPattern((String)pattern));
        return this.clearCache(new ArrayList<String>(keys));
    }

    public long clearCache(ItemPath itemPath, String path) {
        if (itemPath == null || path == null) {
            log.warn("clearCache() - either itemPath or path was null, NOTHING done");
            return 0L;
        }
        String fullPath = this.getFullPath(itemPath, path);
        log.trace("clearCache() - removing {}", (Object)fullPath);
        this.cache.invalidate((Object)fullPath);
        return 1L;
    }

    public long clearCache(List<String> fullPathList) {
        log.trace("clearCache() - removing #{} entries", (Object)fullPathList.size());
        this.cache.invalidateAll(fullPathList);
        return fullPathList.size();
    }

    public long clearCache() {
        long size = this.cache.size();
        log.trace("clearCache() - clearing entire cache #{} enries.", (Object)size);
        this.cache.invalidateAll();
        return size;
    }

    public void begin(TransactionKey transactionKey) throws PersistencyException {
        if (transactionKey != null) {
            if (this.lockCatalog.containsKey(transactionKey)) {
                throw new PersistencyException("TransactionKey '" + String.valueOf(transactionKey) + "' is already in use");
            }
            this.lockCatalog.put(transactionKey, new LinkedHashSet());
        }
        for (ClusterStorage thisStore : this.allStores.values()) {
            thisStore.begin(transactionKey);
        }
    }

    public void commit(TransactionKey transactionKey) throws PersistencyException {
        for (ClusterStorage thisStore : this.allStores.values()) {
            thisStore.commit(transactionKey);
        }
        if (transactionKey != null) {
            if (this.lockCatalog.containsKey(transactionKey)) {
                for (ItemPath ip : this.lockCatalog.get(transactionKey)) {
                    this.itemLocks.remove(ip);
                }
            } else {
                throw new PersistencyException("TransactionKey '" + String.valueOf(transactionKey) + "' is unknown");
            }
            this.lockCatalog.remove(transactionKey);
            Gateway.sendProxyEvent(this.proxyMessagesMap.remove(transactionKey));
        }
    }

    public void abort(TransactionKey transactionKey) throws PersistencyException {
        for (ClusterStorage thisStore : this.allStores.values()) {
            thisStore.abort(transactionKey);
        }
        if (transactionKey != null) {
            if (this.lockCatalog.containsKey(transactionKey)) {
                for (ItemPath ip : this.lockCatalog.get(transactionKey)) {
                    this.itemLocks.remove(ip);
                }
            } else {
                throw new PersistencyException("TransactionKey '" + String.valueOf(transactionKey) + "' is unknown");
            }
            this.lockCatalog.remove(transactionKey);
            this.proxyMessagesMap.remove(transactionKey);
        }
    }

    public void postConnect() throws PersistencyException {
        for (ClusterStorage thisStore : this.allStores.values()) {
            thisStore.postConnect();
        }
    }

    public void postBoostrap() throws PersistencyException {
        for (ClusterStorage thisStore : this.allStores.values()) {
            thisStore.postBoostrap();
        }
    }

    public void postStartServer() throws PersistencyException {
        for (ClusterStorage thisStore : this.allStores.values()) {
            thisStore.postStartServer();
        }
    }

    private void keepMessageForLater(ProxyMessage message, TransactionKey transactionKey) {
        Set<ProxyMessage> set = this.proxyMessagesMap.get(transactionKey);
        if (set == null) {
            set = new HashSet<ProxyMessage>();
            this.proxyMessagesMap.put(transactionKey, set);
        }
        set.add(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void lockItem(ItemPath itemPath, TransactionKey transactionKey) throws PersistencyException {
        Map<ItemPath, TransactionKey> map = this.itemLocks;
        synchronized (map) {
            if (this.itemLocks.containsKey(itemPath)) {
                TransactionKey existingTransaction = this.itemLocks.get(itemPath);
                if (transactionKey == null || !existingTransaction.equals(transactionKey)) throw new PersistencyException("Access denied for '" + String.valueOf(transactionKey) + "': '" + String.valueOf(itemPath) + "' has been locked for writing by '" + String.valueOf(existingTransaction) + "'");
                this.lockCatalog.get(transactionKey).add(itemPath);
            } else {
                if (transactionKey == null) return;
                Set<ItemPath> lockEntry = this.lockCatalog.get(transactionKey);
                if (lockEntry == null) {
                    throw new PersistencyException("'" + String.valueOf(itemPath) + "' - No lockentry was found for transactionKey:" + String.valueOf(transactionKey));
                }
                lockEntry.add(itemPath);
                this.itemLocks.put(itemPath, transactionKey);
            }
            return;
        }
    }
}

