/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.persistency;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.events.History;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterStorage;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.AbstractMain;
import org.cristalise.kernel.querying.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionManager {
    private static final Logger log = LoggerFactory.getLogger(TransactionManager.class);
    private HashMap<ItemPath, TransactionKey> locks;
    HashMap<TransactionKey, ArrayList<TransactionEntry>> pendingTransactions;
    ClusterStorage storage;

    public TransactionManager(ClusterStorage s) throws PersistencyException {
        this.storage = s;
        this.locks = new HashMap();
        this.pendingTransactions = new HashMap();
    }

    public boolean hasPendingTransactions() {
        return this.pendingTransactions.size() > 0;
    }

    public String executeQuery(Query query, TransactionKey transactionKey) throws PersistencyException {
        return this.storage.executeQuery(query, transactionKey);
    }

    public String[] getClusterContents(ItemPath itemPath, ClusterType type) throws PersistencyException {
        return this.getClusterContents(itemPath, type, null);
    }

    public String[] getClusterContents(ItemPath itemPath, ClusterType type, TransactionKey transactionKey) throws PersistencyException {
        return this.getClusterContents(itemPath, type.getName(), transactionKey);
    }

    public String[] getClusterContents(ItemPath itemPath, String path) throws PersistencyException {
        return this.getClusterContents(itemPath, path, null);
    }

    public String[] getClusterContents(ItemPath itemPath, String path, TransactionKey transactionKey) throws PersistencyException {
        if (path.startsWith("/") && path.length() > 1) {
            path = path.substring(1);
        }
        ArrayList<String> uncomittedContents = new ArrayList<String>();
        if (this.locks.containsKey(itemPath) && this.locks.get(itemPath).equals(transactionKey)) {
            for (TransactionEntry thisEntry : this.pendingTransactions.get(transactionKey)) {
                if (!itemPath.equals(thisEntry.itemPath) || !thisEntry.path.startsWith(path)) continue;
                if (thisEntry.obj == null) {
                    throw new PersistencyException("TransactionManager.get() - Cluster " + path + " has been deleted in " + String.valueOf(itemPath) + " but not yet committed");
                }
                String content = StringUtils.substringAfterLast((String)thisEntry.path, (String)"/");
                uncomittedContents.add(content);
            }
        }
        return (String[])ArrayUtils.addAll((Object[])this.storage.getClusterContents(itemPath, path, transactionKey), (Object[])uncomittedContents.toArray(new String[uncomittedContents.size()]));
    }

    public C2KLocalObject get(ItemPath itemPath, String path, TransactionKey transactionKey) throws PersistencyException, ObjectNotFoundException {
        if (path.startsWith("/") && path.length() > 1) {
            path = path.substring(1);
        }
        if (path.indexOf(47) == -1) {
            if (path.equals((Object)ClusterType.HISTORY) && transactionKey != null) {
                return new History(itemPath, transactionKey);
            }
            if (!path.equals((Object)ClusterType.JOB) || transactionKey != null) {
                // empty if block
            }
        }
        if (this.locks.containsKey(itemPath) && this.locks.get(itemPath).equals(transactionKey)) {
            ArrayList<TransactionEntry> lockerTransaction = this.pendingTransactions.get(transactionKey);
            for (TransactionEntry thisEntry : lockerTransaction) {
                if (!itemPath.equals(thisEntry.itemPath) || !path.equals(thisEntry.path)) continue;
                if (thisEntry.obj == null) {
                    throw new PersistencyException("get() - Cluster " + path + " has been deleted in " + String.valueOf(itemPath) + " but not yet committed");
                }
                return thisEntry.obj;
            }
        }
        return this.storage.get(itemPath, path, transactionKey);
    }

    public void put(ItemPath itemPath, C2KLocalObject obj, TransactionKey transactionKey) throws PersistencyException {
        ArrayList<TransactionEntry> lockingTransaction = this.getLockingTransaction(itemPath, transactionKey);
        if (lockingTransaction == null) {
            this.storage.put(itemPath, obj, transactionKey);
            this.locks.remove(itemPath);
        } else {
            this.createTransactionEntry(itemPath, obj, null, lockingTransaction);
        }
    }

    public void remove(ItemPath itemPath, String path, TransactionKey transactionKey) throws PersistencyException {
        ArrayList<TransactionEntry> lockingTransaction = this.getLockingTransaction(itemPath, transactionKey);
        if (lockingTransaction == null) {
            this.storage.delete(itemPath, path, transactionKey);
            this.locks.remove(itemPath);
        } else {
            this.createTransactionEntry(itemPath, null, path, lockingTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ArrayList<TransactionEntry> getLockingTransaction(ItemPath itemPath, TransactionKey transactionKey) throws PersistencyException {
        HashMap<ItemPath, TransactionKey> hashMap = this.locks;
        synchronized (hashMap) {
            if (this.locks.containsKey(itemPath)) {
                TransactionKey thisLocker = this.locks.get(itemPath);
                if (!thisLocker.equals(transactionKey)) throw new PersistencyException("Access denied: '" + String.valueOf(itemPath) + "' has been locked for writing by " + String.valueOf(thisLocker));
                return this.pendingTransactions.get(transactionKey);
            }
            if (transactionKey == null) {
                this.locks.put(itemPath, new TransactionKey(itemPath));
                return null;
            }
            this.locks.put(itemPath, transactionKey);
            ArrayList<TransactionEntry> lockerTransaction = new ArrayList();
            this.pendingTransactions.put(transactionKey, lockerTransaction);
            return lockerTransaction;
        }
    }

    private void createTransactionEntry(ItemPath itemPath, C2KLocalObject c2kObj, String path, ArrayList<TransactionEntry> lockerTransaction) throws PersistencyException {
        TransactionEntry transEntry;
        if (c2kObj != null) {
            transEntry = new TransactionEntry(itemPath, c2kObj);
        } else if (path != null) {
            transEntry = new TransactionEntry(itemPath, path);
        } else {
            throw new PersistencyException("");
        }
        if (lockerTransaction.contains(transEntry)) {
            lockerTransaction.remove(transEntry);
        }
        lockerTransaction.add(transEntry);
    }

    public void removeCluster(ItemPath itemPath, String path, TransactionKey transactionKey) throws PersistencyException {
        String[] children;
        for (String element : children = this.getClusterContents(itemPath, path)) {
            this.removeCluster(itemPath, path + (path.length() > 0 ? "/" : "") + element, transactionKey);
        }
        if (children.length == 0 && path.indexOf("/") > -1) {
            this.remove(itemPath, path, transactionKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(TransactionKey transactionKey) throws PersistencyException {
        HashMap<ItemPath, TransactionKey> hashMap = this.locks;
        synchronized (hashMap) {
            ArrayList<TransactionEntry> lockerTransactions = this.pendingTransactions.get(transactionKey);
            if (lockerTransactions == null) {
                return;
            }
            try {
                this.storage.begin(transactionKey);
                for (TransactionEntry thisEntry : lockerTransactions) {
                    if (thisEntry.obj == null) {
                        this.storage.delete(thisEntry.itemPath, thisEntry.path, transactionKey);
                        continue;
                    }
                    this.storage.put(thisEntry.itemPath, thisEntry.obj, transactionKey);
                }
                this.storage.commit(transactionKey);
                for (TransactionEntry thisEntry : lockerTransactions) {
                    this.locks.remove(thisEntry.itemPath);
                }
                this.pendingTransactions.remove(transactionKey);
            }
            catch (Exception e) {
                this.storage.abort(transactionKey);
                log.error("commit() - Problems during transaction commit of transactionKey " + transactionKey.toString() + ". Database may be in an inconsistent state.");
                this.dumpPendingTransactions(0);
                AbstractMain.shutdown(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort(TransactionKey transactionKey) {
        HashMap<ItemPath, TransactionKey> hashMap = this.locks;
        synchronized (hashMap) {
            if (this.locks.containsValue(transactionKey)) {
                for (ItemPath thisPath : this.locks.keySet()) {
                    if (!this.locks.get(thisPath).equals(transactionKey)) continue;
                    this.locks.remove(thisPath);
                }
            }
            this.pendingTransactions.remove(transactionKey);
        }
    }

    public void dumpPendingTransactions(int logLevel) {
        log.error("Transaction dump. Locked Items:");
        if (this.locks.size() == 0) {
            log.error("  None");
        } else {
            for (ItemPath itemPath : this.locks.keySet()) {
                TransactionKey transactionKey = this.locks.get(itemPath);
                log.error("  " + String.valueOf(itemPath) + " locked by " + String.valueOf(transactionKey));
            }
        }
        log.error("Open transactions:");
        if (this.pendingTransactions.size() == 0) {
            log.error("  None");
        } else {
            for (Object object : this.pendingTransactions.keySet()) {
                log.error("  Transaction owner:" + String.valueOf(object));
                ArrayList<TransactionEntry> entries = this.pendingTransactions.get(object);
                for (TransactionEntry thisEntry : entries) {
                    log.error("    " + thisEntry.toString());
                }
            }
        }
    }

    public void postConnect() throws PersistencyException {
        this.storage.postConnect();
    }

    public void postBoostrap() throws PersistencyException {
        this.storage.postBoostrap();
    }

    public void postStartServer() throws PersistencyException {
        this.storage.postStartServer();
    }

    public int getLastIntegerId(ItemPath itemPath, String path) throws PersistencyException {
        return this.storage.getLastIntegerId(itemPath, path, null);
    }

    static class TransactionEntry {
        public ItemPath itemPath;
        public String path;
        public C2KLocalObject obj;

        public TransactionEntry(ItemPath itemPath, C2KLocalObject obj) {
            this.itemPath = itemPath;
            this.path = ClusterStorage.getPath(obj);
            this.obj = obj;
        }

        public TransactionEntry(ItemPath itemPath, String path) {
            this.itemPath = itemPath;
            this.path = path;
            this.obj = null;
        }

        public String toString() {
            StringBuffer report = new StringBuffer();
            if (this.obj == null) {
                report.append("Delete");
            } else {
                report.append("Put " + this.obj.getClass().getName());
            }
            report.append(" at ").append(this.path).append(" in ").append(this.itemPath);
            return report.toString();
        }

        public int hashCode() {
            return this.itemPath.hashCode() * this.path.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof TransactionEntry) {
                return this.hashCode() == ((TransactionEntry)other).hashCode();
            }
            return false;
        }
    }
}

