/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.process;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.cristalise.kernel.process.Bootstrap;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.ShutdownHandler;
import org.cristalise.kernel.process.resource.BadArgumentsException;
import org.cristalise.kernel.utils.FileStringUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMain {
    private static final Logger log = LoggerFactory.getLogger(AbstractMain.class);
    public static boolean isServer = false;
    private static ShutdownHandler shutdownHandler;
    public static final String MAIN_ARG_CONFIG = "config";
    public static final String MAIN_ARG_CONNECT = "connect";
    public static final String MAIN_ARG_SKIPBOOTSTRAP = "skipBootstrap";

    public static Properties readC2KArgs(String[] args) throws BadArgumentsException {
        String configPath;
        Properties argProps = new Properties();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-") && args[i].length() > 1) {
                String key = args[i].substring(1);
                if (argProps.containsKey(key)) {
                    throw new BadArgumentsException("Argument " + args[i] + " given twice");
                }
                String value = "";
                if (args.length > i + 1 && !args[i + 1].startsWith("-")) {
                    value = args[++i];
                }
                argProps.put(key, value);
                continue;
            }
            throw new BadArgumentsException("Bad argument: " + args[i]);
        }
        if (log.isInfoEnabled()) {
            Enumeration<?> e = argProps.propertyNames();
            while (e.hasMoreElements()) {
                String next = (String)e.nextElement();
                log.info("args param {}:{}", (Object)next, (Object)argProps.getProperty(next));
            }
        }
        if ((configPath = argProps.getProperty(MAIN_ARG_CONFIG)) == null) {
            throw new BadArgumentsException("Config file not specified");
        }
        String connectFile = argProps.getProperty(MAIN_ARG_CONNECT);
        if (connectFile == null) {
            throw new BadArgumentsException("Connect file not specified");
        }
        Properties c2kProps = AbstractMain.readPropertyFiles(configPath, connectFile, argProps);
        log.info("readC2KArgs() DONE.");
        return c2kProps;
    }

    public static Properties readPropertyFiles(String configFile, String connectFile, Properties argProps) throws BadArgumentsException {
        log.info("readPropertyFiles() - config:{} connect:{}", (Object)configFile, (Object)connectFile);
        try {
            Properties c2kProps = FileStringUtility.loadConfigFile(configFile);
            if (argProps != null) {
                c2kProps.putAll((Map<?, ?>)argProps);
            }
            FileStringUtility.appendConfigFile(c2kProps, connectFile);
            if (!c2kProps.containsKey("LocalCentre")) {
                String connectFileName = new File(connectFile).getName();
                String centreId = connectFileName.substring(0, connectFileName.lastIndexOf(".clc"));
                c2kProps.setProperty("LocalCentre", centreId);
            }
            if (argProps != null) {
                c2kProps.putAll((Map<?, ?>)argProps);
            }
            return c2kProps;
        }
        catch (IOException e) {
            log.error("readPropertyFiles() - Error reading config files", (Throwable)e);
            throw new BadArgumentsException(e);
        }
    }

    public static void setShutdownHandler(ShutdownHandler handler) {
        shutdownHandler = handler;
    }

    public static void shutdown(int errCode) {
        Bootstrap.abort();
        if (shutdownHandler != null) {
            shutdownHandler.shutdown(errCode, isServer);
        }
        try {
            Gateway.close();
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
        }
        throw new ThreadDeath();
    }
}

