/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.process;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.SystemProperties;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.Job;
import org.cristalise.kernel.entity.imports.ImportAgent;
import org.cristalise.kernel.entity.imports.ImportRole;
import org.cristalise.kernel.lifecycle.CompositeActivityDef;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.Workflow;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lifecycle.instance.predefined.UpdateImportReport;
import org.cristalise.kernel.lifecycle.instance.predefined.server.ServerPredefinedStepContainer;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.LookupManager;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.process.AbstractMain;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.UserCodeProcess;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.process.resource.ResourceImportHandler;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.security.BuiltInAuthc;
import org.cristalise.kernel.utils.FileStringUtility;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bootstrap {
    private static final Logger log = LoggerFactory.getLogger(Bootstrap.class);
    static DomainPath thisServerPath;
    public static boolean shutdown;

    static void init() throws Exception {
        TransactionKey transactionKey = new TransactionKey("Bootstrap-Init");
        Gateway.getStorage().begin(transactionKey);
        try {
            Bootstrap.checkAdminAgents(transactionKey);
            ItemPath serverItem = Bootstrap.createServerItem(transactionKey);
            Bootstrap.storeSystemProperties(serverItem, transactionKey);
            Gateway.getStorage().commit(transactionKey);
        }
        catch (Exception e) {
            log.error("init()", (Throwable)e);
            Gateway.getStorage().abort(transactionKey);
            throw e;
        }
    }

    static void run() throws Exception {
        Bootstrap.init();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.currentThread().setName("Bootstrapper");
                    log.info("run() - Bootstrapper started");
                    ClassLoader wClassLoader = Bootstrap.class.getClassLoader();
                    log.info("run() setContextClassLoader=[{}]", (Object)wClassLoader);
                    Thread.currentThread().setContextClassLoader(wClassLoader);
                    if (!shutdown) {
                        log.info("run() - Verifying kernel boot data items");
                        Bootstrap.verifyBootDataItems();
                    }
                    if (!shutdown) {
                        Gateway.getModuleManager().setUser(Gateway.getAgentProxy((AgentPath)BuiltInAuthc.SYSTEM_AGENT.getPath()));
                        Gateway.getModuleManager().registerModules();
                    }
                    if (!shutdown) {
                        log.info("run() - RegisterModules complete");
                        Gateway.getModuleManager().runScripts("initialized");
                        if (Gateway.getLookupManager() != null) {
                            Gateway.getLookupManager().postBoostrap();
                        }
                        Gateway.getStorage().postBoostrap();
                        log.info("run() - Bootstrapper complete");
                    }
                }
                catch (Throwable e) {
                    log.error("Exception performing bootstrap. Check that everything is OK.", e);
                    AbstractMain.shutdown(1);
                }
            }
        }).start();
    }

    public static void abort() {
        shutdown = true;
    }

    public static void verifyBootDataItems() throws Exception {
        log.info("verifyBootDataItems() - Start checking kernel descriptions ...");
        String bootItems = FileStringUtility.url2String(Gateway.getResource().getKernelResourceURL("boot/allbootitems.txt"));
        TransactionKey transactionKey = new TransactionKey("Bootstrap-VerifyBootDataItems");
        Gateway.getStorage().begin(transactionKey);
        try {
            Bootstrap.verifyBootDataItems(bootItems, null, true, transactionKey);
            Gateway.getStorage().commit(transactionKey);
        }
        catch (Exception e) {
            Gateway.getStorage().abort(transactionKey);
            throw e;
        }
        log.info("verifyBootDataItems() - DONE.");
    }

    private static void verifyBootDataItems(String bootList, String ns, boolean reset, TransactionKey transactionKey) throws Exception {
        StringTokenizer str = new StringTokenizer(bootList, "\n\r");
        ArrayList<String> kernelChanges = new ArrayList<String>();
        while (str.hasMoreTokens() && !shutdown) {
            String thisItem = str.nextToken();
            String[] idFilename = thisItem.split(",");
            String id = idFilename[0];
            String filename = idFilename[1];
            ItemPath itemPath = new ItemPath(id);
            String[] fileParts = filename.split("/");
            String itemType = fileParts[0];
            String itemName = fileParts[1];
            String location = "boot/" + filename + (itemType.equals("OD") ? ".xsd" : ".xml");
            ResourceImportHandler importHandler = Gateway.getResourceImportHandler(BuiltInResources.getValue(itemType));
            importHandler.importResource(ns, itemName, 0, itemPath, location, reset, transactionKey);
            kernelChanges.add(importHandler.getResourceChangeDetails());
        }
        StringBuffer moduleChangesXML = new StringBuffer("<ModuleChanges>\n");
        moduleChangesXML.append("<ModuleName>kernel</ModuleName>");
        moduleChangesXML.append("<ModuleVersion>0</ModuleVersion>");
        for (String oneChange : kernelChanges) {
            moduleChangesXML.append(oneChange).append("\n");
        }
        moduleChangesXML.append("</ModuleChanges>");
        if (StringUtils.isNotBlank((CharSequence)moduleChangesXML)) {
            new UpdateImportReport().request((AgentPath)BuiltInAuthc.SYSTEM_AGENT.getPath(transactionKey), thisServerPath.getItemPath(), moduleChangesXML.toString(), transactionKey);
        }
    }

    private static AgentPath checkOrCreateAgent(String name, String pass, ImportRole rolePath, UUID uuid, TransactionKey transactionKey) throws Exception {
        ImportAgent iAgent = new ImportAgent(name, pass);
        iAgent.addRole(rolePath);
        if (iAgent.exists(transactionKey)) {
            log.info("checkOrCreateAgent() - Agent '" + name + "' was found.");
        } else {
            log.info("checkOrCreateAgent() - Agent '" + name + "' NOT found. Creating.");
            AgentPath agentPath = new AgentPath(new ItemPath(uuid), name);
            iAgent.setItemPath(agentPath);
            iAgent.create(agentPath, false, transactionKey);
        }
        return iAgent.getAgentPath(transactionKey);
    }

    public static void checkAdminAgents(TransactionKey transactionKey) throws Exception {
        RolePath rootRole = new RolePath();
        if (!rootRole.exists(transactionKey)) {
            Gateway.getLookupManager().createRole(rootRole, transactionKey);
        }
        RolePath adminRole = new RolePath(rootRole, BuiltInAuthc.ADMIN_ROLE.getName(), false, Arrays.asList("*"));
        ImportRole importAdminRole = ImportRole.getImportRole(adminRole);
        if (adminRole.exists(transactionKey)) {
            importAdminRole.update(null, transactionKey);
        } else {
            importAdminRole.create(null, false, transactionKey);
        }
        Bootstrap.checkOrCreateAgent(BuiltInAuthc.SYSTEM_AGENT.getName(), null, importAdminRole, new UUID(0L, 1L), transactionKey);
        ImportRole importUCRole = UserCodeProcess.getImportRole();
        if (!importUCRole.exists(transactionKey)) {
            importUCRole.create(null, false, transactionKey);
        }
        String ucName = UserCodeProcess.getAgentName();
        String ucPwd = UserCodeProcess.getAgentPassword();
        Bootstrap.checkOrCreateAgent(ucName, ucPwd, importUCRole, UUID.randomUUID(), transactionKey);
    }

    private static ItemPath createServerItem(TransactionKey transactionKey) throws Exception {
        ItemPath serverItem;
        LookupManager lookupManager = Gateway.getLookupManager();
        String serverName = SystemProperties.ItemServer_name.getString(InetAddress.getLocalHost().getHostName());
        thisServerPath = new DomainPath("/servers/" + serverName);
        try {
            serverItem = thisServerPath.getItemPath();
        }
        catch (ObjectNotFoundException ex) {
            log.info("Creating server item " + String.valueOf(thisServerPath));
            serverItem = new ItemPath();
            lookupManager.add(serverItem, transactionKey);
            thisServerPath.setItemPath(serverItem);
            lookupManager.add(thisServerPath, transactionKey);
        }
        Gateway.getStorage().put(serverItem, new Property(BuiltInItemProperties.NAME, serverName, false), transactionKey);
        Gateway.getStorage().put(serverItem, new Property(BuiltInItemProperties.TYPE, "Server", false), transactionKey);
        Gateway.getStorage().put(serverItem, new Property(BuiltInItemProperties.KERNEL_VERSION, Gateway.getKernelVersion(), true), transactionKey);
        Bootstrap.initServerItemWfAndJobs(transactionKey);
        return serverItem;
    }

    private static void storeSystemProperties(ItemPath serverItem, TransactionKey transactionKey) throws Exception {
        Outcome newOutcome = Gateway.getProperties().convertToOutcome("Bootstrap");
        newOutcome.validateAndCheck();
        PredefinedStep.storeOutcomeEventAndViews(serverItem, newOutcome, transactionKey);
    }

    private static void initServerItemWfAndJobs(TransactionKey transactionKey) throws Exception {
        AgentPath systemAgent = (AgentPath)BuiltInAuthc.SYSTEM_AGENT.getPath(transactionKey);
        ItemPath serverItem = thisServerPath.getItemPath(transactionKey);
        CompositeActivityDef serverWfCa = LocalObjectLoader.getCompActDef("ServerItemWorkflow", 0, transactionKey);
        Workflow wf = new Workflow((CompositeActivity)serverWfCa.instantiate(transactionKey), new ServerPredefinedStepContainer());
        wf.initialise(serverItem, systemAgent, transactionKey);
        Gateway.getStorage().removeCluster(serverItem, ClusterType.JOB, transactionKey);
        List newJobs = ((CompositeActivity)wf.search("workflow/domain")).calculateJobs(systemAgent, serverItem, true);
        for (Job newJob : newJobs) {
            Gateway.getStorage().put(serverItem, newJob, transactionKey);
            if (!StringUtils.isNotBlank((CharSequence)newJob.getRoleOverride())) continue;
            newJob.sendToRoleChannel();
        }
        Gateway.getStorage().put(serverItem, wf, transactionKey);
    }

    static {
        shutdown = false;
    }
}

