/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.process;

import com.hazelcast.config.Config;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.ThreadingModel;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.cli.Argument;
import io.vertx.core.cli.CLI;
import io.vertx.core.cli.CommandLine;
import io.vertx.core.cli.Option;
import io.vertx.core.json.JsonArray;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.ext.shell.ShellService;
import io.vertx.ext.shell.ShellServiceOptions;
import io.vertx.ext.shell.command.CommandBuilder;
import io.vertx.ext.shell.command.CommandProcess;
import io.vertx.ext.shell.command.CommandRegistry;
import io.vertx.ext.shell.term.TelnetTermOptions;
import io.vertx.spi.cluster.hazelcast.ConfigUtil;
import io.vertx.spi.cluster.hazelcast.HazelcastClusterManager;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.SystemProperties;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.CriseVertxException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.entity.ItemVerticle;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.entity.proxy.ProxyManager;
import org.cristalise.kernel.entity.proxy.ProxyMessage;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Lookup;
import org.cristalise.kernel.lookup.LookupManager;
import org.cristalise.kernel.persistency.ClusterStorageManager;
import org.cristalise.kernel.process.AbstractMain;
import org.cristalise.kernel.process.Bootstrap;
import org.cristalise.kernel.process.TcpBridgeVerticle;
import org.cristalise.kernel.process.module.ModuleManager;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.process.resource.DefaultResourceImportHandler;
import org.cristalise.kernel.process.resource.Resource;
import org.cristalise.kernel.process.resource.ResourceImportHandler;
import org.cristalise.kernel.process.resource.ResourceLoader;
import org.cristalise.kernel.security.SecurityManager;
import org.cristalise.kernel.utils.CastorXMLUtility;
import org.cristalise.kernel.utils.ObjectProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Gateway
extends ProxyManager {
    private static final Logger log = LoggerFactory.getLogger(Gateway.class);
    private static ObjectProperties mC2KProps = new ObjectProperties();
    private static ModuleManager mModules;
    private static Vertx mVertx;
    private static Lookup mLookup;
    private static LookupManager mLookupManager;
    private static ClusterStorageManager mStorage;
    private static CastorXMLUtility mMarshaller;
    private static ResourceLoader mResource;
    private static SecurityManager mSecurityManager;
    @Deprecated
    private static ProxyManager mProxyManager;
    private static HashMap<BuiltInResources, ResourceImportHandler> resourceImportHandlerCache;

    private Gateway() {
    }

    public static void init(Properties props) throws InvalidDataException {
        Gateway.init(props, null);
    }

    public static void init(Properties props, ResourceLoader res) throws InvalidDataException {
        Properties allModuleProperties;
        System.setProperty("vertx.logger-delegate-factory-class-name", "io.vertx.core.logging.SLF4JLogDelegateFactory");
        System.setProperty("hazelcast.logging.type", "slf4j");
        System.setProperty("hazelcast.ignoreXxeProtectionFailures", "true");
        mC2KProps.clear();
        mResource = res;
        if (mResource == null) {
            mResource = new Resource();
        }
        log.info("Kernel version: " + Gateway.getKernelVersion());
        try {
            mMarshaller = new CastorXMLUtility(mResource, props, mResource.getKernelResourceURL("mapFiles/"));
        }
        catch (MalformedURLException e1) {
            throw new InvalidDataException("Invalid Resource Location");
        }
        try {
            mModules = new ModuleManager(AbstractMain.isServer);
            allModuleProperties = mModules.loadModules(mResource.getModuleDefURLs());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new InvalidDataException("Could not load module definitions.");
        }
        Enumeration<?> e = allModuleProperties.propertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            mC2KProps.put(propName, allModuleProperties.get(propName));
        }
        if (props != null) {
            mC2KProps.putAll((Map<?, ?>)props);
        }
        log.info("init() - DONE");
        Gateway.dumpC2KProps();
    }

    private static void clearCacheHandler(CommandProcess process) {
        CommandLine commandLine = process.commandLine();
        String cmdName = commandLine.cli().getName();
        try {
            String item = (String)commandLine.getArgumentValue(0);
            if (StringUtils.isNotBlank((CharSequence)item)) {
                ItemPath ip = null;
                ip = ItemPath.isUUID(item) ? Gateway.getLookup().getItemPath(item) : Gateway.getLookup().resolvePath(new DomainPath(item));
                if (cmdName.startsWith("storage-")) {
                    Gateway.getStorage().clearCache(ip);
                }
                process.write("Command " + cmdName + " was executed for item:" + item + "\n");
            } else {
                if (cmdName.startsWith("storage-")) {
                    Gateway.getStorage().clearCache();
                }
                process.write("Command " + cmdName + " was executed for ALL items.\n");
            }
        }
        catch (Exception e) {
            log.error(cmdName, (Throwable)e);
            process.write("ERROR executing " + cmdName + ":" + e.getMessage() + "\n");
        }
        process.end();
    }

    private static void addClearCacheCommand(String cmdName) {
        String summary = "Clear the Proxy cache";
        if (cmdName.startsWith("storage-")) {
            summary = "Clear the Storage cache";
        }
        CLI cli = CLI.create((String)cmdName).setSummary(summary).addOption(new Option().setShortName("h").setLongName("help").setHelp(true).setFlag(true)).addArgument(new Argument().setArgName("item").setRequired(false).setDescription("UUID or the DomainPath of the Item"));
        CommandBuilder command = CommandBuilder.command((CLI)cli).processHandler(Gateway::clearCacheHandler);
        CommandRegistry registry = CommandRegistry.getShared((Vertx)mVertx);
        registry.registerCommand(command.build(mVertx));
    }

    private static void createServerVerticles() {
        DeploymentOptions options = new DeploymentOptions().setThreadingModel(ThreadingModel.VIRTUAL_THREAD).setInstances(ItemVerticle.instances);
        mVertx.deployVerticle(ItemVerticle.class, options);
        options.setInstances(Gateway.getProperties().getInt("JobPusherVerticle.instances", 2));
        options.setInstances(1);
        options.setThreadingModel(ThreadingModel.EVENT_LOOP);
        mVertx.deployVerticle(TcpBridgeVerticle.class, options);
    }

    private static void createTelnetShellService(String host, int port) {
        ShellServiceOptions options = new ShellServiceOptions().setTelnetOptions(new TelnetTermOptions().setHost(host).setPort(port));
        ShellService.create((Vertx)mVertx, (ShellServiceOptions)options).start();
    }

    public static void startServer() throws InvalidDataException, CannotManageException {
        try {
            if (!(mLookup instanceof LookupManager)) {
                throw new CannotManageException("Lookup implementation is not a LookupManager. Cannot write to directory");
            }
            mLookupManager = (LookupManager)mLookup;
            mLookupManager.initializeDirectory(null);
            Gateway.createServerVerticles();
            Gateway.addClearCacheCommand("storage-clearCache");
            String host = SystemProperties.ItemServer_Telnet_host.getString();
            int port = SystemProperties.ItemServer_Telnet_port.getInteger();
            if (port != 0) {
                Gateway.createTelnetShellService(host, port);
            }
            log.info("startServer() - DONE.");
            if (mLookupManager != null) {
                mLookupManager.postStartServer();
            }
            mStorage.postStartServer();
        }
        catch (Exception ex) {
            log.error("startServer() - Exception starting server components. Shutting down.", (Throwable)ex);
            AbstractMain.shutdown(1);
        }
    }

    public static ModuleManager getModuleManager() {
        return mModules;
    }

    private static void createVertx(VertxOptions options, boolean clustered) throws CriseVertxException {
        if (mVertx == null) {
            if (clustered) {
                Config hazelcastConfig = ConfigUtil.loadConfig();
                if (!AbstractMain.isServer) {
                    hazelcastConfig.setLiteMember(true);
                }
                HazelcastClusterManager mgr = new HazelcastClusterManager(hazelcastConfig);
                options.setClusterManager((ClusterManager)mgr);
                CompletableFuture future = new CompletableFuture();
                Vertx.clusteredVertx((VertxOptions)options, result -> {
                    if (result.succeeded()) {
                        mVertx = (Vertx)result.result();
                        log.info("createVertx(clustered) -  Done");
                        future.complete(null);
                    } else {
                        log.error("createVertx(clustered)", result.cause());
                        future.completeExceptionally(result.cause());
                    }
                });
                try {
                    future.get(60L, TimeUnit.SECONDS);
                }
                catch (ExecutionException e) {
                    throw CriseVertxException.convertFutureException(e);
                }
                catch (InterruptedException | CancellationException | TimeoutException e) {
                    log.error("createVertx(clustered)", (Throwable)e);
                    throw new CannotManageException(e);
                }
            } else {
                mVertx = Vertx.vertx((VertxOptions)options);
                log.info("createVertx() -  Done");
            }
        }
    }

    private static void setup() throws CriseVertxException {
        if (mLookup != null) {
            mLookup.close();
        }
        Gateway.createVertx(new VertxOptions(), SystemProperties.Gateway_clusteredVertx.getBoolean());
        try {
            mLookup = (Lookup)SystemProperties.Lookup.getInstance(new Object[0]);
            mLookup.open();
        }
        catch (ReflectiveOperationException ex) {
            log.error("", (Throwable)ex);
            throw new InvalidDataException("Cannot connect server process. Please check config.", (Throwable)ex);
        }
        mStorage = new ClusterStorageManager();
        mProxyManager = new ProxyManager();
    }

    public static void connect() throws CriseVertxException {
        mSecurityManager = new SecurityManager();
        mSecurityManager.authenticate();
        Gateway.setup();
        log.info("connect(system) - DONE.");
        mStorage.postConnect();
    }

    public static AgentProxy connect(String agentName, String agentPassword) throws CriseVertxException {
        return Gateway.connect(agentName, agentPassword, null);
    }

    public static AgentProxy connect(String agentName, String agentPassword, String resource) throws CriseVertxException {
        mSecurityManager = new SecurityManager();
        mSecurityManager.authenticate(agentName, agentPassword, resource, true, null);
        Gateway.setup();
        AgentProxy agent = Gateway.getAgentProxy(agentName);
        mModules.setUser(agent);
        mModules.runScripts("startup");
        log.info("connect(agent) - DONE.");
        mStorage.postConnect();
        return agent;
    }

    public static void close() {
        if (mModules != null) {
            mModules.runScripts("shutdown");
        }
        if (mVertx != null) {
            mVertx.close();
        }
        if (mStorage != null) {
            mStorage.close();
        }
        mStorage = null;
        if (mLookup != null) {
            mLookup.close();
        }
        mLookup = null;
        mLookupManager = null;
        mProxyManager = null;
        if (mVertx != null) {
            mVertx.close();
        }
        mModules = null;
        mResource = null;
        mMarshaller = null;
        mC2KProps.clear();
    }

    public static SecurityManager getSecurityManager() {
        return mSecurityManager;
    }

    public static Lookup getLookup() {
        return mLookup;
    }

    public static LookupManager getLookupManager() throws CannotManageException {
        if (mLookupManager == null) {
            throw new CannotManageException("No Lookup Manager created. Not a server process.");
        }
        return mLookupManager;
    }

    public static Vertx getVertx() {
        return mVertx;
    }

    public static ClusterStorageManager getStorage() {
        return mStorage;
    }

    public static CastorXMLUtility getMarshaller() {
        return mMarshaller;
    }

    public static ResourceLoader getResource() {
        return mResource;
    }

    public static ProxyManager getProxyManager() {
        return mProxyManager;
    }

    public static String getCentreId() {
        return Gateway.getProperties().getString("LocalCentre");
    }

    public static Enumeration<?> propertyNames() {
        return mC2KProps.propertyNames();
    }

    public static void dumpC2KProps() {
        mC2KProps.dumpProps();
    }

    public static ObjectProperties getProperties() {
        return mC2KProps;
    }

    public static String getKernelVersion() {
        try {
            return mResource.getTextResource(null, "textFiles/version.txt");
        }
        catch (Exception ex) {
            return "No version info found";
        }
    }

    @Deprecated
    public static ResourceImportHandler getResourceImportHandler(String resType) throws Exception {
        return Gateway.getResourceImportHandler(BuiltInResources.getValue(resType));
    }

    public static ResourceImportHandler getResourceImportHandler(BuiltInResources resType) throws Exception {
        if (resourceImportHandlerCache.containsKey((Object)resType)) {
            return resourceImportHandlerCache.get((Object)resType);
        }
        Object[] args = new Object[]{resType.toString()};
        ResourceImportHandler handler = null;
        if (SystemProperties.ResourceImportHandler_$typeCode.getObject(args) != null) {
            try {
                handler = (ResourceImportHandler)SystemProperties.ResourceImportHandler_$typeCode.getInstance(args);
            }
            catch (Exception ex) {
                log.error("Exception loading ResourceHandler for " + String.valueOf((Object)resType) + ". Using default.", (Throwable)ex);
            }
        }
        if (handler == null) {
            handler = new DefaultResourceImportHandler(resType);
        }
        resourceImportHandlerCache.put(resType, handler);
        return handler;
    }

    public static void runBoostrap() throws Exception {
        if (Gateway.getProperties().containsKey("skipBootstrap")) {
            Bootstrap.init();
            if (mLookupManager != null) {
                mLookupManager.postBoostrap();
            }
            mStorage.postBoostrap();
        } else {
            Bootstrap.run();
        }
    }

    public static void sendProxyEvent(ProxyMessage message) {
        HashSet<ProxyMessage> messages = new HashSet<ProxyMessage>();
        messages.add(message);
        Gateway.sendProxyEvent(messages);
    }

    public static void sendProxyEvent(Set<ProxyMessage> messages) {
        if (Gateway.getVertx() == null) {
            log.warn("sendProxyEvent() - vertx was not initialised, messages were not sent:{}", messages);
            return;
        }
        JsonArray msgArray = new JsonArray();
        for (ProxyMessage m : messages) {
            msgArray.add((Object)m.toString());
        }
        Gateway.getVertx().eventBus().publish("cristalise-proxyMessage", (Object)msgArray);
    }

    static {
        mLookupManager = null;
        mSecurityManager = null;
        resourceImportHandlerCache = new HashMap();
    }
}

