/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.process;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Promise;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.json.JsonArray;
import java.util.ArrayList;
import org.cristalise.kernel.SystemProperties;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.entity.proxy.ProxyMessage;
import org.cristalise.kernel.process.Gateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalChangeVerticle
extends AbstractVerticle {
    private static final Logger log = LoggerFactory.getLogger(LocalChangeVerticle.class);

    public void start(Promise<Void> startPromise) throws Exception {
        this.vertx.eventBus().consumer("cristalise-proxyMessage", message -> {
            JsonArray messageArray = (JsonArray)message.body();
            log.trace("handler() - message.body:{}", (Object)messageArray);
            boolean publish = SystemProperties.LocalChangeVerticle_publishLocalMessage.getBoolean();
            try {
                this.clearCache(messageArray);
                this.publishOrSendLocalMessages(messageArray, publish);
            }
            catch (Exception e) {
                log.error("handler()", (Throwable)e);
            }
        });
        startPromise.complete();
        log.info("start() - '{}' consumer configured", (Object)"cristalise-proxyMessage");
    }

    private void publishOrSendLocalMessages(JsonArray messageArray, boolean publish) throws InvalidDataException {
        DeliveryOptions opt = new DeliveryOptions().setLocalOnly(true);
        if (publish) {
            log.debug("publishOrSendLocalMessages() - publishing #{} ProxyMessages to address:{}", (Object)messageArray.size(), (Object)"cristalise-localProxyMessage");
            this.vertx.eventBus().publish("cristalise-localProxyMessage", (Object)messageArray, opt);
        } else {
            log.debug("publishOrSendLocalMessages() - sending #{} ProxyMessages to address:{}", (Object)messageArray.size(), (Object)"cristalise-localProxyMessage");
            this.vertx.eventBus().send("cristalise-localProxyMessage", (Object)messageArray, opt);
        }
        for (Object element : messageArray) {
            ProxyMessage msg = new ProxyMessage((String)element);
            String ebAddress = msg.getLocalEventBusAddress();
            String ebMsg = msg.getLocalEventBusMessage();
            if (publish) {
                log.debug("publishOrSendLocalMessages() - publishing to address:{}, msg:{}", (Object)ebAddress, (Object)ebMsg);
                this.vertx.eventBus().publish(ebAddress, (Object)ebMsg, opt);
                continue;
            }
            log.debug("publishOrSendLocalMessages() - sending to address:{}, msg:{}", (Object)ebAddress, (Object)ebMsg);
            this.vertx.eventBus().send(ebAddress, (Object)ebMsg, opt);
        }
    }

    private void clearCache(JsonArray proxyMessages) throws InvalidDataException {
        ArrayList<String> clearCacheList = new ArrayList<String>();
        for (Object element : proxyMessages) {
            ProxyMessage msg = new ProxyMessage((String)element);
            if (!msg.isClusterStoreMesssage()) continue;
            String key = String.valueOf(msg.getItemPath().getUUID()) + "/" + msg.getPath();
            log.trace("clearCache() - adding entry:{}", (Object)key);
            clearCacheList.add(key);
        }
        Gateway.getStorage().clearCache(clearCacheList);
    }

    public void stop() throws Exception {
        log.info("stop() - '{}' consumer", (Object)"cristalise-proxyMessage");
    }
}

