/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.process;

import io.vertx.core.Verticle;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.SystemProperties;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.entity.proxy.TcpBridgeClientVerticle;
import org.cristalise.kernel.lifecycle.instance.stateMachine.StateMachine;
import org.cristalise.kernel.process.AbstractMain;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.LocalChangeVerticle;
import org.cristalise.kernel.process.resource.ResourceLoader;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StandardClient
extends AbstractMain {
    private static final Logger log = LoggerFactory.getLogger(StandardClient.class);
    protected AgentProxy agent = null;

    public static void createClientVerticles() {
        String host = SystemProperties.TcpBridge_host.getString();
        if (StringUtils.isNotBlank((CharSequence)host)) {
            Gateway.getVertx().deployVerticle((Verticle)new TcpBridgeClientVerticle());
        }
        Gateway.getVertx().deployVerticle((Verticle)new LocalChangeVerticle());
    }

    protected void login(String agentName, String agentPass, String resource) throws InvalidDataException {
        for (int i = 1; i < 6; ++i) {
            try {
                log.info("Login attempt " + i + " of 5");
                this.agent = Gateway.connect(agentName, agentPass, resource);
                break;
            }
            catch (Exception ex) {
                log.error("Could not log in.", (Throwable)ex);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        if (this.agent == null) {
            throw new InvalidDataException("Could not login agent:" + agentName);
        }
    }

    protected static StateMachine getRequiredStateMachine(String propPrefix, String namesSpaceDefault, String bootfileDefault) throws InvalidDataException {
        if (StringUtils.isBlank((CharSequence)propPrefix)) {
            throw new InvalidDataException("propertyPrefix must contain a value");
        }
        String smName = SystemProperties.$UserCodeRole_StateMachine_name.getString(null, propPrefix);
        Integer smVersion = SystemProperties.$UserCodeRole_StateMachine_version.getInteger(null, propPrefix);
        try {
            if (StringUtils.isNotBlank((CharSequence)smName) && smVersion != null) {
                return LocalObjectLoader.getStateMachine(smName, smVersion);
            }
            log.warn("getRequiredStateMachine() - SM Name and/or Version was not specified, trying to load from bootsrap resource.");
            String stateMachineNS = SystemProperties.$UserCodeRole_StateMachine_namespace.getString(namesSpaceDefault, propPrefix);
            String stateMachinePath = SystemProperties.$UserCodeRole_StateMachine_bootfile.getString(bootfileDefault, propPrefix);
            return (StateMachine)Gateway.getMarshaller().unmarshall(Gateway.getResource().getTextResource(stateMachineNS, stateMachinePath));
        }
        catch (Exception e) {
            log.error("getRequiredStateMachine()", (Throwable)e);
            throw new InvalidDataException(e);
        }
    }

    public static void standardInitialisation(Properties props, ResourceLoader res) throws Exception {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                AbstractMain.shutdown(0);
            }
        });
        Gateway.init(props, res);
        Gateway.connect();
        StandardClient.createClientVerticles();
    }

    public static void standardInitialisation(String[] args) throws Exception {
        StandardClient.standardInitialisation(StandardClient.readC2KArgs(args), null);
    }
}

