/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.process;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.ext.bridge.BridgeOptions;
import io.vertx.ext.bridge.PermittedOptions;
import io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge;
import org.cristalise.kernel.SystemProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpBridgeVerticle
extends AbstractVerticle {
    private static final Logger log = LoggerFactory.getLogger(TcpBridgeVerticle.class);
    private TcpEventBusBridge bridge;

    public void start(Promise<Void> startPromise) throws Exception {
        this.bridge = TcpEventBusBridge.create((Vertx)this.vertx, (BridgeOptions)new BridgeOptions().addInboundPermitted(new PermittedOptions().setAddressRegex(".*")).addOutboundPermitted(new PermittedOptions().setAddressRegex(".*t")));
        int port = SystemProperties.TcpBridge_port.getInteger();
        this.bridge.listen(port, res -> {
            if (res.succeeded()) {
                log.info("start() - listen to port:{}", (Object)port);
                startPromise.complete();
            } else {
                log.error("start() - CANNOT listen to port:{}", (Object)port, (Object)res.cause());
                startPromise.fail(res.cause());
            }
        });
    }

    public void stop() throws Exception {
        int port = SystemProperties.TcpBridge_port.getInteger();
        log.info("stop() - closing listening to port:{}", (Object)port);
        this.bridge.close();
    }
}

