/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.process;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.ThreadingModel;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import org.cristalise.kernel.SystemProperties;
import org.cristalise.kernel.entity.imports.ImportAgent;
import org.cristalise.kernel.entity.imports.ImportRole;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.StandardClient;
import org.cristalise.kernel.process.UserCodeVerticle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserCodeProcess
extends StandardClient {
    private static final Logger log = LoggerFactory.getLogger(UserCodeProcess.class);
    public static final String DEFAULT_PASSWORD = "uc";

    public static String getRoleName() {
        return SystemProperties.UserCode_roleOverride.getString();
    }

    public static List<String> getRolePermissions() {
        String permissionString = SystemProperties.$UserCodeRole_permissions.getString(UserCodeProcess.getRoleName());
        return Arrays.asList(permissionString.split(","));
    }

    public static ImportRole getImportRole() {
        RolePath rp = new RolePath(new RolePath(), UserCodeProcess.getRoleName(), true, UserCodeProcess.getRolePermissions());
        return ImportRole.getImportRole(rp);
    }

    public static String getAgentName() {
        try {
            return SystemProperties.$UserCodeRole_agent.getString(InetAddress.getLocalHost().getHostName(), UserCodeProcess.getRoleName());
        }
        catch (UnknownHostException e) {
            log.error("getAgentName() - roleName:{}", (Object)UserCodeProcess.getRoleName(), (Object)e);
            return null;
        }
    }

    public static String getAgentPassword() {
        return SystemProperties.$UserCodeRole_password.getString(DEFAULT_PASSWORD, UserCodeProcess.getRoleName());
    }

    public static ImportAgent getImportAgent() {
        ImportAgent iAgent = new ImportAgent(UserCodeProcess.getAgentName(), UserCodeProcess.getAgentPassword());
        iAgent.addRole(UserCodeProcess.getImportRole());
        return iAgent;
    }

    public static void main(String[] args) throws Exception {
        UserCodeProcess.standardInitialisation(args);
        DeploymentOptions options = new DeploymentOptions().setThreadingModel(ThreadingModel.VIRTUAL_THREAD).setInstances(4);
        Gateway.getVertx().deployVerticle(UserCodeVerticle.class, options);
    }
}

