/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.process;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Promise;
import io.vertx.core.eventbus.EventBus;
import org.cristalise.kernel.SystemProperties;
import org.cristalise.kernel.common.CriseVertxException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.InvalidTransitionException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.Job;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.lifecycle.instance.stateMachine.StateMachine;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.StandardClient;
import org.cristalise.kernel.process.UserCodeProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserCodeVerticle
extends AbstractVerticle {
    private static final Logger log = LoggerFactory.getLogger(UserCodeVerticle.class);
    private AgentProxy userCode;
    private final int START;
    private final int COMPLETE;
    private final int ERROR;
    public static final String USERCODE_IGNORE = "USERCODE_IGNORE";

    public UserCodeVerticle() throws InvalidDataException, ObjectNotFoundException {
        StateMachine sm = StandardClient.getRequiredStateMachine(UserCodeProcess.getRoleName(), null, "boot/SM/Default.xml");
        this.START = this.getValidTransitionID(sm, SystemProperties.$UserCodeRole_StateMachine_startTransition.getString(null, UserCodeProcess.getRoleName()));
        this.ERROR = this.getValidTransitionID(sm, SystemProperties.$UserCodeRole_StateMachine_errorTransition.getString(null, UserCodeProcess.getRoleName()));
        this.COMPLETE = this.getValidTransitionID(sm, SystemProperties.$UserCodeRole_StateMachine_completeTransition.getString(null, UserCodeProcess.getRoleName()));
    }

    private int getValidTransitionID(StateMachine sm, String propertyValue) throws InvalidDataException {
        if (USERCODE_IGNORE.equals(propertyValue)) {
            return -1;
        }
        return sm.getValidTransitionID(propertyValue);
    }

    public void start(Promise<Void> startPromise) throws Exception {
        this.userCode = Gateway.getSecurityManager().authenticate(UserCodeProcess.getAgentName(), UserCodeProcess.getAgentPassword(), null);
        EventBus eb = this.vertx.eventBus();
        eb.localConsumer(String.valueOf(this.userCode.getPath().getUUID()) + "/" + String.valueOf((Object)ClusterType.JOB), message -> {
            String[] tokens = ((String)message.body()).split(":");
            String jobId = tokens[0];
            if (tokens[1].equals("DELETE")) {
                return;
            }
            try {
                Job aJob = this.userCode.getJob(jobId);
                this.vertx.executeBlocking(result -> this.process(aJob));
            }
            catch (ObjectNotFoundException e) {
                log.error("handler()", (Throwable)e);
            }
        });
        startPromise.complete();
        log.info("start() - deployed '{}' consumer", (Object)"cristalise-proxyMessage");
    }

    protected void process(Job thisJob) {
        log.info("=======================================================================================");
        try {
            int transitionId = thisJob.getTransition().getId();
            if (transitionId == this.START) {
                this.start(thisJob);
            } else if (transitionId == this.COMPLETE) {
                this.complete(thisJob, null);
            } else if (transitionId == this.ERROR) {
                log.trace("process() - skipping ERROR job:{}", (Object)thisJob);
            } else {
                log.trace("process() - skipping job:{}", (Object)thisJob);
            }
        }
        catch (InvalidTransitionException ex) {
            log.debug("process() - job was already executed - {}", (Object)thisJob);
        }
        catch (Exception ex) {
            log.error("Error executing job:{}", (Object)thisJob, (Object)ex);
        }
    }

    public void start(Job thisJob) throws CriseVertxException {
        log.debug("start() - job:" + String.valueOf(thisJob));
        if (this.assessStartConditions(thisJob)) {
            log.trace("start() - Attempting to start");
            this.userCode.execute(thisJob);
        } else {
            log.debug("start() - Start conditions failed " + thisJob.getStepName() + " in " + String.valueOf(thisJob.getItemPath()));
        }
    }

    public void complete(Job thisJob, Job erroJob) throws Exception {
        log.debug("complete() - job:" + String.valueOf(thisJob));
        this.runUserCodeLogic(thisJob, erroJob);
    }

    public boolean assessStartConditions(Job job) {
        return true;
    }

    public void runUserCodeLogic(Job job, Job errorJob) throws CriseVertxException {
        if (errorJob == null) {
            this.userCode.execute(job);
        } else {
            this.userCode.execute(job, errorJob);
        }
    }
}

