/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.process.module;

import java.util.ArrayList;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.imports.ImportAgent;
import org.cristalise.kernel.entity.imports.ImportItem;
import org.cristalise.kernel.entity.imports.ImportRole;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.AbstractMain;
import org.cristalise.kernel.process.module.ModuleAgent;
import org.cristalise.kernel.process.module.ModuleImport;
import org.cristalise.kernel.process.module.ModuleItem;
import org.cristalise.kernel.process.module.ModuleResource;
import org.cristalise.kernel.process.module.ModuleRole;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.utils.CastorArrayList;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleImports
extends CastorArrayList<ModuleImport> {
    private static final Logger log = LoggerFactory.getLogger(ModuleImports.class);

    public ModuleImports() {
    }

    public ModuleImports(ArrayList<ModuleImport> aList) {
        super(aList);
    }

    public ArrayList<ModuleResource> getResources() {
        ArrayList<ModuleResource> subset = new ArrayList<ModuleResource>();
        for (ModuleImport imp : this.list) {
            if (!(imp instanceof ModuleResource)) continue;
            subset.add((ModuleResource)imp);
        }
        return subset;
    }

    public ArrayList<ImportItem> getItems(TransactionKey transactionKey) {
        ArrayList<ImportItem> subset = new ArrayList<ImportItem>();
        for (ModuleImport moduleImport : this.list) {
            if (moduleImport instanceof ImportItem) {
                subset.add((ImportItem)moduleImport);
                continue;
            }
            if (!(moduleImport instanceof ModuleItem)) continue;
            ModuleItem moduleItem = (ModuleItem)moduleImport;
            try {
                ImportItem importItem = LocalObjectLoader.getItemDesc(moduleImport.getName(), moduleItem.getVersion(), transactionKey);
                importItem.setItemPath(null);
                importItem.setResourceChangeStatus(moduleItem.getResourceChangeStatus());
                subset.add(importItem);
            }
            catch (InvalidDataException | ObjectNotFoundException e) {
                log.error("Could not load itemDesc:{} version:{}", new Object[]{moduleImport.getName(), moduleItem.getVersion(), e});
                AbstractMain.shutdown(1);
            }
        }
        return subset;
    }

    public ArrayList<ImportAgent> getAgents(TransactionKey transactionKey) {
        ArrayList<ImportAgent> subset = new ArrayList<ImportAgent>();
        for (ModuleImport imp : this.list) {
            if (imp instanceof ImportAgent) {
                subset.add((ImportAgent)imp);
                continue;
            }
            if (!(imp instanceof ModuleAgent)) continue;
            int version = ((ModuleAgent)imp).getVersion();
            try {
                ImportAgent importAgent = LocalObjectLoader.getAgentDesc(imp.getName(), version, transactionKey);
                importAgent.setItemPath(null);
                importAgent.setResourceChangeStatus(imp.getResourceChangeStatus());
                subset.add(importAgent);
            }
            catch (InvalidDataException | ObjectNotFoundException e) {
                log.error("Could not load agentDesc:{} version:{}", new Object[]{imp.getName(), version, e});
                AbstractMain.shutdown(1);
            }
        }
        return subset;
    }

    public ArrayList<ImportRole> getRoles(TransactionKey transactionKey) {
        ArrayList<ImportRole> subset = new ArrayList<ImportRole>();
        for (ModuleImport imp : this.list) {
            if (imp instanceof ImportRole) {
                subset.add((ImportRole)imp);
                continue;
            }
            if (!(imp instanceof ModuleRole)) continue;
            int version = ((ModuleRole)imp).getVersion();
            try {
                ImportRole importRole = LocalObjectLoader.getRoleDesc(imp.getName(), version, transactionKey);
                importRole.setItemPath(null);
                importRole.setResourceChangeStatus(imp.getResourceChangeStatus());
                subset.add(importRole);
            }
            catch (InvalidDataException | ObjectNotFoundException e) {
                log.error("Could not load roleDesc:{} version:{}", new Object[]{imp.getName(), version, e});
                AbstractMain.shutdown(1);
            }
        }
        return subset;
    }

    public ModuleImport findImport(String name, String typeCode) {
        BuiltInResources type = BuiltInResources.getValue(typeCode);
        for (ModuleImport thisImport : this.list) {
            BuiltInResources thisType = null;
            if (thisImport instanceof ModuleResource) {
                thisType = ((ModuleResource)thisImport).type;
            } else if (thisImport instanceof ImportAgent) {
                thisType = BuiltInResources.AGENT_DESC_RESOURCE;
            } else if (thisImport instanceof ImportItem) {
                thisType = BuiltInResources.ITEM_DESC_RESOURCE;
            } else if (thisImport instanceof ImportRole) {
                thisType = BuiltInResources.ROLE_DESC_RESOURCE;
            } else {
                log.warn("findImport() -  No typeCode is available for ModuleImport:{}", (Object)thisImport.getName());
            }
            if (thisType == null || !thisImport.getName().equals(name) || !(type == BuiltInResources.ACTIVITY_DESC_RESOURCE ? thisType == BuiltInResources.ELEM_ACT_DESC_RESOURCE || thisType == BuiltInResources.COMP_ACT_DESC_RESOURCE : type == thisType)) continue;
            return thisImport;
        }
        return null;
    }
}

