/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.process.module;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.SystemProperties;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.module.ModuleImport;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.process.resource.ResourceImportHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleResource
extends ModuleImport {
    private static final Logger log = LoggerFactory.getLogger(ModuleResource.class);
    public Integer version = 0;
    public BuiltInResources type;
    public String resourceLocation;

    public String getResourceType() {
        return this.type.getTypeCode();
    }

    public void setResourceType(String typeCode) {
        this.type = BuiltInResources.getValue(typeCode);
    }

    public String getResourceDir() {
        return "boot/" + this.type.getTypeCode();
    }

    public String getResourceExt() {
        return this.type == BuiltInResources.SCHEMA_RESOURCE ? "xsd" : "xml";
    }

    public String getResourceFileName() {
        if (StringUtils.isBlank((CharSequence)this.resourceLocation) && this.ns != null) {
            Object[] vals = SystemProperties.Resource_moduleUseFileNameWithVersion.getString().split(",");
            log.debug("getResourceFileName(ns:{}) - moduleUseFileNameWithVersion:{}", (Object)this.ns, (Object)Arrays.toString(vals));
            if (Arrays.asList(vals).contains(this.ns)) {
                this.resourceLocation = this.getResourceDir() + "/" + this.name + "_" + this.version + "." + this.getResourceExt();
                log.debug("getResourceFileName(WithVersion) - {}", (Object)this.resourceLocation);
            } else {
                this.resourceLocation = this.getResourceDir() + "/" + this.name + "." + this.getResourceExt();
                log.debug("getResourceFileName(NoVersion) - {}", (Object)this.resourceLocation);
            }
        }
        return this.resourceLocation;
    }

    @Override
    public Path create(AgentPath agentPath, boolean reset, TransactionKey transactionKey) throws ObjectNotFoundException, ObjectCannotBeUpdated, CannotManageException, ObjectAlreadyExistsException, InvalidDataException {
        try {
            ResourceImportHandler importHandler = Gateway.getResourceImportHandler(this.type);
            this.domainPath = importHandler.importResource(this.ns, this.name, (int)this.version, this.itemPath, this.getResourceFileName(), reset, transactionKey);
            this.resourceChangeStatus = importHandler.getResourceChangeStatus();
            this.resourceChangeDetails = importHandler.getResourceChangeDetails();
            if (this.itemPath == null) {
                this.itemPath = this.domainPath.getItemPath(transactionKey);
            }
            return this.domainPath;
        }
        catch (Exception e) {
            log.error("Exception verifying module resource {}/{}", new Object[]{this.ns, this.name, e});
            throw new CannotManageException("Exception verifying module resource " + this.ns + "/" + this.name);
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.type.getTypeCode().hashCode() + this.version;
    }

    public Integer getVersion() {
        return this.version;
    }

    public BuiltInResources getType() {
        return this.type;
    }

    public String getResourceLocation() {
        return this.resourceLocation;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public void setType(BuiltInResources type) {
        this.type = type;
    }

    public void setResourceLocation(String resourceLocation) {
        this.resourceLocation = resourceLocation;
    }
}

