/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.process.resource;

import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.DomainContext;
import org.cristalise.kernel.entity.imports.ImportAgent;
import org.cristalise.kernel.entity.imports.ImportItem;
import org.cristalise.kernel.entity.imports.ImportRole;
import org.cristalise.kernel.lifecycle.ActivityDef;
import org.cristalise.kernel.lifecycle.CompositeActivityDef;
import org.cristalise.kernel.lifecycle.instance.stateMachine.StateMachine;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.process.module.Module;
import org.cristalise.kernel.property.PropertyDescriptionList;
import org.cristalise.kernel.querying.Query;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.utils.DescriptionObject;
import org.cristalise.kernel.utils.LocalObjectLoader;

public enum BuiltInResources {
    ACTIVITY_DESC_RESOURCE("AC", "ActivityDef", "/desc/ActivityDesc", null),
    PROPERTY_DESC_RESOURCE("property", "PropertyDescription", "/desc/PropertyDesc", "ManagePropertyDesc"),
    MODULE_RESOURCE("module", "Module", "/desc/Module", "ManageModule"),
    SCHEMA_RESOURCE("OD", "Schema", "/desc/Schema", "ManageSchema"),
    SCRIPT_RESOURCE("SC", "Script", "/desc/Script", "ManageScript"),
    QUERY_RESOURCE("query", "Query", "/desc/Query", "ManageQuery"),
    STATE_MACHINE_RESOURCE("SM", "StateMachine", "/desc/StateMachine", "ManageStateMachine"),
    COMP_ACT_DESC_RESOURCE("CA", "CompositeActivityDef", "/desc/ActivityDesc", "ManageCompositeActDef"),
    ELEM_ACT_DESC_RESOURCE("EA", "ElementaryActivityDef", "/desc/ActivityDesc", "ManageElementaryActDef"),
    ITEM_DESC_RESOURCE("item", "ItemDesc", "/desc/ItemDesc", "ManageItemDesc"),
    AGENT_DESC_RESOURCE("agent", "AgentDesc", "/desc/AgentDesc", "ManageAgentDesc"),
    ROLE_DESC_RESOURCE("role", "RoleDesc", "/desc/RoleDesc", "ManageRoleDesc"),
    DOMAIN_CONTEXT_RESOURCE("context", "DomainContext", "/desc/DomainContext", "ManageDomainContext");

    private String typeCode;
    private String schemaName;
    private String typeRoot;
    private String workflowDef;

    private BuiltInResources(String code, String schema, String root, String wf) {
        this.typeCode = code;
        this.schemaName = schema;
        this.typeRoot = root;
        this.workflowDef = wf;
    }

    public String toString() {
        return this.getTypeCode();
    }

    public static BuiltInResources getValue(String value) {
        for (BuiltInResources res : BuiltInResources.values()) {
            if (!res.getTypeCode().equals(value) && !res.getSchemaName().equals(value) && !res.name().equals(value)) continue;
            return res;
        }
        return null;
    }

    public static BuiltInResources getValue(DescriptionObject descObject) {
        switch (descObject.getClass().getSimpleName()) {
            case "PropertyDescriptionList": {
                return PROPERTY_DESC_RESOURCE;
            }
            case "Module": {
                return MODULE_RESOURCE;
            }
            case "Schema": {
                return SCHEMA_RESOURCE;
            }
            case "Script": {
                return SCRIPT_RESOURCE;
            }
            case "Query": {
                return QUERY_RESOURCE;
            }
            case "StateMachine": {
                return STATE_MACHINE_RESOURCE;
            }
            case "CompositeActivityDef": {
                return COMP_ACT_DESC_RESOURCE;
            }
            case "ActivityDef": {
                return ELEM_ACT_DESC_RESOURCE;
            }
            case "ImportItem": {
                return ITEM_DESC_RESOURCE;
            }
            case "ImportAgent": {
                return AGENT_DESC_RESOURCE;
            }
            case "ImportRole": {
                return ROLE_DESC_RESOURCE;
            }
            case "DomainContext": {
                return DOMAIN_CONTEXT_RESOURCE;
            }
        }
        return null;
    }

    public DescriptionObject loadDescriptionObject(String name, Integer version) throws ObjectNotFoundException, InvalidDataException {
        switch (this.ordinal()) {
            case 0: {
                return null;
            }
            case 2: {
                return new Module();
            }
            case 3: {
                return LocalObjectLoader.getSchema(name, version);
            }
            case 4: {
                return LocalObjectLoader.getScript(name, version);
            }
            case 5: {
                return LocalObjectLoader.getQuery(name, version);
            }
            case 1: {
                return LocalObjectLoader.getPropertyDescriptionList(name, version);
            }
            case 7: {
                return LocalObjectLoader.getCompActDef(name, version);
            }
            case 8: {
                return LocalObjectLoader.getElemActDef(name, version);
            }
            case 6: {
                return LocalObjectLoader.getStateMachine(name, version);
            }
            case 9: {
                return LocalObjectLoader.getItemDesc(name, version);
            }
            case 10: {
                return LocalObjectLoader.getAgentDesc(name, version);
            }
            case 11: {
                return LocalObjectLoader.getRoleDesc(name, version);
            }
            case 12: {
                return LocalObjectLoader.getDomainContext(name, version);
            }
        }
        return null;
    }

    public DescriptionObject initDescriptionObject(String name) {
        DescriptionObject descObj;
        switch (this.ordinal()) {
            case 0: {
                descObj = null;
                break;
            }
            case 2: {
                descObj = new Module();
                break;
            }
            case 3: {
                descObj = new Schema(null);
                break;
            }
            case 4: {
                descObj = new Script();
                break;
            }
            case 5: {
                descObj = new Query();
                break;
            }
            case 1: {
                descObj = new PropertyDescriptionList();
                break;
            }
            case 7: {
                descObj = new CompositeActivityDef();
                break;
            }
            case 8: {
                descObj = new ActivityDef();
                break;
            }
            case 6: {
                descObj = new StateMachine();
                break;
            }
            case 9: {
                descObj = new ImportItem();
                break;
            }
            case 10: {
                descObj = new ImportAgent();
                break;
            }
            case 11: {
                descObj = new ImportRole();
                break;
            }
            case 12: {
                descObj = new DomainContext();
                break;
            }
            default: {
                return null;
            }
        }
        if (descObj != null) {
            descObj.setName(name);
        }
        return descObj;
    }

    private String getActivityTypeText() {
        switch (this.ordinal()) {
            case 7: 
            case 8: {
                return "Activity";
            }
        }
        return this.getSchemaName();
    }

    public String getEditActivityName() {
        return "EditDefinition";
    }

    public String getMoveVersionActivityName() {
        return "MoveLatest" + this.getActivityTypeText() + "VersionToLast";
    }

    public String getAssignVersionActivityName() {
        return "AssignNew" + this.getActivityTypeText() + "VersionFromLast";
    }

    public String getFactoryPath() {
        return this.typeRoot + "/" + this.schemaName + "Factory";
    }

    public String getTypeCode() {
        return this.typeCode;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTypeRoot() {
        return this.typeRoot;
    }

    public String getWorkflowDef() {
        return this.workflowDef;
    }
}

