/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.process.resource;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.process.resource.ResourceLoader;
import org.cristalise.kernel.utils.FileStringUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resource
implements ResourceLoader {
    private static final Logger log = LoggerFactory.getLogger(Resource.class);
    private final Hashtable<String, String> txtCache = new Hashtable();
    private final URL baseURL;
    private final HashMap<String, URL> moduleBaseURLs = new HashMap();
    private final HashMap<String, URL> allBaseURLs = new HashMap();

    public Resource() throws InvalidDataException {
        this.baseURL = Resource.getURLorResURL("org/cristalise/kernel/utils/resources/");
        this.allBaseURLs.put(null, this.baseURL);
    }

    @Override
    public URL getKernelBaseURL() {
        return this.baseURL;
    }

    @Override
    public ClassLoader getClassLoader(String className) {
        return Resource.class.getClassLoader();
    }

    @Override
    public Class<?> getClassForName(String name) throws ClassNotFoundException {
        return Class.forName(name);
    }

    @Override
    public URL getKernelResourceURL(String resName) throws MalformedURLException {
        return new URL(this.baseURL, resName);
    }

    @Override
    public void addModuleBaseURL(String ns, URL newBaseURL) {
        this.moduleBaseURLs.put(ns, newBaseURL);
        this.allBaseURLs.put(ns, newBaseURL);
        log.info("Adding resource URL for {}: {}", (Object)ns, (Object)newBaseURL);
    }

    @Override
    public void addModuleBaseURL(String ns, String newBaseURL) throws InvalidDataException {
        this.addModuleBaseURL(ns, Resource.getURLorResURL(newBaseURL));
    }

    @Override
    public HashMap<String, URL> getModuleBaseURLs() {
        return this.moduleBaseURLs;
    }

    private HashMap<String, URL> getAllBaseURLs() {
        return this.allBaseURLs;
    }

    @Override
    public URL getModuleResourceURL(String ns, String resName) throws MalformedURLException {
        if (!this.moduleBaseURLs.containsKey(ns)) {
            throw new MalformedURLException("Could not locate resource. Namespace '" + ns + "' not registered.");
        }
        return new URL(this.moduleBaseURLs.get(ns), resName);
    }

    private static URL getURLorResURL(String newURL) throws InvalidDataException {
        URL result;
        try {
            result = new URL(newURL);
        }
        catch (MalformedURLException ex) {
            result = Resource.class.getClassLoader().getResource(newURL);
        }
        if (result == null) {
            log.error("URL " + newURL + " could not be found");
            throw new InvalidDataException();
        }
        return result;
    }

    @Override
    public String findTextResource(String resName) {
        for (String ns : this.getAllBaseURLs().keySet()) {
            try {
                return this.getTextResource(ns, resName);
            }
            catch (ObjectNotFoundException objectNotFoundException) {
            }
        }
        log.warn("Text resource '" + resName + "' not found.");
        return null;
    }

    @Override
    public HashMap<String, String> getAllTextResources(String resName) {
        HashMap<String, String> results = new HashMap<String, String>();
        for (String ns : this.getAllBaseURLs().keySet()) {
            try {
                results.put(ns, this.getTextResource(ns, resName));
            }
            catch (ObjectNotFoundException objectNotFoundException) {}
        }
        return results;
    }

    @Override
    public String getTextResource(String ns, String resName) throws ObjectNotFoundException {
        log.trace("getTextResource() - Getting resource from namespacce " + ns + ": " + resName);
        if (this.txtCache.containsKey(ns + "/" + resName)) {
            return this.txtCache.get(ns + "/" + resName);
        }
        try {
            String newRes = null;
            URL loc = ns == null ? this.getKernelResourceURL(resName) : this.getModuleResourceURL(ns, resName);
            log.debug("Loading resource: {}", (Object)loc);
            newRes = FileStringUtility.url2String(loc);
            this.txtCache.put(ns + "/" + resName, newRes);
            return newRes;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new ObjectNotFoundException(e.getMessage());
        }
    }

    @Override
    public Enumeration<URL> getModuleDefURLs() throws Exception {
        return this.getClassLoader("").getResources("META-INF/cristal/module.xml");
    }
}

