/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.scripting;

import java.util.ArrayList;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.cristalise.kernel.entity.Job;

public class ErrorInfo {
    boolean fatal = false;
    Job failedJob;
    ArrayList<String> errors = new ArrayList();

    public ErrorInfo() {
    }

    public ErrorInfo(String error) {
        this();
        this.errors.add(error);
    }

    public ErrorInfo(Throwable ex) {
        this();
        this.setFatal();
        for (String frame : ExceptionUtils.getStackFrames((Throwable)ex)) {
            this.addError(frame.trim());
        }
    }

    public ErrorInfo(Job job, Throwable ex) {
        this(ex);
        this.failedJob = job;
    }

    public void addError(String error) {
        this.errors.add(error);
    }

    public String toString() {
        StringBuffer err = new StringBuffer();
        for (String element : this.errors) {
            err.append(element + "\n");
        }
        return err.toString();
    }

    public void setErrors(ArrayList<String> msg) {
        this.errors = msg;
    }

    public ArrayList<String> getErrors() {
        return this.errors;
    }

    public void setFatal(boolean flag) {
        this.fatal = flag;
    }

    public void setFatal() {
        this.fatal = true;
    }

    public boolean getFatal() {
        return this.fatal;
    }

    public Job getFailedJob() {
        return this.failedJob;
    }

    public void setFailedJob(Job failedJob) {
        this.failedJob = failedJob;
    }
}

