/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.scripting;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.SystemProperties;
import org.cristalise.kernel.collection.BuiltInCollections;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.Job;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.scripting.ErrorInfo;
import org.cristalise.kernel.scripting.Include;
import org.cristalise.kernel.scripting.Parameter;
import org.cristalise.kernel.scripting.ParameterException;
import org.cristalise.kernel.scripting.ScriptParsingException;
import org.cristalise.kernel.scripting.ScriptingEngineException;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.DescriptionObject;
import org.cristalise.kernel.utils.FileStringUtility;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class Script
implements DescriptionObject {
    private static final Logger log = LoggerFactory.getLogger(Script.class);
    static final String scriptTemplate = "/org/cristalise/kernel/utils/resources/templates/Script_xml.tmpl";
    private static CompiledTemplate compiledScriptTemplate = null;
    public static final String PARAMETER_AGENT = "agent";
    public static final String PARAMETER_DB = "db";
    public static final String PARAMETER_ITEM = "item";
    public static final String PARAMETER_JOB = "job";
    public static final String PARAMETER_LOCKER = "transactionKey";
    public static final String PARAMETER_LOOKUP = "lookup";
    public static final String PARAMETER_OUTPUT = "output";
    public static final String PARAMETER_VERTX = "vertx";
    public static final String PARAMETER_STORAGE = "storage";
    public static final String SYSTEM_USER = "system";
    String mScript = "";
    CompiledScript mCompScript = null;
    String mScriptXML = "";
    String mNamespace;
    String mName;
    Integer mVersion;
    ItemPath mItemPath;
    String mLanguage;
    Map<String, Parameter> mInputParams = new HashMap<String, Parameter>();
    Map<String, Parameter> mOutputParams = new HashMap<String, Parameter>();
    Map<String, Parameter> mAllInputParams = new HashMap<String, Parameter>();
    ArrayList<Script> mIncludes = new ArrayList();
    ScriptEngine engine;
    ScriptContext context;
    boolean isActExecEnvironment = false;
    boolean lateBindIncluded = false;

    public Script() {
    }

    public Script(String name, Integer version, ItemPath path, String xml) throws ScriptParsingException, ParameterException {
        this(name, version, path, xml, false);
    }

    public Script(String name, Integer version, ItemPath path, String xml, boolean lateBind) throws ScriptParsingException, ParameterException {
        this.mName = name;
        this.mVersion = version;
        this.mItemPath = path;
        this.mScriptXML = xml;
        this.lateBindIncluded = lateBind;
        this.parseScriptXML(xml);
    }

    public Script(String lang, String expr, Class<?> returnType) throws ScriptingEngineException {
        this(lang, "<expr>", expr, null, Object.class);
    }

    public Script(String lang, String name, String expr, AgentProxy agent) throws ScriptingEngineException {
        this(lang, name, expr, agent, Object.class);
    }

    public Script(String lang, String name, String expr, AgentProxy agent, Class<?> returnType) throws ScriptingEngineException {
        this.mName = name;
        this.mVersion = null;
        this.setScriptEngine(lang);
        this.mName = name;
        if (agent != null) {
            this.addInputParam(PARAMETER_AGENT, AgentProxy.class);
            this.setInputParamValue(PARAMETER_AGENT, agent, true);
        }
        this.addOutput(null, returnType);
        this.setScriptData(expr);
    }

    public Script(String lang, String expr) throws ScriptingEngineException {
        this(lang, "<expr>", expr, null, Object.class);
    }

    public Script(String lang, AgentProxy agent, PrintStream out) throws Exception {
        this.setScriptEngine(lang);
        Bindings beans = this.context.getBindings(100);
        beans.put(PARAMETER_STORAGE, (Object)Gateway.getStorage());
        beans.put(PARAMETER_DB, (Object)Gateway.getStorage());
        beans.put(PARAMETER_LOOKUP, (Object)Gateway.getLookup());
        beans.put(PARAMETER_VERTX, (Object)Gateway.getVertx());
        beans.put(PARAMETER_AGENT, (Object)agent);
        beans.put(PARAMETER_OUTPUT, (Object)out);
        PrintWriter output = new PrintWriter(out);
        this.context.setWriter(output);
        this.context.setErrorWriter(output);
        String scriptText = Gateway.getResource().getTextResource(null, "textFiles/consoleScript." + lang + ".txt");
        try {
            log.trace("Loaded consoleScript: {}", (Object)scriptText);
            this.engine.put("javax.script.filename", "consoleScript." + lang + ".txt");
            this.engine.eval(scriptText);
        }
        catch (ScriptException ex) {
            out.println("Exception parsing console script for " + (String)(this.mNamespace == null ? "kernel" : this.mNamespace + " module"));
            ex.printStackTrace(out);
        }
        this.addOutput(null, Object.class);
    }

    private void setActExecEnvironment(ItemProxy item, AgentProxy agent, Job job) throws ScriptingEngineException, InvalidDataException {
        this.isActExecEnvironment = true;
        if (!this.mInputParams.containsKey(PARAMETER_ITEM)) {
            log.debug("Parameter:{} was not declared in Script:{}", (Object)PARAMETER_ITEM, (Object)this);
            this.addInputParam(PARAMETER_ITEM, ItemProxy.class);
        }
        this.setInputParamValue(PARAMETER_ITEM, item, true);
        if (!this.mInputParams.containsKey(PARAMETER_AGENT)) {
            log.debug("Parameter:{} was not declared in Script:{}", (Object)PARAMETER_AGENT, (Object)this);
            this.addInputParam(PARAMETER_AGENT, AgentProxy.class);
        }
        this.setInputParamValue(PARAMETER_AGENT, agent, true);
        if (!this.mInputParams.containsKey(PARAMETER_JOB)) {
            log.debug("Parameter:{} was not declared in Script:{}", (Object)PARAMETER_JOB, (Object)this);
            this.addInputParam(PARAMETER_JOB, Job.class);
        }
        this.setInputParamValue(PARAMETER_JOB, job, true);
        if (!this.mOutputParams.containsKey("errors")) {
            log.debug("Output:errors was not declared in Script:{}", (Object)this);
            this.addOutput("errors", ErrorInfo.class);
        }
    }

    public void setScriptEngine(String requestedLang) throws ScriptingEngineException {
        ScriptEngineManager sem = new ScriptEngineManager(this.getClass().getClassLoader());
        String lang = SystemProperties.Script_EngineOverride_$lang.getString(requestedLang, requestedLang);
        this.engine = sem.getEngineByName(lang);
        if (this.engine == null) {
            throw new ScriptingEngineException("No script engine for '" + lang + "' found.");
        }
        this.mLanguage = requestedLang;
        this.createEmptyContext();
    }

    private void createEmptyContext() {
        this.context = new SimpleScriptContext();
        this.context.setBindings(this.engine.createBindings(), 100);
        this.engine.setContext(this.context);
    }

    public void setContext(ScriptContext context) {
        this.context = context;
        if (this.engine != null) {
            this.engine.setContext(context);
        }
    }

    public ScriptContext getContext() {
        return this.context;
    }

    private synchronized void parseScriptXML(String scriptXML) throws ScriptParsingException, ParameterException {
        if (StringUtils.isBlank((CharSequence)scriptXML)) {
            log.warn("parseScriptXML - scriptXML was NULL!");
            return;
        }
        Document scriptDoc = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder domBuilder = factory.newDocumentBuilder();
            scriptDoc = domBuilder.parse(new InputSource(new StringReader(scriptXML)));
        }
        catch (Exception ex) {
            throw new ScriptParsingException("Error parsing XML for Script:" + String.valueOf(this), ex);
        }
        this.parseScriptTag(scriptDoc.getElementsByTagName("script"));
        this.parseIncludeTag(scriptDoc.getElementsByTagName("include"));
        this.parseParamTag(scriptDoc.getElementsByTagName("param"));
        this.parseOutputTag(scriptDoc.getElementsByTagName(PARAMETER_OUTPUT));
    }

    private void parseOutputTag(NodeList outputList) throws ScriptParsingException, ParameterException {
        for (int i = 0; i < outputList.getLength(); ++i) {
            Element output = (Element)outputList.item(i);
            if (!output.hasAttribute("type")) {
                throw new ScriptParsingException("Script:" + String.valueOf(this) + " Output declaration incomplete, must have type");
            }
            this.addOutput(output.getAttribute("name"), output.getAttribute("type"));
        }
    }

    private void parseParamTag(NodeList paramList) throws ScriptParsingException, ParameterException {
        for (int i = 0; i < paramList.getLength(); ++i) {
            Element param = (Element)paramList.item(i);
            if (!param.hasAttribute("name") || !param.hasAttribute("type")) {
                throw new ScriptParsingException("Script:" + String.valueOf(this) + " Input Param incomplete, must have name and type");
            }
            this.addInputParam(param.getAttribute("name"), param.getAttribute("type"));
        }
    }

    private void parseIncludeTag(NodeList includeList) throws ScriptParsingException {
        for (int i = 0; i < includeList.getLength(); ++i) {
            Element include = (Element)includeList.item(i);
            if (!include.hasAttribute("name") || !include.hasAttribute("version")) {
                throw new ScriptParsingException("Script:" + String.valueOf(this) + " include declaration incomplete, must have name and version");
            }
            String includeName = include.getAttribute("name");
            String includeVersion = include.getAttribute("version");
            try {
                Script includedScript = null;
                Integer includedVer = Integer.parseInt(includeVersion);
                includedScript = this.lateBindIncluded ? new Script(includeName, includedVer, null, null) : LocalObjectLoader.getScript(includeName, includedVer);
                includedScript.setContext(this.context);
                this.mIncludes.add(includedScript);
                for (Parameter includeParam : includedScript.getInputParams().values()) {
                    this.addIncludedInputParam(includeParam.getName(), includeParam.getType());
                }
                continue;
            }
            catch (NumberFormatException | InvalidDataException | ObjectNotFoundException | ScriptingEngineException e) {
                log.error("Included script '" + includeName + " v" + includeVersion + "' parse error", (Throwable)e);
                throw new ScriptParsingException("Included script '" + includeName + " v" + includeVersion + "' parse error", e);
            }
        }
    }

    private void parseScriptTag(NodeList scriptList) throws ScriptParsingException {
        Element scriptElem = (Element)scriptList.item(0);
        if (!scriptElem.hasAttribute("language")) {
            throw new ScriptParsingException("Script:" + String.valueOf(this) + " data incomplete, must specify scripting language");
        }
        log.debug("parseScriptTag() - Script Language: " + scriptElem.getAttribute("language"));
        try {
            this.setScriptEngine(scriptElem.getAttribute("language"));
        }
        catch (ScriptingEngineException ex) {
            throw new ScriptParsingException(ex);
        }
        NodeList scriptChildNodes = scriptElem.getChildNodes();
        int cdataIdx = -1;
        for (int i = 0; i < scriptChildNodes.getLength(); ++i) {
            if (scriptChildNodes.item(i) instanceof CDATASection) {
                cdataIdx = i;
                continue;
            }
            if (scriptChildNodes.item(i) instanceof Text) {
                if (!StringUtils.isNotBlank((CharSequence)((Text)scriptChildNodes.item(i)).getData())) continue;
                throw new ScriptParsingException("Script must be wrapped in CDATA - name:" + String.valueOf(this) + " element:" + String.valueOf(scriptChildNodes.item(i)));
            }
            throw new ScriptParsingException("Child element of script tag was not text - name:" + String.valueOf(this) + " element:" + String.valueOf(scriptChildNodes.item(i)));
        }
        this.setScriptData(((Text)scriptChildNodes.item(cdataIdx)).getData());
        log.trace("parseScriptTag() - script:" + this.mScript);
    }

    public void addInputParam(String name, String type) throws ParameterException {
        try {
            this.addInputParam(name, Gateway.getResource().getClassForName(type));
        }
        catch (ClassNotFoundException ex) {
            throw new ParameterException("Script:" + String.valueOf(this) + " Input parameter " + name + " specifies class " + type + " which was not found.", ex);
        }
    }

    public void addInputParam(String name, Class<?> type) throws ParameterException {
        Parameter inputParam = new Parameter(name, type);
        log.debug("addInputParam() - declared parameter " + name + " (" + String.valueOf(type) + ")");
        this.mInputParams.put(inputParam.getName(), inputParam);
        this.mAllInputParams.put(inputParam.getName(), inputParam);
    }

    protected void addIncludedInputParam(String name, Class<?> type) throws ParameterException {
        if (this.mAllInputParams.containsKey(name)) {
            Parameter existingParam = this.mAllInputParams.get(name);
            if (existingParam.getType() == type) {
                return;
            }
            throw new ParameterException("Script:" + String.valueOf(this) + " Parameter conflict. Parameter:'" + name + "' is declared as  " + String.valueOf(existingParam.getType()) + " is declared in another script as " + String.valueOf(type));
        }
        Parameter inputParam = new Parameter(name);
        inputParam.setType(type);
        this.mAllInputParams.put(inputParam.getName(), inputParam);
    }

    public void addOutput(String name, String type) throws ParameterException {
        try {
            this.addOutput(name, Gateway.getResource().getClassForName(type));
        }
        catch (ClassNotFoundException ex) {
            throw new ParameterException("Script:" + String.valueOf(this) + " Output parameter " + name + " specifies class " + type + " which was not found.", ex);
        }
    }

    public void addOutput(String name, Class<?> type) throws ParameterException {
        if (this.mOutputParams.containsKey(name)) {
            throw new ParameterException("Script:" + String.valueOf(this) + " Output parameter '" + name + "' declared more than once.");
        }
        this.mOutputParams.put(name, new Parameter(name, type));
    }

    public boolean setInputParamValue(String name, Object value) throws ParameterException {
        return this.setInputParamValue(name, value, true);
    }

    public boolean setInputParamValue(String name, Object value, boolean overwrite) throws ParameterException {
        Parameter param = this.mInputParams.get(name);
        boolean wasUsed = false;
        if (!this.mAllInputParams.containsKey(name)) {
            return false;
        }
        if (param != null) {
            if (value != null && !param.getType().isInstance(value)) {
                throw new ParameterException("Parameter " + name + " in script " + this.mName + " v" + this.mVersion + " is wrong type \nRequired: " + String.valueOf(param.getType()) + "\nSupplied: " + String.valueOf(value.getClass()));
            }
            Bindings bindings = this.context.getBindings(100);
            if (!bindings.containsKey(name) || bindings.get(name) == null || overwrite && value != null) {
                bindings.put(name, value);
                log.debug("setInputParamValue() - " + name + ": " + String.valueOf(value));
                param.setInitialised(true);
                wasUsed = true;
            }
        }
        for (Script importScript : this.mIncludes) {
            wasUsed |= importScript.setInputParamValue(name, value, overwrite);
        }
        return wasUsed;
    }

    public Object evaluate(CastorHashMap inputProps) throws ScriptingEngineException {
        return this.evaluate(null, inputProps, null, false, null);
    }

    public Object evaluate(ItemPath itemPath, CastorHashMap inputProps, String actContext, TransactionKey transactionKey) throws ScriptingEngineException {
        return this.evaluate(itemPath, inputProps, actContext, false, transactionKey);
    }

    public synchronized Object evaluate(ItemPath itemPath, CastorHashMap inputProps, String actContext, boolean actExecEnv, TransactionKey transactionKey) throws ScriptingEngineException {
        try {
            Object retVal;
            ItemProxy item = itemPath == null ? null : Gateway.getProxy(itemPath, transactionKey);
            this.createEmptyContext();
            if (actExecEnv) {
                this.setActExecEnvironment(item, (AgentProxy)inputProps.get(PARAMETER_AGENT), (Job)inputProps.get(PARAMETER_JOB));
            }
            for (String inputParamName : this.getAllInputParams().keySet()) {
                if (!inputProps.containsKey(inputParamName)) continue;
                this.setInputParamValue(inputParamName, inputProps.evaluateProperty(itemPath, inputParamName, actContext, transactionKey), true);
            }
            if (this.getAllInputParams().containsKey(PARAMETER_ITEM) && this.getAllInputParams().get(PARAMETER_ITEM) != null) {
                this.setInputParamValue(PARAMETER_ITEM, item, true);
            }
            if (this.getAllInputParams().containsKey(PARAMETER_AGENT) && this.getAllInputParams().get(PARAMETER_AGENT) != null) {
                ItemProxy systemAgent = Gateway.getProxy(Gateway.getLookup().getAgentPath(SYSTEM_USER, transactionKey), transactionKey);
                this.setInputParamValue(PARAMETER_AGENT, systemAgent, false);
            }
            if (this.getAllInputParams().containsKey(PARAMETER_LOCKER) && this.getAllInputParams().get(PARAMETER_LOCKER) != null) {
                this.setInputParamValue(PARAMETER_LOCKER, transactionKey, true);
            }
            if ((retVal = this.execute()) == null) {
                retVal = "";
            }
            return retVal;
        }
        catch (Exception e) {
            if (e instanceof ScriptingEngineException) {
                throw (ScriptingEngineException)e;
            }
            log.error("evaluate() - Script:{}", (Object)this, (Object)e);
            throw new ScriptingEngineException(e);
        }
    }

    public Object execute() throws ScriptingEngineException {
        this.executeIncludedScripts();
        StringBuffer missingParams = new StringBuffer();
        for (Parameter thisParam : this.mInputParams.values()) {
            if (thisParam.getInitialised()) continue;
            missingParams.append(thisParam.toString()).append(",");
        }
        if (missingParams.length() > 0) {
            throw new ScriptingEngineException("Script:" + String.valueOf(this) + " - parameters were not set:" + missingParams.toString());
        }
        this.initOutputParams();
        Object returnValue = null;
        try {
            log.debug("execute() - Executing script:" + String.valueOf(this));
            log.trace("Script:\n {}", (Object)this.mScript);
            if (this.engine == null) {
                throw new ScriptingEngineException("Script:" + String.valueOf(this) + " - Engine not set. Cannot execute scripts.");
            }
            returnValue = this.mCompScript != null ? this.mCompScript.eval(this.context) : this.engine.eval(this.mScript);
        }
        catch (Exception ex) {
            String msg = "Error executing script " + String.valueOf(this) + ": " + ex.getCause().getMessage();
            log.error(msg, ex.getCause());
            throw new ScriptingEngineException(msg, ex.getCause());
        }
        return this.packScriptReturnValue(returnValue);
    }

    private void executeIncludedScripts() throws ScriptingEngineException {
        for (Script importScript : this.mIncludes) {
            log.debug("executeIncludedScripts() - Script:{}", (Object)importScript);
            if (this.isActExecEnvironment) {
                try {
                    importScript.setActExecEnvironment((ItemProxy)this.context.getAttribute(PARAMETER_ITEM), (AgentProxy)this.context.getAttribute(PARAMETER_AGENT), (Job)this.context.getAttribute(PARAMETER_JOB));
                }
                catch (InvalidDataException e) {
                    log.error("executeIncludedScripts() - name:{}", (Object)importScript, (Object)e);
                    throw new ScriptingEngineException(e);
                }
            }
            importScript.setContext(this.context);
            Object output = importScript.execute();
            if (output == null || !(output instanceof Map)) continue;
            for (Map.Entry outputEntry : ((Map)output).entrySet()) {
                if (!this.mInputParams.containsKey(outputEntry.getKey())) continue;
                try {
                    log.debug("executeIncludedScripts() - Script:{} setting inputs for parameter:{}", (Object)this.mName, outputEntry.getKey());
                    this.setInputParamValue((String)outputEntry.getKey(), outputEntry.getValue(), true);
                }
                catch (ParameterException ex) {
                    String msg = MessageFormatter.format((String)"executeIncludedScripts() - Script:{} cannot set inputs for parameter:{}", (Object)this.mName, outputEntry.getKey()).getMessage();
                    log.error(msg, (Throwable)ex);
                    throw new ScriptingEngineException(msg, ex);
                }
            }
        }
    }

    private void initOutputParams() {
        for (Parameter outputParam : this.mOutputParams.values()) {
            if (StringUtils.isBlank((CharSequence)outputParam.getName())) continue;
            log.debug("initOutputParams() - Initialising output bean:{}", (Object)outputParam);
            Object emptyObject = null;
            try {
                emptyObject = outputParam.getType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                log.warn("initOutputParams() - Script:{} Failed to init output:{} error:{}", new Object[]{this.mName, outputParam, e.getMessage()});
            }
            this.context.getBindings(100).put(outputParam.getName(), (Object)emptyObject);
        }
    }

    private Object packScriptReturnValue(Object returnValue) throws ScriptingEngineException {
        HashMap<String, Object> outputs = new HashMap<String, Object>();
        if (this.mOutputParams.size() == 0) {
            if (returnValue != null) {
                log.trace("packScriptReturnValue(" + String.valueOf(this) + ") - No output params defined, returnValue is NOT null but it is discarded");
            } else {
                log.debug("packScriptReturnValue(" + String.valueOf(this) + ") - No output params defined. Returning null.");
            }
            return null;
        }
        if (this.mOutputParams.size() == 1) {
            Parameter outputParam = this.mOutputParams.values().iterator().next();
            String outputName = outputParam.getName();
            if (StringUtils.isBlank((CharSequence)outputName)) {
                if (returnValue != null && !outputParam.getType().isInstance(returnValue)) {
                    throw new ScriptingEngineException("Script:" + String.valueOf(this) + " returnValue was not instance of " + String.valueOf(outputParam.getType()));
                }
                return returnValue;
            }
            Object output = this.context.getBindings(100).get(outputParam.getName());
            if (output == null) {
                if (!outputName.equals("errors")) {
                    log.debug("packScriptReturnValue(" + String.valueOf(this) + ") - assigning script returnValue to named output '" + outputName + "'");
                    if (returnValue != null && !outputParam.getType().isInstance(returnValue)) {
                        throw new ScriptingEngineException("Script:" + String.valueOf(this) + " returnValue was not instance of " + String.valueOf(outputParam.getType()));
                    }
                    output = returnValue;
                } else {
                    log.debug("packScriptReturnValue(" + String.valueOf(this) + ") - return value for 'errors' is discarded");
                }
            } else if (!outputParam.getType().isInstance(output)) {
                throw new ScriptingEngineException("Script:" + String.valueOf(this) + " returnValue was not instance of " + String.valueOf(outputParam.getType()));
            }
            outputs.put(outputName, output);
            return outputs;
        }
        if (returnValue != null) {
            log.debug("packScriptReturnValue() - returnValue is NOT null but it is discarded");
        }
        for (Parameter outputParam : this.mOutputParams.values()) {
            String outputName = outputParam.getName();
            if (StringUtils.isBlank((CharSequence)outputName)) {
                throw new ScriptingEngineException("Script:" + String.valueOf(this) + " - All outputs must have a name.");
            }
            Object outputValue = this.context.getBindings(100).get(outputParam.getName());
            log.debug("packScriptReturnValue({}) - Output {}={}", new Object[]{this, outputName, outputValue});
            if (outputValue != null && !outputParam.getType().isInstance(outputValue)) {
                throw new ScriptingEngineException("Script:" + String.valueOf(this) + " output '" + outputName + "' was not null and it was not instance of " + String.valueOf(outputParam.getType()) + ", it was a " + String.valueOf(outputValue.getClass()));
            }
            outputs.put(outputParam.getName(), outputValue);
        }
        return outputs;
    }

    public void setScriptData(String script) throws ScriptParsingException {
        this.mScript = script;
        if (this.engine instanceof Compilable) {
            try {
                log.debug("setScriptData() - Compiling script:{}", (Object)this.mName);
                this.engine.put("javax.script.filename", this.mName + "." + this.mLanguage.toLowerCase());
                this.mCompScript = ((Compilable)((Object)this.engine)).compile(this.mScript);
            }
            catch (ScriptException e) {
                log.error("setScriptData() - name:{}", (Object)this.mName, (Object)e);
                throw new ScriptParsingException(e);
            }
        }
    }

    public String getScriptData() {
        try {
            if (StringUtils.isBlank((CharSequence)this.mScriptXML)) {
                this.mScriptXML = this.toXml();
            }
        }
        catch (IOException e) {
            log.error("getScriptData()", (Throwable)e);
        }
        return this.mScriptXML;
    }

    @Override
    public String getItemID() {
        if (this.mItemPath == null || this.mItemPath.getUUID() == null) {
            return "";
        }
        return this.mItemPath.getUUID().toString();
    }

    public static Script getScript(String name, Integer version) throws ScriptingEngineException, ObjectNotFoundException, InvalidDataException {
        return Script.getScript(name, version, null);
    }

    public static Script getScript(String name, Integer version, TransactionKey transactionKey) throws ScriptingEngineException, ObjectNotFoundException, InvalidDataException {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new ScriptingEngineException("Script name is blank");
        }
        if (version != null) {
            return LocalObjectLoader.getScript(name, version, transactionKey);
        }
        String[] tokens = name.split(":");
        if (tokens.length == 2) {
            return new Script(tokens[0], tokens[1]);
        }
        throw new InvalidDataException("Data '" + name + "' cannot be interpreted as expression");
    }

    public ArrayList<Include> getIncludes() {
        ArrayList<Include> returnList = new ArrayList<Include>();
        for (Script s : this.mIncludes) {
            returnList.add(new Include(s.getName(), s.getVersion()));
        }
        return returnList;
    }

    public void setIncludes(ArrayList<Include> includes) throws ObjectNotFoundException, InvalidDataException, ParameterException, ScriptParsingException {
        for (Include i : includes) {
            Script includedScript = new Script(i.name, i.version, null, null);
            includedScript.setContext(this.context);
            this.mIncludes.add(includedScript);
            for (Parameter includeParam : includedScript.getInputParams().values()) {
                this.addIncludedInputParam(includeParam.getName(), includeParam.getType());
            }
        }
    }

    @Override
    public CollectionArrayList makeDescCollections(TransactionKey transactionKey) throws InvalidDataException, ObjectNotFoundException {
        CollectionArrayList retArr = new CollectionArrayList();
        Dependency includeColl = new Dependency(BuiltInCollections.INCLUDE);
        for (Script script : this.mIncludes) {
            try {
                includeColl.addMember(script.getItemPath(), transactionKey);
            }
            catch (InvalidCollectionModification e) {
                log.error("Could not add " + String.valueOf(script) + " to description collection. ", (Throwable)e);
                throw new InvalidDataException("Could not add Script:" + String.valueOf(script) + " to description collection. " + e.getMessage());
            }
            catch (ObjectAlreadyExistsException e) {
                log.error("Script:{} included more than once.", (Object)script, (Object)e);
                throw new InvalidDataException("Script:" + String.valueOf(script) + " included more than once.");
            }
        }
        retArr.put(includeColl);
        return retArr;
    }

    @Override
    public String getXml(boolean prettyPrint) throws InvalidDataException {
        if (prettyPrint) {
            return new Outcome(this.getScriptData()).getData(true);
        }
        return this.getScriptData();
    }

    @Override
    public BuiltInResources getResourceType() {
        return BuiltInResources.SCRIPT_RESOURCE;
    }

    public static void main(String[] args) {
        for (ScriptEngineFactory sef : new ScriptEngineManager().getEngineFactories()) {
            System.out.println(sef.getEngineName() + " v" + sef.getEngineVersion() + " using " + sef.getLanguageName() + " v" + sef.getLanguageVersion() + " " + String.valueOf(sef.getNames()));
        }
        System.out.println("Preferred javascript engine: " + String.valueOf(new ScriptEngineManager().getEngineByName("javascript").getClass()));
    }

    public String toXml() throws IOException {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("name", this.getName());
        vars.put("language", this.getLanguage());
        vars.put("includes", this.mIncludes);
        vars.put("inputs", this.getInputParams().values());
        vars.put("outputs", this.getOutputParams().values());
        vars.put("script", this.mScript);
        return (String)TemplateRuntime.execute((CompiledTemplate)compiledScriptTemplate, vars);
    }

    public String toString() {
        return this.getName() + (String)(log.isDebugEnabled() ? "(v" + this.getVersion() + ")" : "");
    }

    public String getScript() {
        return this.mScript;
    }

    public CompiledScript getCompScript() {
        return this.mCompScript;
    }

    public String getScriptXML() {
        return this.mScriptXML;
    }

    @Override
    public String getNamespace() {
        return this.mNamespace;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public Integer getVersion() {
        return this.mVersion;
    }

    @Override
    public ItemPath getItemPath() {
        return this.mItemPath;
    }

    public String getLanguage() {
        return this.mLanguage;
    }

    public Map<String, Parameter> getInputParams() {
        return this.mInputParams;
    }

    public Map<String, Parameter> getOutputParams() {
        return this.mOutputParams;
    }

    public Map<String, Parameter> getAllInputParams() {
        return this.mAllInputParams;
    }

    public void setScript(String mScript) {
        this.mScript = mScript;
    }

    public void setCompScript(CompiledScript mCompScript) {
        this.mCompScript = mCompScript;
    }

    public void setScriptXML(String mScriptXML) {
        this.mScriptXML = mScriptXML;
    }

    @Override
    public void setNamespace(String mNamespace) {
        this.mNamespace = mNamespace;
    }

    @Override
    public void setName(String mName) {
        this.mName = mName;
    }

    @Override
    public void setVersion(Integer mVersion) {
        this.mVersion = mVersion;
    }

    @Override
    public void setItemPath(ItemPath mItemPath) {
        this.mItemPath = mItemPath;
    }

    public void setLanguage(String mLanguage) {
        this.mLanguage = mLanguage;
    }

    public void setInputParams(Map<String, Parameter> mInputParams) {
        this.mInputParams = mInputParams;
    }

    public void setOutputParams(Map<String, Parameter> mOutputParams) {
        this.mOutputParams = mOutputParams;
    }

    public void setAllInputParams(Map<String, Parameter> mAllInputParams) {
        this.mAllInputParams = mAllInputParams;
    }

    static {
        try {
            String templ = FileStringUtility.url2String(Script.class.getResource(scriptTemplate));
            compiledScriptTemplate = TemplateCompiler.compileTemplate((String)templ);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

