/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.utils;

import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lifecycle.ActivityDef;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.utils.DescriptionObjectCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActDefCache
extends DescriptionObjectCache<ActivityDef> {
    private static final Logger log = LoggerFactory.getLogger(ActDefCache.class);
    Boolean isComposite = null;

    public ActDefCache(Boolean isComposite) {
        this.isComposite = isComposite;
    }

    @Override
    protected String getTypeCode() {
        if (this.isComposite == null) {
            return BuiltInResources.ACTIVITY_DESC_RESOURCE.getTypeCode();
        }
        return this.isComposite != false ? BuiltInResources.COMP_ACT_DESC_RESOURCE.getTypeCode() : BuiltInResources.ELEM_ACT_DESC_RESOURCE.getTypeCode();
    }

    @Override
    protected String getSchemaName() {
        if (this.isComposite == null) {
            return BuiltInResources.ACTIVITY_DESC_RESOURCE.getSchemaName();
        }
        return this.isComposite != false ? BuiltInResources.COMP_ACT_DESC_RESOURCE.getSchemaName() : BuiltInResources.ELEM_ACT_DESC_RESOURCE.getSchemaName();
    }

    @Override
    protected String getTypeRoot() {
        if (this.isComposite == null) {
            return BuiltInResources.ACTIVITY_DESC_RESOURCE.getTypeRoot();
        }
        return this.isComposite != false ? BuiltInResources.COMP_ACT_DESC_RESOURCE.getTypeRoot() : BuiltInResources.ELEM_ACT_DESC_RESOURCE.getTypeRoot();
    }

    @Override
    protected boolean isBootResource(String filename, String resName) {
        if (this.isComposite == null) {
            return filename.endsWith("/" + resName) && (filename.startsWith("CA") || filename.startsWith("EA"));
        }
        return super.isBootResource(filename, resName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected ActivityDef loadObject(ItemProxy proxy, int version, TransactionKey transactionKey) throws ObjectNotFoundException, InvalidDataException {
        String viewName;
        if (this.isComposite == null) {
            String prop = proxy.getProperty(BuiltInItemProperties.COMPLEXITY);
            if ("Composite".equals(prop)) {
                viewName = BuiltInResources.COMP_ACT_DESC_RESOURCE.getSchemaName();
            } else {
                if (!"Elementary".equals(prop)) throw new InvalidDataException("Missing Item property:" + String.valueOf((Object)BuiltInItemProperties.COMPLEXITY));
                viewName = BuiltInResources.ELEM_ACT_DESC_RESOURCE.getSchemaName();
            }
        } else {
            viewName = this.isComposite != false ? BuiltInResources.COMP_ACT_DESC_RESOURCE.getSchemaName() : BuiltInResources.ELEM_ACT_DESC_RESOURCE.getSchemaName();
        }
        try {
            Viewpoint actView = proxy.getViewpoint(viewName, String.valueOf(version), transactionKey);
            String marshalledAct = actView.getOutcome(transactionKey).getData();
            return this.buildObject(proxy.getName(), version, proxy.getPath(), marshalledAct);
        }
        catch (PersistencyException ex) {
            log.error("Problem loading Activity " + String.valueOf(proxy) + " v" + version, (Throwable)ex);
            throw new ObjectNotFoundException("Problem loading Activity " + String.valueOf(proxy) + " v" + version + ": " + ex.getMessage());
        }
    }

    @Override
    protected ActivityDef buildObject(String name, int version, ItemPath path, String data) throws InvalidDataException {
        ActivityDef thisActDef = (ActivityDef)Gateway.getMarshaller().unmarshall(data);
        thisActDef.setBuiltInProperty(BuiltInVertexProperties.VERSION, version);
        thisActDef.setName(name);
        thisActDef.setVersion(version);
        thisActDef.setItemPath(path);
        return thisActDef;
    }
}

