/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.graph.model.BuiltInEdgeProperties;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lifecycle.routingHelpers.DataHelperUtility;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.utils.KeyValuePair;

public class CastorHashMap
extends HashMap<String, Object> {
    private static final long serialVersionUID = -8756025533843275162L;
    ArrayList<String> abstractPropNames = new ArrayList();

    public CastorHashMap() {
        this.clear();
    }

    public KeyValuePair[] getKeyValuePairs() {
        int numKeys = this.size();
        int i = 0;
        KeyValuePair[] keyValuePairs = new KeyValuePair[numKeys];
        Iterator keyIter = this.keySet().iterator();
        for (i = 0; i < numKeys; ++i) {
            if (!keyIter.hasNext()) continue;
            String name = (String)keyIter.next();
            keyValuePairs[i] = new KeyValuePair(name, this.get(name), this.abstractPropNames.contains(name));
        }
        return keyValuePairs;
    }

    public void setKeyValuePairs(KeyValuePair[] keyValuePairs) {
        int i = 0;
        this.clear();
        for (i = 0; i < keyValuePairs.length; ++i) {
            this.setKeyValuePair(keyValuePairs[i]);
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.abstractPropNames = new ArrayList();
    }

    public void setKeyValuePair(KeyValuePair keyValuePair) {
        this.put(keyValuePair.getKey(), keyValuePair.getValue());
        if (keyValuePair.isAbstract()) {
            this.abstractPropNames.add(keyValuePair.getKey());
        } else {
            this.abstractPropNames.remove(keyValuePair.getKey());
        }
    }

    public ArrayList<String> getAbstract() {
        return this.abstractPropNames;
    }

    public boolean isAbstract(BuiltInVertexProperties prop) {
        return this.isAbstract(prop.getName());
    }

    public boolean isAbstract(BuiltInEdgeProperties prop) {
        return this.isAbstract(prop.getName());
    }

    public boolean isAbstract(String propName) {
        return this.abstractPropNames.contains(propName);
    }

    public Object getBuiltInProperty(BuiltInVertexProperties prop) {
        return this.get(prop.getName());
    }

    public Object get(String prop, Object defValue) {
        Object value = this.get(prop);
        if (value == null) {
            return defValue;
        }
        return value;
    }

    public Object getBuiltInProperty(BuiltInVertexProperties prop, Object defValue) {
        return this.get(prop.getName(), defValue);
    }

    public Object getBuiltInProperty(BuiltInEdgeProperties prop) {
        return this.get(prop.getName());
    }

    public Object getBuiltInProperty(BuiltInEdgeProperties prop, Object defValue) {
        return this.get(prop.getName(), defValue);
    }

    public void setBuiltInProperty(BuiltInVertexProperties prop, Object value) {
        this.setBuiltInProperty(prop, value, false);
    }

    public void setBuiltInProperty(BuiltInVertexProperties prop, Object value, boolean isAbstract) {
        this.put(prop.getName(), value, isAbstract);
    }

    public void setBuiltInProperty(BuiltInEdgeProperties prop, Object value) {
        this.setBuiltInProperty(prop, value, false);
    }

    public void setBuiltInProperty(BuiltInEdgeProperties prop, Object value, boolean isAbstract) {
        this.put(prop.getName(), value, isAbstract);
    }

    public void put(String key, Object value, boolean isAbstract) {
        super.put(key, value);
        if (isAbstract) {
            this.abstractPropNames.add(key);
        } else {
            this.abstractPropNames.remove(key);
        }
    }

    public Object evaluateProperty(ItemPath itemPath, String propName, String actContext, TransactionKey transactionKey) throws InvalidDataException, PersistencyException, ObjectNotFoundException {
        if (itemPath != null) {
            return DataHelperUtility.evaluateValue(itemPath, this.get(propName), actContext, transactionKey);
        }
        return this.get(propName);
    }

    public void merge(CastorHashMap newProps) {
        for (KeyValuePair kvPair : newProps.getKeyValuePairs()) {
            this.setKeyValuePair(kvPair);
        }
    }
}

