/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.utils;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.process.resource.ResourceLoader;
import org.cristalise.kernel.querying.Query;
import org.cristalise.kernel.utils.FileStringUtility;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CastorXMLUtility {
    private static final Logger log = LoggerFactory.getLogger(CastorXMLUtility.class);
    private XMLContext mappingContext;

    public CastorXMLUtility(ResourceLoader aResourceLoader, Properties aAppProperties, URL mapURL) throws InvalidDataException {
        String index;
        log.info("<init> Loading maps from [{}]", (Object)mapURL);
        try {
            index = FileStringUtility.url2String(new URL(mapURL, "index"));
        }
        catch (Exception e) {
            throw new InvalidDataException(String.format("Could not load map index from [{}]", mapURL));
        }
        ClassLoader defaultClassLoader = aResourceLoader.getClassLoader(CastorXMLUtility.class.getName());
        log.info("<init>: defaultClassLoader=[{}]", (Object)defaultClassLoader);
        StringTokenizer sTokenizer = new StringTokenizer(index);
        int wNbMap = sTokenizer.countTokens();
        Mapping thisMapping = new Mapping(defaultClassLoader);
        HashSet<String> loadedMapURLs = new HashSet<String>();
        try {
            int wMapIdx = 0;
            while (sTokenizer.hasMoreTokens()) {
                String thisMap = sTokenizer.nextToken();
                String thisMapURL = new URL(mapURL, thisMap).toString();
                ++wMapIdx;
                if (!loadedMapURLs.contains(thisMapURL)) {
                    log.info("<init>: Adding mapping file ({}/{}):[{}]", new Object[]{wMapIdx, wNbMap, thisMapURL});
                    thisMapping.loadMapping(new URL(thisMapURL));
                    loadedMapURLs.add(thisMapURL);
                    continue;
                }
                log.info("Map file already loaded:" + thisMapURL);
            }
            this.mappingContext = new XMLContext();
            this.mappingContext.setClassLoader(defaultClassLoader);
            this.mappingContext.addMapping(thisMapping);
        }
        catch (IOException | MappingException ex) {
            log.error("ctor() - Could not initialise", ex);
            throw new InvalidDataException("Could not initialise", ex);
        }
        log.info("Loaded [{}] maps from [{}]", (Object)loadedMapURLs.size(), (Object)mapURL);
    }

    public String marshall(Object obj) throws InvalidDataException {
        try {
            if (obj == null) {
                return "<NULL/>";
            }
            if (obj instanceof Outcome) {
                return ((Outcome)obj).getData();
            }
            StringWriter sWriter = new StringWriter();
            Marshaller marshaller = this.mappingContext.createMarshaller();
            marshaller.setWriter((Writer)sWriter);
            marshaller.setMarshalAsDocument(false);
            if (obj instanceof Query) {
                marshaller.addProcessingInstruction("javax.xml.transform.disable-output-escaping", "");
            }
            marshaller.marshal(obj);
            return sWriter.toString();
        }
        catch (IOException | MarshalException | ValidationException ex) {
            log.error("marshall() - failed", ex);
            throw new InvalidDataException("marshall failed", ex);
        }
    }

    public Object unmarshall(String data) throws InvalidDataException {
        if (data.equals("<NULL/>")) {
            return null;
        }
        StringReader sReader = new StringReader(data);
        try {
            return this.mappingContext.createUnmarshaller().unmarshal((Reader)sReader);
        }
        catch (MarshalException | ValidationException ex) {
            log.error("unmarshall() - failed", ex);
            throw new InvalidDataException("unmarshall failed", ex);
        }
    }
}

