/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.utils;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.cristalise.kernel.SystemProperties;
import org.cristalise.kernel.collection.BuiltInCollections;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.collection.DependencyMember;
import org.cristalise.kernel.common.CriseVertxException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.utils.FileStringUtility;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public interface DescriptionObject {
    public String getNamespace();

    public String getName();

    public Integer getVersion();

    public ItemPath getItemPath();

    public void setNamespace(String var1);

    public void setName(String var1);

    public void setVersion(Integer var1);

    public void setItemPath(ItemPath var1);

    public String getItemID();

    public BuiltInResources getResourceType();

    default public String getXml(boolean prettyPrint) throws InvalidDataException {
        String xml = Gateway.getMarshaller().marshall(this);
        if (prettyPrint) {
            return new Outcome(xml).getData(true);
        }
        return xml;
    }

    default public String getXml() throws InvalidDataException {
        return this.getXml(true);
    }

    public CollectionArrayList makeDescCollections(TransactionKey var1) throws InvalidDataException, ObjectNotFoundException;

    default public void export(Writer imports, File dir, boolean shallow) throws InvalidDataException, ObjectNotFoundException, IOException {
        BuiltInResources type = this.getResourceType();
        String versionPostfix = this.getVersion() == null ? "" : "_" + this.getVersion();
        String extention = type == BuiltInResources.SCHEMA_RESOURCE ? ".xsd" : ".xml";
        String fileName = this.getName() + versionPostfix + extention;
        File newFile = new File(new File(dir, type.getTypeCode()), fileName);
        FileStringUtility.string2File(newFile, this.getXml());
        if (imports == null) {
            return;
        }
        if (SystemProperties.Resource_useOldImportFormat.getBoolean().booleanValue()) {
            imports.write("<Resource name='" + this.getName() + "' " + (String)(this.getItemPath() == null ? "" : "id='" + this.getItemID() + "' ") + (String)(this.getVersion() == null ? "" : "version='" + this.getVersion() + "' ") + "type='" + type.getTypeCode() + "'>boot/" + type.getTypeCode() + "/" + fileName + "</Resource>\n");
        } else {
            imports.write("<" + type.getSchemaName() + "Resource name='" + this.getName() + "' " + (String)(this.getItemPath() == null ? "" : "id='" + this.getItemID() + "' ") + (String)(this.getVersion() == null ? "" : "version='" + this.getVersion() + "'") + "/>\n");
        }
    }

    default public Dependency makeDescCollection(BuiltInCollections collection, TransactionKey transactionKey, DescriptionObject ... descs) throws InvalidDataException {
        Dependency descDep = new Dependency(collection.getName());
        if (this.getVersion() != null && this.getVersion() > -1) {
            descDep.setVersion(this.getVersion());
        }
        for (DescriptionObject thisDesc : descs) {
            if (thisDesc == null) continue;
            try {
                DependencyMember descMem = descDep.addMember(thisDesc.getItemPath(), transactionKey);
                descMem.setBuiltInProperty(BuiltInVertexProperties.VERSION, thisDesc.getVersion());
            }
            catch (Exception e) {
                throw new InvalidDataException(e);
            }
        }
        return descDep;
    }

    default public Outcome toOutcome() throws CriseVertxException, MarshalException, ValidationException, IOException, MappingException {
        String schemaName = this.getResourceType().getSchemaName();
        Schema schema = LocalObjectLoader.getSchema(schemaName, 0);
        return new Outcome(this.getXml(false), schema);
    }

    default public boolean exists(TransactionKey transactionKey) {
        String path = this.getResourceType().getTypeRoot() + "/" + this.getNamespace() + "/" + this.getName();
        return new DomainPath(path).exists(transactionKey);
    }
}

