/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.SystemProperties;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Lookup;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.module.Module;
import org.cristalise.kernel.process.module.ModuleResource;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyDescription;
import org.cristalise.kernel.property.PropertyDescriptionList;
import org.cristalise.kernel.utils.DescriptionObject;
import org.cristalise.kernel.utils.FileStringUtility;
import org.cristalise.kernel.utils.SoftCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DescriptionObjectCache<D extends DescriptionObject> {
    private static final Logger log = LoggerFactory.getLogger(DescriptionObjectCache.class);
    SoftCache<String, CacheEntry<D>> cache = new SoftCache();
    Property[] classIdProps;

    public DescriptionObjectCache() {
        try {
            String propDescXML = Gateway.getResource().findTextResource("boot/property/" + this.getTypeCode() + "Prop.xml");
            PropertyDescriptionList propDescs = (PropertyDescriptionList)Gateway.getMarshaller().unmarshall(propDescXML);
            ArrayList<Property> classIdPropList = new ArrayList<Property>();
            for (PropertyDescription propDesc : propDescs.list) {
                if (!propDesc.getIsClassIdentifier()) continue;
                classIdPropList.add(propDesc.getProperty());
            }
            this.classIdProps = classIdPropList.toArray(new Property[classIdPropList.size()]);
        }
        catch (Exception ex) {
            log.error("Could not load property description for " + this.getTypeCode() + ". Cannot filter.", (Throwable)ex);
            this.classIdProps = new Property[0];
        }
    }

    private D loadObjectFromBootstrap(String name) throws InvalidDataException, ObjectNotFoundException {
        try {
            log.debug("loadObjectFromBootstrap() - name:{} typeCode:{}", (Object)name, (Object)this.getTypeCode());
            String bootItems = FileStringUtility.url2String(Gateway.getResource().getKernelResourceURL("boot/allbootitems.txt"));
            StringTokenizer str = new StringTokenizer(bootItems, "\n\r");
            while (str.hasMoreTokens()) {
                String resLine = str.nextToken();
                String[] resElem = resLine.split(",");
                String uuid = resElem[0];
                String path = resElem[1];
                if (!uuid.equals(name) && !this.isBootResource(path, name)) continue;
                String textResourcePath = "boot/" + path + (path.startsWith("OD") ? ".xsd" : ".xml");
                log.trace("loadObjectFromBootstrap() - FOUND in KERNEL uuid:{} textResourcePath:{}", (Object)uuid, (Object)textResourcePath);
                String resData = Gateway.getResource().getTextResource(null, textResourcePath);
                String realName = path.split("/")[1];
                return this.buildObject(realName, 0, new ItemPath(uuid), resData);
            }
            for (Module module : Gateway.getModuleManager().getModules()) {
                ModuleResource res = (ModuleResource)module.getImports().findImport(name, this.getTypeCode());
                if (res == null) continue;
                res.setNs(module.getNs());
                log.trace("loadObjectFromBootstrap() - FOUND in module:{} textResourcePath:{}", (Object)module.getName(), (Object)res.getResourceFileName());
                String resData = Gateway.getResource().getTextResource(module.getNs(), res.getResourceFileName());
                String uuid = res.getID() == null ? UUID.randomUUID().toString() : res.getID();
                return this.buildObject(name, 0, new ItemPath(uuid), resData);
            }
        }
        catch (Exception e) {
            String msg = "name:" + name + " typeCode:" + this.getTypeCode();
            log.error("loadObjectFromBootstrap() cannot find resource {}", (Object)msg, (Object)e);
            throw new InvalidDataException("Cannot find resource " + msg);
        }
        throw new ObjectNotFoundException("Resource " + this.getSchemaName() + " " + name + " not found in bootstrap resources");
    }

    protected boolean isBootResource(String filename, String resName) {
        return filename.equals(this.getTypeCode() + "/" + resName);
    }

    private ItemPath findItemInDatabase(String id, TransactionKey transactionKey) throws ObjectNotFoundException, InvalidDataException {
        if (Gateway.getLookup() == null) {
            throw new ObjectNotFoundException("Cannot find Items without a Lookup");
        }
        if (ItemPath.isUUID(id)) {
            try {
                ItemPath resItem = new ItemPath(id);
                if (resItem.exists(transactionKey)) {
                    return resItem;
                }
            }
            catch (InvalidItemPathException resItem) {}
        } else if (id.contains("/")) {
            DomainPath directPath = new DomainPath(id);
            if (directPath.exists(transactionKey) && directPath.getItemPath(transactionKey) != null) {
                return directPath.getItemPath(transactionKey);
            }
        } else {
            Iterator<Path> searchResult = null;
            boolean lookupUseProperties = SystemProperties.LocalObjectLoader_lookupUseProperties.getBoolean();
            if (lookupUseProperties || StringUtils.isBlank((CharSequence)this.getTypeRoot())) {
                Property[] searchProps = new Property[this.classIdProps.length + 1];
                searchProps[0] = new Property(BuiltInItemProperties.NAME, id);
                System.arraycopy(this.classIdProps, 0, searchProps, 1, this.classIdProps.length);
                searchResult = Gateway.getLookup().search((Path)new DomainPath(this.getTypeRoot()), transactionKey, searchProps);
            } else {
                searchResult = Gateway.getLookup().search((Path)new DomainPath(this.getTypeRoot()), id, Lookup.SearchConstraints.EXACT_NAME_MATCH, transactionKey);
            }
            if (searchResult.hasNext()) {
                Path defPath = searchResult.next();
                if (searchResult.hasNext()) {
                    throw new InvalidDataException("Too many matches for id:" + id + " typeCode:" + this.getTypeCode());
                }
                if (defPath.getItemPath(transactionKey) == null) {
                    throw new InvalidDataException("id:" + id + " typeCode:" + this.getTypeCode() + " was found, but was not an Item");
                }
                return defPath.getItemPath(transactionKey);
            }
        }
        throw new ObjectNotFoundException("No match for id:" + id + " typeCode:" + this.getTypeCode());
    }

    private D findInCache(String id, int version) {
        String key = id + "_" + version;
        CacheEntry<D> cacheEntry = this.cache.get(key);
        if (cacheEntry != null) {
            log.trace("findInCache() - key:{} found in cache.", (Object)key);
            return (D)cacheEntry.descObject;
        }
        return null;
    }

    private D findInCache(ItemPath resourcePath, int version, TransactionKey transactionKey) {
        String realName = resourcePath.getItemName(transactionKey);
        String realUuid = resourcePath.getName();
        D resourceItem = this.findInCache(realUuid, version);
        if (resourceItem == null) {
            resourceItem = this.findInCache(realName, version);
        }
        if (resourceItem != null) {
            return resourceItem;
        }
        return null;
    }

    private void addToCache(D resourceItem) {
        CacheEntry newEntry = new CacheEntry(this, resourceItem, this);
        this.cache.put(newEntry.uuidKey, newEntry);
        this.cache.put(newEntry.nameKey, newEntry);
    }

    public D get(String id, int version) throws ObjectNotFoundException, InvalidDataException {
        return this.get(id, version, null);
    }

    public synchronized D get(String id, int version, TransactionKey transactionKey) throws ObjectNotFoundException, InvalidDataException {
        String key = id + "_" + version;
        D resourceItem = this.findInCache(id, version);
        if (resourceItem != null) {
            return resourceItem;
        }
        try {
            log.trace("get() - key:{} not found in cache, loading from database.", (Object)key);
            ItemPath resourcePath = this.findItemInDatabase(id, transactionKey);
            resourceItem = this.findInCache(resourcePath, version, transactionKey);
            if (resourceItem != null) {
                return resourceItem;
            }
            resourceItem = this.loadObject(Gateway.getProxy(resourcePath, transactionKey), version, transactionKey);
            this.addToCache(resourceItem);
            return resourceItem;
        }
        catch (ObjectNotFoundException ex) {
            log.trace("get() - key:{} not found in database, loading from bootstrap.", (Object)key);
            if (version == 0) {
                try {
                    return this.loadObjectFromBootstrap(id);
                }
                catch (ObjectNotFoundException ex2) {
                    log.error("get() - ", (Throwable)ex2);
                }
            } else {
                log.error("get() - only resources with version zero can be loaded from classpath - key:{}", (Object)key);
            }
            throw ex;
        }
    }

    protected abstract String getTypeCode();

    protected abstract String getSchemaName();

    protected abstract String getTypeRoot();

    protected abstract D buildObject(String var1, int var2, ItemPath var3, String var4) throws InvalidDataException;

    protected D loadObject(ItemProxy proxy, int version, TransactionKey transactionKey) throws ObjectNotFoundException, InvalidDataException {
        try {
            Viewpoint view = proxy.getViewpoint(this.getSchemaName(), String.valueOf(version), transactionKey);
            String rawRes = view.getOutcome(transactionKey).getData();
            return this.buildObject(proxy.getName(), version, proxy.getPath(), rawRes);
        }
        catch (PersistencyException ex) {
            log.error("loadObject() - Problem loading " + this.getSchemaName() + " " + String.valueOf(proxy) + " v" + version, (Throwable)ex);
            throw new ObjectNotFoundException("Problem loading " + this.getSchemaName() + " " + String.valueOf(proxy) + " v" + version + ": " + ex.getMessage());
        }
    }

    public synchronized void invalidate(ItemPath ip, int version) {
        this.invalidate(ip.getName(), ip.getItemName(), version);
    }

    public synchronized void invalidate(String uuid, String name, int version) {
        this.cache.remove(uuid + "_" + version);
        this.cache.remove(name + "_" + version);
    }

    public synchronized void invalidate() {
        this.cache.clear();
    }

    protected class CacheEntry<E extends DescriptionObject> {
        public String uuidKey;
        public String nameKey;
        public E descObject;

        public CacheEntry(E this$0, DescriptionObjectCache<E> def) {
            this.uuidKey = def.getItemID() + "_" + def.getVersion();
            this.nameKey = def.getName() + "_" + def.getVersion();
            this.descObject = def;
        }

        public String toString() {
            return "Cache entry: " + this.uuidKey;
        }
    }
}

