/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.utils;

import java.util.Properties;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.converters.StringConverter;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.process.Gateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface SystemPropertyOperations {
    public static final Logger enumLogger = LoggerFactory.getLogger(SystemPropertyOperations.class);

    public String getSystemPropertyName();

    public Object getDefaultValue();

    default public String getActualName(Object ... nameArgs) {
        return nameArgs == null ? this.getSystemPropertyName() : String.format(this.getSystemPropertyName(), nameArgs);
    }

    default public Object getObject() {
        return this.getObject((Object)null, (Object[])null);
    }

    default public Object getObject(Object defaultOverwrite) {
        return this.getObject(defaultOverwrite, (Object[])null);
    }

    default public Object getObject(Object ... nameArgs) {
        return this.getObject((Object)null, nameArgs);
    }

    default public Object getObject(Object defaultOverwrite, Object ... nameArgs) {
        String actualName = this.getActualName(nameArgs);
        Object actualDefaultValue = defaultOverwrite == null ? this.getDefaultValue() : defaultOverwrite;
        Object actualValue = Gateway.getProperties().get(actualName);
        enumLogger.trace("getObject() - {} => {} (default:{})", new Object[]{actualName, actualValue, actualDefaultValue});
        if (actualDefaultValue == null) {
            return actualValue;
        }
        if (actualValue == null) {
            return actualDefaultValue;
        }
        return actualValue;
    }

    default public String getString() {
        return this.getString(null, (Object[])null);
    }

    default public String getString(String defaultOverwrite) {
        return this.getString(defaultOverwrite, (Object[])null);
    }

    default public String getString(Object ... nameArgs) {
        return this.getString(null, nameArgs);
    }

    default public String getString(String defaultOverwrite, Object ... nameArgs) {
        Object actualValue = this.getObject((Object)defaultOverwrite, nameArgs);
        if (enumLogger.isDebugEnabled()) {
            enumLogger.trace("getString() - {} => {}", (Object)this.getActualName(nameArgs), actualValue);
        }
        if (actualValue != null) {
            return ((String)new StringConverter(null).convert(String.class, actualValue)).trim();
        }
        return null;
    }

    default public Integer getInteger() {
        return this.getInteger(null, (Object[])null);
    }

    default public Integer getInteger(Integer defaultOverwrite) {
        return this.getInteger(defaultOverwrite, (Object[])null);
    }

    default public Integer getInteger(Object ... args) {
        return this.getInteger(null, args);
    }

    default public Integer getInteger(Integer defaultOverwrite, Object ... args) {
        Object actualValue = this.getObject((Object)defaultOverwrite, args);
        if (enumLogger.isDebugEnabled()) {
            enumLogger.trace("getInteger() - {} => {}", (Object)this.getActualName(args), actualValue);
        }
        if (actualValue != null) {
            return (Integer)new IntegerConverter(null).convert(Integer.class, actualValue);
        }
        return null;
    }

    default public Boolean getBoolean() {
        return this.getBoolean(null, (Object[])null);
    }

    default public Boolean getBoolean(Boolean defaultOverwrite) {
        return this.getBoolean(defaultOverwrite, (Object[])null);
    }

    default public Boolean getBoolean(Object ... args) {
        return this.getBoolean(null, args);
    }

    default public Boolean getBoolean(Boolean defaultOverwrite, Object ... args) {
        Object actualValue = this.getObject((Object)defaultOverwrite, args);
        if (enumLogger.isDebugEnabled()) {
            enumLogger.trace("getBoolean() - {} => {}", (Object)this.getActualName(args), actualValue);
        }
        if (actualValue != null) {
            return (Boolean)new BooleanConverter(null).convert(Boolean.class, actualValue);
        }
        return null;
    }

    default public Object getInstance(Object ... nameArgs) throws ReflectiveOperationException {
        String actualValue = this.getString(nameArgs);
        if (enumLogger.isDebugEnabled()) {
            enumLogger.trace("getInstance() - {} => {}", (Object)this.getActualName(nameArgs), (Object)actualValue);
        }
        if (StringUtils.isBlank((CharSequence)actualValue)) {
            throw new InstantiationException("SystemProperty '" + this.getActualName(nameArgs) + "' was not defined.");
        }
        return Class.forName(actualValue).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    default public Object set(Object value) {
        return Gateway.getProperties().put(this.getSystemPropertyName(), value);
    }

    default public Object set(Properties props, Object value) {
        return props.put(this.getSystemPropertyName(), value);
    }
}

