/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.utils;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class WeakCache<K, V>
extends AbstractMap<K, V> {
    private final Map<K, WeakValue<V>> hash = new HashMap<K, WeakValue<V>>();
    private final int minSize;
    private final LinkedList<V> hardCache = new LinkedList();
    private final ReferenceQueue<V> queue = new ReferenceQueue();

    public WeakCache() {
        this(0);
    }

    public WeakCache(int minSize) {
        this.minSize = minSize;
    }

    @Override
    public V get(Object key) {
        Object result = null;
        WeakValue<V> weak_ref = this.hash.get(key);
        if (weak_ref != null) {
            result = weak_ref.get();
            if (result == null) {
                this.hash.remove(key);
            } else if (this.minSize > 0) {
                this.hardCache.addFirst(result);
                if (this.hardCache.size() > this.minSize) {
                    this.hardCache.removeLast();
                }
            }
        }
        return (V)result;
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        if (this.minSize > 0) {
            this.hardCache.addFirst(value);
            if (this.hardCache.size() > this.minSize) {
                this.hardCache.removeLast();
            }
        }
        this.hash.put(key, new WeakValue<V>(key, value, this.queue));
        return value;
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        if (this.hash.containsKey(key)) {
            return (V)this.hash.remove(key).get();
        }
        return null;
    }

    @Override
    public void clear() {
        this.hardCache.clear();
        while (this.queue.poll() != null) {
        }
        this.hash.clear();
    }

    @Override
    public int size() {
        this.processQueue();
        return this.hash.size();
    }

    @Override
    public Set<K> keySet() {
        this.processQueue();
        return this.hash.keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    private void processQueue() {
        WeakValue sv;
        while ((sv = (WeakValue)this.queue.poll()) != null) {
            this.hash.remove(sv.key);
        }
    }

    private static class WeakValue<V>
    extends WeakReference<V> {
        private final Object key;

        private WeakValue(Object key, V value, ReferenceQueue<V> q) {
            super(value, q);
            this.key = key;
        }
    }
}

