/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.storage;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterStorage;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.querying.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryOnlyClusterStorage
extends ClusterStorage {
    private static final Logger log = LoggerFactory.getLogger(MemoryOnlyClusterStorage.class);
    Map<ItemPath, Map<String, C2KLocalObject>> memoryCache = new HashMap<ItemPath, Map<String, C2KLocalObject>>();

    public void clear() {
        this.memoryCache.clear();
    }

    @Override
    public void open() throws PersistencyException {
    }

    @Override
    public void close() throws PersistencyException {
    }

    @Override
    public boolean checkQuerySupport(String language) {
        log.warn("MemoryOnlyClusterStorage DOES NOT Support any query");
        return false;
    }

    @Override
    public short queryClusterSupport(ClusterType clusterType) {
        return 3;
    }

    @Override
    public String getName() {
        return "Memory Cache";
    }

    @Override
    public String getId() {
        return "Memory Cache";
    }

    @Override
    public String executeQuery(Query query, TransactionKey transactionKey) throws PersistencyException {
        throw new PersistencyException("UNIMPLEMENTED funnction");
    }

    @Override
    public C2KLocalObject get(ItemPath thisItem, String path, TransactionKey transactionKey) throws PersistencyException {
        Map<String, C2KLocalObject> sysKeyMemCache = this.memoryCache.get(thisItem);
        if (sysKeyMemCache != null) {
            return sysKeyMemCache.get(path);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(ItemPath thisItem, C2KLocalObject obj, TransactionKey transactionKey) throws PersistencyException {
        Map<Object, Object> sysKeyMemCache;
        Map<ItemPath, Map<String, C2KLocalObject>> map = this.memoryCache;
        synchronized (map) {
            if (this.memoryCache.containsKey(thisItem)) {
                sysKeyMemCache = this.memoryCache.get(thisItem);
            } else {
                sysKeyMemCache = new HashMap();
                this.memoryCache.put(thisItem, sysKeyMemCache);
            }
        }
        String path = ClusterStorage.getPath(obj);
        Map<Object, Object> map2 = sysKeyMemCache;
        synchronized (map2) {
            sysKeyMemCache.put(path, obj);
        }
    }

    private void removeCluster(ItemPath itemPath, String path, TransactionKey transactionKey) throws PersistencyException {
        String[] children;
        for (String element : children = this.getClusterContents(itemPath, path, transactionKey)) {
            this.removeCluster(itemPath, path + (path.length() > 0 ? "/" : "") + element, transactionKey);
        }
        if (children.length == 0 && path.indexOf("/") > -1) {
            this.delete(itemPath, path, transactionKey);
        }
    }

    @Override
    public void delete(ItemPath itemPath, TransactionKey transactionKey) throws PersistencyException {
        this.removeCluster(itemPath, "", transactionKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(ItemPath thisItem, ClusterType cluster, TransactionKey transactionKey) throws PersistencyException {
        Map<String, C2KLocalObject> sysKeyMemCache = this.memoryCache.get(thisItem);
        if (sysKeyMemCache != null) {
            Map<String, C2KLocalObject> map = sysKeyMemCache;
            synchronized (map) {
                sysKeyMemCache.keySet().removeIf(key -> key.startsWith(cluster.getName()));
                if (sysKeyMemCache.isEmpty()) {
                    this.memoryCache.remove(thisItem);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(ItemPath thisItem, String path, TransactionKey transactionKey) throws PersistencyException {
        Map<String, C2KLocalObject> sysKeyMemCache = this.memoryCache.get(thisItem);
        if (sysKeyMemCache != null) {
            Map<String, C2KLocalObject> map = sysKeyMemCache;
            synchronized (map) {
                if (sysKeyMemCache.containsKey(path)) {
                    sysKeyMemCache.remove(path);
                    if (sysKeyMemCache.isEmpty()) {
                        this.memoryCache.remove(thisItem);
                    }
                }
            }
        }
    }

    @Override
    public String[] getClusterContents(ItemPath thisItem, String path, TransactionKey transactionKey) throws PersistencyException {
        Map<String, C2KLocalObject> sysKeyMemCache = this.memoryCache.get(thisItem);
        ArrayList<String> result = new ArrayList<String>();
        if (sysKeyMemCache != null) {
            while (((String)path).endsWith("/")) {
                path = ((String)path).substring(0, ((String)path).length() - 1);
            }
            path = (String)path + "/";
            for (String thisPath : sysKeyMemCache.keySet()) {
                String end;
                int slash;
                String suffix;
                if (!thisPath.startsWith((String)path) || result.contains(suffix = (slash = (end = thisPath.substring(((String)path).length())).indexOf(47)) > -1 ? end.substring(0, slash) : end)) continue;
                result.add(suffix);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String[] getClusterContents(ItemPath itemPath, ClusterType type, TransactionKey transactionKey) throws PersistencyException {
        return this.getClusterContents(itemPath, type.getName(), transactionKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpContents(ItemPath thisItem) {
        Map<ItemPath, Map<String, C2KLocalObject>> map = this.memoryCache;
        synchronized (map) {
            log.info("Cached Objects of Entity " + String.valueOf(thisItem));
            Map<String, C2KLocalObject> sysKeyMemCache = this.memoryCache.get(thisItem);
            if (sysKeyMemCache == null) {
                log.info("No cache found");
                return;
            }
            try {
                Map<String, C2KLocalObject> map2 = sysKeyMemCache;
                synchronized (map2) {
                    Iterator<String> iterator = sysKeyMemCache.keySet().iterator();
                    while (iterator.hasNext()) {
                        String name;
                        String path = name = iterator.next();
                        try {
                            log.info("    Path " + path + ": " + sysKeyMemCache.get(path).getClass().getName());
                        }
                        catch (NullPointerException e) {
                            log.info("    Path " + path + ": reaped");
                        }
                    }
                }
            }
            catch (ConcurrentModificationException ex) {
                log.info("Cache modified - aborting");
            }
        }
        log.info("Total number of cached entities: " + this.memoryCache.size());
    }

    @Override
    public void postBoostrap() {
    }

    @Override
    public void postStartServer() {
    }

    @Override
    public void postConnect() {
    }

    @Override
    public int getLastIntegerId(ItemPath itemPath, String path, TransactionKey transactionKey) throws PersistencyException {
        int lastId = -1;
        try {
            String[] keys;
            for (String key : keys = this.getClusterContents(itemPath, path, transactionKey)) {
                int newId = Integer.parseInt(key);
                lastId = newId > lastId ? newId : lastId;
            }
        }
        catch (NumberFormatException e) {
            log.error("Error parsing keys", (Throwable)e);
            throw new PersistencyException(e.getMessage());
        }
        return lastId;
    }

    @Override
    public void begin(TransactionKey transactionKey) throws PersistencyException {
    }

    @Override
    public void commit(TransactionKey transactionKey) throws PersistencyException {
    }

    @Override
    public void abort(TransactionKey transactionKey) throws PersistencyException {
    }
}

