/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import java.net.URI;
import java.util.LinkedHashMap;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.agent.Job;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.restapi.ItemUtils;
import org.cristalise.restapi.RemoteMapAccess;

@Path(value="/agent/{uuid}")
public class AgentJobList
extends RemoteMapAccess {
    @GET
    @Path(value="job")
    @Produces(value={"application/json"})
    public Response list(@PathParam(value="uuid") String uuid, @DefaultValue(value="0") @QueryParam(value="start") Integer start, @QueryParam(value="batch") Integer batchSize, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        ItemProxy item = AgentJobList.getProxy(uuid);
        if (!(item instanceof AgentProxy)) {
            throw ItemUtils.createWebAppException("UUID does not belong to an Agent", Response.Status.BAD_REQUEST);
        }
        if (batchSize == null) {
            batchSize = Gateway.getProperties().getInt("REST.Job.DefaultBatchSize", Gateway.getProperties().getInt("REST.DefaultBatchSize", 20));
        }
        LinkedHashMap<String, Object> jobs = super.list(item, "Job", start, batchSize, uri);
        for (String key : jobs.keySet()) {
            Object obj = jobs.get(key);
            if (!(obj instanceof Job)) continue;
            Job job = (Job)obj;
            try {
                jobs.put(key, this.makeJobData(job, job.getItemProxy().getName(), uri));
            }
            catch (ObjectNotFoundException e) {
                jobs.put(key, "ERROR: Item " + job.getItemUUID() + " not found");
            }
            catch (InvalidItemPathException e) {
                jobs.put(key, "ERROR: Invalid Item UUID in Job:" + job.getItemUUID());
            }
        }
        return this.toJSON(jobs);
    }

    @GET
    @Path(value="job/{jobId}")
    @Produces(value={"application/json"})
    public Response getEvent(@PathParam(value="uuid") String uuid, @PathParam(value="jobId") String jobId, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        ItemProxy item = AgentJobList.getProxy(uuid);
        if (!(item instanceof AgentProxy)) {
            throw ItemUtils.createWebAppException("UUID does not belong to an Agent", Response.Status.BAD_REQUEST);
        }
        Job job = (Job)this.get(item, "Job", jobId);
        try {
            return this.toJSON(this.makeJobData(job, job.getItemProxy().getName(), uri));
        }
        catch (ObjectNotFoundException e) {
            throw ItemUtils.createWebAppException("Item " + job.getItemUUID() + " in Job not found");
        }
        catch (InvalidItemPathException e) {
            throw ItemUtils.createWebAppException("Invalid Item UUID in Job " + job.getItemUUID() + " in Job not found");
        }
    }

    @GET
    @Path(value="roles")
    @Produces(value={"application/json"})
    public Response getRoles(@PathParam(value="uuid") String uuid, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        ItemProxy item = AgentJobList.getProxy(uuid);
        if (!(item instanceof AgentProxy)) {
            throw ItemUtils.createWebAppException("UUID does not belong to an Agent", Response.Status.BAD_REQUEST);
        }
        AgentProxy agent = (AgentProxy)item;
        RolePath[] roles = Gateway.getLookup().getRoles(agent.getPath());
        LinkedHashMap<String, URI> roleData = new LinkedHashMap<String, URI>();
        for (RolePath role : roles) {
            roleData.put(role.getName(), uri.getBaseUriBuilder().path("role").path(role.getName()).build(new Object[0]));
        }
        return this.toJSON(roleData);
    }
}

